/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.ContributorRewardHandler;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.client.gui.GuiButtonTranslucent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageRequestEmote;
import vazkii.quark.vanity.client.emotes.CustomEmoteIconResourcePack;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteHandler;
import vazkii.quark.vanity.client.emotes.ModelAccessor;
import vazkii.quark.vanity.client.gui.GuiButtonEmote;

public class EmoteSystem
extends Feature {
    private static final String[] EMOTE_NAMES = new String[]{"no", "yes", "wave", "salute", "cheer", "clap", "think", "point", "shrug", "headbang", "weep", "facepalm"};
    private static final Set<String> PATREON_EMOTES = ImmutableSet.of((Object)"dance", (Object)"tpose", (Object)"dab", (Object)"jet", (Object)"exorcist", (Object)"zombie", (Object[])new String[0]);
    public static final int EMOTE_BUTTON_WIDTH = 25;
    public static final int EMOTES_PER_ROW = 3;
    private static final List<String> EMOTE_NAME_LIST = Lists.newArrayList((Object[])EMOTE_NAMES);
    private static final int EMOTE_BUTTON_START = 1800;
    public static boolean emotesVisible = false;
    public static boolean customEmoteDebug;
    public static boolean emoteCommands;
    public static File emotesDir;
    @SideOnly(value=Side.CLIENT)
    public static CustomEmoteIconResourcePack resourcePack;
    private String[] enabledEmotes;
    private String[] customEmotes;
    private boolean enableKeybinds;

    @Override
    public void setupConfig() {
        this.enableKeybinds = this.loadPropBool("Enable Keybinds", "Should keybinds for emotes be generated? (They're all unbound by default)", true);
        this.enabledEmotes = this.loadPropStringList("Enabled Emotes", "The enabled default emotes. Remove from this list to disable them. You can also re-order them, if you feel like it.", EMOTE_NAMES);
        this.customEmotes = this.loadPropStringList("Custom Emotes", "The list of Custom Emotes to be loaded.\nWatch the tutorial on Custom Emotes to learn how to make your own: https://youtu.be/ourHUkan6aQ", new String[0]);
        customEmoteDebug = this.loadPropBool("Custom Emote Dev Mode", "Enable this to make custom emotes read the file every time they're triggered so you can edit on the fly.\nDO NOT ship enabled this in a modpack, please.", false);
        emoteCommands = this.loadPropBool("Custom Emote Functions", "Allow custom emotes to run function files when a user prompts them.\nTo attach a function file to any given emote, simply place a .mcfunction file with the same name as your .emote file (sans extension) in /quark_emotes.\nCommand output from emote functions is enabled only if both \"Custom Emote Dev Mode\" and the \"commandBlockOutput\" gamerule are enabled. ", false);
        emotesDir = new File(ModuleLoader.configFile.getParent(), "quark_emotes");
        if (!emotesDir.exists() && !emotesDir.mkdir()) {
            this.customEmotes = new String[0];
        }
    }

    public static void addResourcePack(List<IResourcePack> packs) {
        resourcePack = new CustomEmoteIconResourcePack();
        packs.add((IResourcePack)resourcePack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        Tween.registerAccessor(ModelBiped.class, ModelAccessor.INSTANCE);
        for (String string : this.enabledEmotes) {
            if (!EMOTE_NAME_LIST.contains(string)) continue;
            EmoteHandler.addEmote(string);
        }
        for (String s : PATREON_EMOTES) {
            EmoteHandler.addEmote(s);
        }
        for (String string : this.customEmotes) {
            EmoteHandler.addCustomEmote(string);
        }
        if (this.enableKeybinds) {
            ModKeybinds.initEmoteKeybinds();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiChat) {
            List descriptors;
            List list = event.getButtonList();
            list.add(new GuiButtonTranslucent(1800, gui.field_146294_l - 1 - 75, gui.field_146295_m - 40, 75, 20, I18n.func_135052_a((String)"quark.gui.emotes", (Object[])new Object[0])));
            TIntObjectHashMap descriptorSorting = new TIntObjectHashMap();
            for (EmoteDescriptor desc : EmoteHandler.emoteMap.values()) {
                if (desc.getTier() > ContributorRewardHandler.localPatronTier) continue;
                List descriptors2 = (List)descriptorSorting.get(desc.getTier());
                if (descriptors2 == null) {
                    descriptors2 = Lists.newArrayList();
                    descriptorSorting.put(desc.getTier(), (Object)descriptors2);
                }
                descriptors2.add(desc);
            }
            int rows = 0;
            int i = 0;
            int row = 0;
            int[] keys = descriptorSorting.keys();
            Arrays.sort(keys);
            for (int tier : keys) {
                descriptors = (List)descriptorSorting.get(tier);
                if (descriptors == null) continue;
                rows += descriptors.size() / 3;
                if (descriptors.size() % 3 == 0) continue;
                ++rows;
            }
            for (int tier : keys) {
                int rowPos = 0;
                int tierRow = 0;
                descriptors = (List)descriptorSorting.get(tier);
                if (descriptors != null) {
                    for (EmoteDescriptor desc : descriptors) {
                        int rowSize = Math.min(descriptors.size() - tierRow * 3, 3);
                        int x = gui.field_146294_l - (((rowPos + 1) * 2 + 3 - rowSize) * 25 / 2 + 1);
                        int y = gui.field_146295_m - (40 + 25 * (rows - row));
                        GuiButtonEmote button = new GuiButtonEmote(1800 + i + 1, x, y, desc);
                        button.field_146125_m = emotesVisible;
                        button.field_146124_l = emotesVisible;
                        list.add(button);
                        ++i;
                        if (++rowPos != 3) continue;
                        ++tierRow;
                        ++row;
                        rowPos = 0;
                    }
                }
                if (rowPos == 0) continue;
                ++row;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiButton button = event.getButton();
        if (button.field_146127_k == 1800) {
            event.getGui();
            List list = event.getButtonList();
            for (GuiButton b : list) {
                if (!(b instanceof GuiButtonEmote)) continue;
                b.field_146125_m = !b.field_146125_m;
                b.field_146124_l = !b.field_146124_l;
            }
            emotesVisible = !emotesVisible;
        } else if (button instanceof GuiButtonEmote) {
            String name = ((GuiButtonEmote)button).desc.getRegistryName();
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRequestEmote(name));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71415_G && this.enableKeybinds) {
            for (KeyBinding key : ModKeybinds.emoteKeys.keySet()) {
                if (!key.func_151470_d()) continue;
                String emote = ModKeybinds.emoteKeys.get(key);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRequestEmote(emote));
                return;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = event.getResolution();
            EmoteBase emote = EmoteHandler.getPlayerEmote((EntityPlayer)mc.field_71439_g);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.func_78326_a() / 2 - 16;
                int y = res.func_78328_b() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                mc.func_110434_K().func_110577_a(resource);
                GuiScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
                GlStateManager.func_179147_l();
                String name = I18n.func_135052_a((String)emote.desc.getTranslationKey(), (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(name, (float)res.func_78326_a() / 2.0f - (float)mc.field_71466_p.func_78256_a(name) / 2.0f, (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EmoteHandler.onRenderTick(Minecraft.func_71410_x());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void preRenderLiving(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EmoteHandler.preRender((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void postRenderLiving(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EmoteHandler.postRender((EntityPlayer)event.getEntity());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

