/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="quark")
public class ContributorRewardHandler {
    private static final ImmutableSet<String> DEV_UUID = ImmutableSet.of((Object)"8c826f34-113b-4238-a173-44639c53b6e6", (Object)"0d054077-a977-4b19-9df9-8a4d5bf20ec3", (Object)"458391f5-6303-4649-b416-e4c0d18f837a");
    private static final Set<EntityPlayer> done = Collections.newSetFromMap(new WeakHashMap());
    private static String name;
    private static Properties patreonTiers;
    public static int localPatronTier;
    public static String featuredPatron;

    @SideOnly(value=Side.CLIENT)
    public static void setupClient() {
        name = Minecraft.func_71410_x().func_110432_I().func_111285_a().toLowerCase();
    }

    public static void init() {
        new ThreadContributorListLoader();
    }

    public static int getTier(EntityPlayer player) {
        if (patreonTiers == null) {
            return 0;
        }
        String playerName = player.func_70005_c_();
        for (String key : patreonTiers.stringPropertyNames()) {
            if (!key.toLowerCase(Locale.ROOT).equals(playerName)) continue;
            return Integer.parseInt(patreonTiers.getProperty(key));
        }
        return 0;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        AbstractClientPlayer clientPlayer;
        EntityPlayer player = event.getEntityPlayer();
        String uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
        if (player instanceof AbstractClientPlayer && DEV_UUID.contains((Object)uuid) && !done.contains(player) && (clientPlayer = (AbstractClientPlayer)player).func_152122_n()) {
            NetworkPlayerInfo info = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)clientPlayer, (String)"field_175157_a");
            Map textures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)info, (String)"field_187107_a");
            ResourceLocation loc = new ResourceLocation("quark", "textures/misc/dev_cape.png");
            textures.put(MinecraftProfileTexture.Type.CAPE, loc);
            textures.put(MinecraftProfileTexture.Type.ELYTRA, loc);
            done.add(player);
        }
    }

    private static void load(Properties props) {
        ArrayList allPatrons = new ArrayList(props.size());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            String value = (String)v;
            int tier = Integer.parseInt(value);
            if (tier < 10) {
                allPatrons.add(key);
            }
            if (name != null && key.toLowerCase(Locale.ROOT).equals(name)) {
                localPatronTier = tier;
            }
        }));
        if (!allPatrons.isEmpty()) {
            featuredPatron = (String)allPatrons.get((int)(Math.random() * (double)allPatrons.size()));
        }
    }

    static {
        localPatronTier = 0;
        featuredPatron = "";
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Quark Contributor Loading Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Quark/master/contributors.properties");
                patreonTiers = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                    patreonTiers.load(reader);
                    ContributorRewardHandler.load(patreonTiers);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

