/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.sync.ISonarValue;
import sonar.flux.FluxNetworks;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.NetworkFluxFolder;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.FluxNetworkCache;

public class FluxNetworkData
extends WorldSavedData {
    private static FluxNetworkData data;
    public Map<UUID, List<IFluxNetwork>> networks = new HashMap<UUID, List<IFluxNetwork>>();
    public int uniqueID = 1;
    public int stack_unique_id = 0;
    public static final String IDENTIFIER = "sonar.flux.networks.configurations";
    public static String TAG_LIST;
    public static String UNIQUE_ID;
    public static String UNIQUE_STACK_ID;
    public static String NETWORK_ID;
    public static String COLOUR;
    public static String OWNER_UUID;
    public static String CACHE_PLAYER;
    public static String NETWORK_NAME;
    public static String ACCESS;
    public static String CONVERSION;
    public static String ENERGY_TYPE;
    public static String PLAYER_LIST;
    public static String UNLOADED_CONNECTIONS;
    public static String FOLDERS;

    public FluxNetworkData(String name) {
        super(name);
    }

    public FluxNetworkData() {
        this(IDENTIFIER);
    }

    public static FluxNetworkData get() {
        if (data == null) {
            WorldServer world = DimensionManager.getWorld((int)0);
            WorldSavedData savedData = world.func_72943_a(FluxNetworkData.class, IDENTIFIER);
            if (savedData == null) {
                FluxNetworks.logger.info("No FluxNetworkData found");
                FluxNetworkData newData = new FluxNetworkData(IDENTIFIER);
                world.func_72823_a(IDENTIFIER, (WorldSavedData)newData);
                data = newData;
            } else {
                data = (FluxNetworkData)savedData;
                FluxNetworks.logger.info("FluxNetworkData has been successfully loaded");
            }
        }
        return data;
    }

    public static void clear() {
        if (data != null) {
            data = null;
            FluxNetworks.logger.info("FluxNetworkData has been unloaded");
        }
    }

    public boolean func_76188_b() {
        return true;
    }

    public void addNetwork(IFluxNetwork network) {
        UUID owner = network.getSetting(NetworkSettings.NETWORK_OWNER);
        if (owner != null) {
            this.networks.computeIfAbsent(owner, UUID2 -> FluxNetworkCache.instance().instanceNetworkList()).add(network);
        }
    }

    public void removeNetwork(IFluxNetwork common) {
        UUID owner = common.getSetting(NetworkSettings.NETWORK_OWNER);
        common.onRemoved();
        if (owner != null && this.networks.get(owner) != null) {
            this.networks.get(owner).remove(common);
        }
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        this.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        this.stack_unique_id = nbt.func_74762_e(UNIQUE_STACK_ID);
        if (nbt.func_74764_b(TAG_LIST)) {
            NBTTagList list = nbt.func_150295_c(TAG_LIST, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                FluxNetworkServer network = new FluxNetworkServer();
                network.readData(tag, NBTHelper.SyncType.SAVE);
                FluxNetworkData.readPlayers(network, tag);
                FluxNetworkData.readFolders(network, tag);
                FluxNetworkData.readConnections(network.getSyncSetting(NetworkSettings.UNLOADED_CONNECTIONS), UNLOADED_CONNECTIONS, network, tag);
                this.addNetwork(network);
                FluxNetworks.proxy.logLoadedNetwork(network);
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbt) {
        nbt.func_74768_a(UNIQUE_ID, this.uniqueID);
        nbt.func_74768_a(UNIQUE_STACK_ID, this.stack_unique_id);
        if (this.networks.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (IFluxNetwork network : FluxNetworks.getServerCache().getAllNetworks()) {
                NBTTagCompound tag = new NBTTagCompound();
                network.writeData(tag, NBTHelper.SyncType.SAVE);
                FluxNetworkData.writePlayers(network, tag);
                FluxNetworkData.writeFolders(network, tag);
                FluxNetworkData.writeConnections(network.getSyncSetting(NetworkSettings.UNLOADED_CONNECTIONS), UNLOADED_CONNECTIONS, network, tag);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(TAG_LIST, (NBTBase)list);
            FluxNetworks.logger.debug("ALL " + list.func_74745_c() + " Networks were saved successfully");
        }
        return nbt;
    }

    public static void readPlayers(IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b(PLAYER_LIST)) {
            ArrayList players = new ArrayList();
            NBTTagList player_list = tag.func_150295_c(PLAYER_LIST, 10);
            for (int j = 0; j < player_list.func_74745_c(); ++j) {
                NBTTagCompound c = player_list.func_150305_b(j);
                ListHelper.addWithCheck(players, (Object)new FluxPlayer(c));
            }
            network.setSettingInternal(NetworkSettings.NETWORK_PLAYERS, players);
        }
    }

    public static NBTTagCompound writePlayers(IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        List<FluxPlayer> players = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        if (!players.isEmpty()) {
            NBTTagList player_list = new NBTTagList();
            players.forEach(player -> player_list.func_74742_a((NBTBase)player.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
            tag.func_74782_a(PLAYER_LIST, (NBTBase)player_list);
        }
        return tag;
    }

    public static void readFolders(IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b(FOLDERS)) {
            NBTTagList folder_tag_list = tag.func_150295_c(FOLDERS, 10);
            ArrayList<NetworkFluxFolder> folders = new ArrayList<NetworkFluxFolder>();
            for (int j = 0; j < folder_tag_list.func_74745_c(); ++j) {
                folders.add(new NetworkFluxFolder(folder_tag_list.func_150305_b(j)));
            }
            network.getSyncSetting(NetworkSettings.NETWORK_FOLDERS).setValueInternal(folders);
        }
    }

    public static NBTTagCompound writeFolders(IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        List<NetworkFluxFolder> folders = network.getSetting(NetworkSettings.NETWORK_FOLDERS);
        if (!folders.isEmpty()) {
            NBTTagList folders_tag_list = new NBTTagList();
            folders.forEach(folder -> folders_tag_list.func_74742_a((NBTBase)folder.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
            tag.func_74782_a(FOLDERS, (NBTBase)folders_tag_list);
        }
        return tag;
    }

    public static void readConnections(ISonarValue<List<ClientFlux>> value, String key, IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b(key)) {
            ArrayList loaded = new ArrayList();
            NBTTagList connections = tag.func_150295_c(key, 10);
            for (int j = 0; j < connections.func_74745_c(); ++j) {
                NBTTagCompound c = connections.func_150305_b(j);
                ListHelper.addWithCheck(loaded, (Object)new ClientFlux(c));
            }
            value.setValueInternal(loaded);
        }
    }

    public static NBTTagCompound writeConnections(ISonarValue<List<ClientFlux>> value, String key, IFluxNetwork network, @Nonnull NBTTagCompound tag) {
        List loaded = (List)value.getValue();
        NBTTagList connections = new NBTTagList();
        loaded.forEach(flux -> connections.func_74742_a((NBTBase)flux.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        tag.func_74782_a(key, (NBTBase)connections);
        return tag;
    }

    static {
        TAG_LIST = "networks";
        UNIQUE_ID = "uniqueID";
        UNIQUE_STACK_ID = "stackID";
        NETWORK_ID = "id";
        COLOUR = "colour";
        OWNER_UUID = "ownerUUID";
        CACHE_PLAYER = "cachePName";
        NETWORK_NAME = "name";
        ACCESS = "access";
        CONVERSION = "convert";
        ENERGY_TYPE = "energy_type";
        PLAYER_LIST = "playerList";
        UNLOADED_CONNECTIONS = "unloaded";
        FOLDERS = "network_folders";
    }
}

