/*
 * Decompiled with CFR 0.152.
 */
package lumien.hardcoredarkness.config;

import java.io.File;
import lumien.hardcoredarkness.HardcoreDarkness;
import lumien.hardcoredarkness.config.HardcoreDarknessConfig;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    HardcoreDarknessConfig localConfig;
    HardcoreDarknessConfig serverConfig;
    File configFile;

    public void preInit(FMLPreInitializationEvent event) {
        this.configFile = event.getSuggestedConfigurationFile();
        this.reloadConfig();
    }

    public void reloadConfig() {
        String blackListString;
        this.localConfig = new HardcoreDarknessConfig();
        Configuration config = new Configuration(this.configFile);
        config.load();
        this.localConfig.setMode(config.get("Settings", "Mode", 0, "0: No minimum sky & block light, 1: No minimum block light, 2: Skylight is dependent on moon phase").getInt(0));
        this.localConfig.setDarkNether(config.getBoolean("Dark Nether", "Settings", true, "Whether the Nether is also supposed to have its minimum light removed"));
        this.localConfig.setDarkEnd(config.getBoolean("Dark End", "Settings", false, "Whether the End is also supposed to have its minimum light removed"));
        this.localConfig.setAlternativeNightSkylight(config.getBoolean("AlternativeNightSkyLight", "Settings", false, "Switches the slightly bluish NightSkyLight in mode 1 & 2 with a more greenish version."));
        this.localConfig.setGammaOverride(config.getFloat("GammaOverride", "Settings", -1.0f, -1.0f, 1.0f, "Setting this to something other than -1 will lock the gamma config settings to that value. (0.0 - 1.0)"));
        double[] moonLightList = config.get("Settings", "MoonLightList", new double[]{0.0, 0.075, 0.15, 0.225, 0.3}, "In mode 2 this list defines how much skylight there is when 0%/25%/50%/75%/100% of the moon is visible. (Values go from 0 (Total Darkness) to 1 (Total Brightness)).").getDoubleList();
        if (moonLightList.length == 5) {
            float[] floatList = new float[5];
            for (int i = 0; i < moonLightList.length; ++i) {
                floatList[i] = 1.0f - (float)moonLightList[i];
            }
            this.localConfig.setMoonLightList(floatList);
        }
        if (!(blackListString = config.getString("Dimension Blacklist", "Settings", "", "A list of dimension ids in which Hardcore Darkness will be completely disabled\nExample: S:\"Dimension Blacklist\"=-1,1")).isEmpty()) {
            String[] blackListSplit = blackListString.split(",");
            if (blackListSplit.length > 0) {
                for (String s : blackListSplit) {
                    try {
                        Integer i = Integer.parseInt(s);
                        this.localConfig.addDimensionToBlacklist(i);
                    }
                    catch (NumberFormatException exception) {
                        HardcoreDarkness.INSTANCE.logger.log(Level.ERROR, "Error parsing the dimension blacklist: " + s);
                        exception.printStackTrace();
                    }
                }
            } else {
                try {
                    Integer i = Integer.parseInt(blackListString);
                    this.localConfig.addDimensionToBlacklist(i);
                }
                catch (NumberFormatException exception) {
                    HardcoreDarkness.INSTANCE.logger.log(Level.ERROR, "Error parsing the dimension blacklist: " + blackListSplit);
                    exception.printStackTrace();
                }
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public synchronized void setServerConfig(HardcoreDarknessConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public synchronized HardcoreDarknessConfig getActiveConfig() {
        if (this.serverConfig != null) {
            return this.serverConfig;
        }
        return this.localConfig;
    }
}

