/*
 * Decompiled with CFR 0.152.
 */
package ts2k16.handlers;

import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ts2k16.blacklist.BlockBlacklist;
import ts2k16.core.TSSettings;

public class PlayerGrowthManager {
    private int sprintTime = 0;
    private boolean wasSprinting = false;
    private int crouchTime = 0;
    private boolean wasCrouched = false;

    public void updatePlayer(EntityPlayer player) {
        if (player.field_70173_aa < this.sprintTime) {
            this.sprintTime = 0;
        }
        if (player.field_70173_aa < this.crouchTime) {
            this.crouchTime = 0;
        }
        if (TSSettings.allowSprint && player.func_70051_ag()) {
            if (!this.wasSprinting) {
                this.sprintTime = player.field_70173_aa;
            } else if (player.field_70173_aa - this.sprintTime > TSSettings.cooldown) {
                this.pulseGrowth(player.field_70170_p, player.func_180425_c(), player);
                this.sprintTime = player.field_70173_aa;
            }
        } else if (player.func_70093_af() && !this.wasCrouched && player.field_70173_aa - this.crouchTime > TSSettings.cooldown) {
            this.pulseGrowth(player.field_70170_p, player.func_180425_c(), player);
            this.crouchTime = player.field_70173_aa;
        }
        this.wasSprinting = player.func_70051_ag();
        this.wasCrouched = player.func_70093_af();
    }

    private void pulseGrowth(World world, BlockPos pos, EntityPlayer player) {
        for (int i = -TSSettings.radius; i <= TSSettings.radius; ++i) {
            for (int j = -TSSettings.radius; j <= TSSettings.radius; ++j) {
                for (int k = -TSSettings.radius; k <= TSSettings.radius; ++k) {
                    boolean flag;
                    BlockPos offset = pos.func_177982_a(i, j, k);
                    IBlockState state = world.func_180495_p(offset);
                    if (!(state.func_177230_c() instanceof IGrowable) || BlockBlacklist.INSTANCE.isBlacklisted(state)) continue;
                    boolean bl = flag = TSSettings.allPlants || state.func_177230_c() instanceof BlockSapling || BlockBlacklist.INSTANCE.isWhitelisted(state);
                    if (!flag || world.field_73012_v.nextInt(100) >= TSSettings.chance || !ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)offset, (EntityPlayer)player, (EnumHand)player.func_184600_cs())) continue;
                    world.func_175718_b(2005, offset, 0);
                }
            }
        }
    }
}

