/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;

public abstract class OgexTranslation
implements OgexTransform {
    private Kind kind;
    private boolean object;

    protected OgexTranslation(Kind kind) {
        this.kind = kind;
    }

    @Override
    public void setObjectOnly(boolean b) {
        this.object = b;
    }

    @Override
    public boolean isObjectOnly() {
        return this.object;
    }

    protected void setKind(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static OgexTranslation create(Kind kind, Object data) {
        switch (kind) {
            case X: 
            case Y: 
            case Z: {
                return new ComponentTranslation(kind, ((Float)data).floatValue());
            }
            case Xyz: {
                return new XyzTranslation(kind, (float[])data);
            }
        }
        return null;
    }

    public static class XyzTranslation
    extends OgexTranslation {
        private float[] translation;

        public XyzTranslation(Kind kind, float[] data) {
            super(kind);
            this.translation = data;
        }

        @Override
        public void setKind(Kind kind) {
            if (kind != Kind.Xyz) {
                throw new IllegalArgumentException("Incompatible Xyz kind:" + (Object)((Object)kind));
            }
        }

        public void setTranslation(float[] translation) {
            if (translation.length != 3) {
                throw new IllegalArgumentException("Translation array must be length 3, found:" + translation.length);
            }
            this.translation = translation;
        }

        public float[] getTranslation() {
            return this.translation;
        }

        @Override
        public float[] toMatrix() {
            return new float[]{1.0f, 0.0f, 0.0f, this.translation[0], 0.0f, 1.0f, 0.0f, this.translation[1], 0.0f, 0.0f, 1.0f, this.translation[2], 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", translation=[" + this.translation[0] + ", " + this.translation[1] + ", " + this.translation[2] + "]]";
        }
    }

    public static class ComponentTranslation
    extends OgexTranslation {
        private float translation;

        public ComponentTranslation(Kind kind, float translation) {
            super(kind);
            this.translation = translation;
        }

        @Override
        public void setKind(Kind kind) {
            switch (kind) {
                case X: 
                case Y: 
                case Z: {
                    super.setKind(kind);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incompatible ComponentTranslation kind:" + (Object)((Object)kind));
                }
            }
        }

        public void setTranslation(float translation) {
            this.translation = translation;
        }

        public float getTranslation() {
            return this.translation;
        }

        @Override
        public float[] toMatrix() {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            switch (this.getKind()) {
                case X: {
                    x = this.translation;
                    break;
                }
                case Y: {
                    y = this.translation;
                    break;
                }
                case Z: {
                    z = this.translation;
                }
            }
            return new float[]{1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", translation=" + this.translation + "]";
        }
    }

    public static enum Kind {
        X("x"),
        Y("y"),
        Z("z"),
        Xyz("xyz");

        private String ogexName;

        private Kind(String ogexName) {
            this.ogexName = ogexName;
        }

        public String getOgexName() {
            return this.ogexName;
        }

        public static Kind lookup(String ogexName) {
            for (Kind kind : Kind.values()) {
                if (!ogexName.equals(kind.ogexName)) continue;
                return kind;
            }
            return null;
        }
    }
}

