/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.oddl;

import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BaseStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.PrimitiveStructure;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataStructure
extends BaseStructure
implements Iterable<BaseStructure> {
    private String type;
    private Map<String, Object> properties;
    private List<BaseStructure> children;
    private Map<String, BaseStructure> childIndex;

    public DataStructure(String type, DataStructure parent, int[] location) {
        super(parent, location);
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public BaseStructure findChild(String ... tokens) {
        BaseStructure parent = this;
        BaseStructure result = null;
        for (String s : tokens) {
            if (!(parent instanceof DataStructure)) {
                return null;
            }
            DataStructure ds = parent;
            if (ds.childIndex == null) {
                return null;
            }
            result = ds.childIndex.get(s);
            parent = result;
        }
        return result;
    }

    protected boolean addIndex(String name, BaseStructure struct) {
        if (this.childIndex == null) {
            this.childIndex = new HashMap<String, BaseStructure>();
        }
        return this.childIndex.put(name, struct) == null;
    }

    protected void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public <T> T getProperty(String key, T defaultValue) {
        T result = this.getProperty(key);
        return result == null ? defaultValue : result;
    }

    @Override
    public <T> T getValue() {
        for (BaseStructure struct : this.getChildren()) {
            if (!(struct instanceof PrimitiveStructure)) continue;
            return ((PrimitiveStructure)struct).getValue();
        }
        throw new RuntimeException(this.getType() + " has no primitive children.");
    }

    @Override
    public Object getData() {
        for (BaseStructure struct : this.getChildren()) {
            if (!(struct instanceof PrimitiveStructure)) continue;
            return ((PrimitiveStructure)struct).getData();
        }
        throw new RuntimeException(this.getType() + " has no primitive children.");
    }

    protected void setChildren(List<BaseStructure> children) {
        this.children = children;
    }

    public List<BaseStructure> getChildren() {
        List<BaseStructure> result = this.children;
        if (this.children == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public PrimitiveStructure getPrimitiveChild(boolean strict) {
        if (strict && this.getChildren().isEmpty()) {
            throw new RuntimeException(this.getType() + " float data not specified.");
        }
        if (strict && this.getChildren().size() > 1) {
            throw new RuntimeException(this.getType() + " has too many child structures.");
        }
        for (BaseStructure struct : this.getChildren()) {
            if (!(struct instanceof PrimitiveStructure)) continue;
            return (PrimitiveStructure)struct;
        }
        throw new RuntimeException(this.getType() + " has no primitive children.");
    }

    @Override
    public Iterator<BaseStructure> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "[");
        sb.append("type=" + this.type);
        if (this.getName() != null) {
            sb.append(", name=" + this.getName());
        }
        if (this.properties != null) {
            sb.append(", properties=" + this.properties);
        }
        if (this.children != null) {
            sb.append(", children.size=" + (this.children == null ? 0 : this.children.size()));
        }
        sb.append("]");
        return sb.toString();
    }
}

