/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.client.gui.element.ElementSlotFluid;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import astavie.thermallogistics.util.ItemPrint;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;

public class StackHandler {
    public static void writePacket(PacketBase packet, Object item, Class<?> c, boolean identifier) {
        if (c == ItemStack.class) {
            if (identifier) {
                packet.addByte(0);
            }
            packet.addItemStack((ItemStack)item);
        } else if (c == FluidStack.class) {
            if (identifier) {
                packet.addByte(1);
            }
            packet.addFluidStack((FluidStack)item);
        } else {
            throw new IllegalArgumentException("Unknown item type " + c.getName());
        }
    }

    public static <I> I readPacket(PacketBase packet) {
        byte type = packet.getByte();
        if (type == 0) {
            return (I)packet.getItemStack();
        }
        if (type == 1) {
            return (I)packet.getFluidStack();
        }
        throw new IllegalArgumentException("Unknown item type " + type);
    }

    public static NBTTagCompound writeLargeItemStack(ItemStack stack) {
        NBTTagCompound compound = ItemHelper.cloneStack((ItemStack)stack, (int)1).func_77955_b(new NBTTagCompound());
        compound.func_74768_a("IntCount", stack.func_190916_E());
        return compound;
    }

    public static ItemStack readLargeItemStack(NBTTagCompound compound) {
        ItemStack stack = new ItemStack(compound);
        if (compound.func_74764_b("IntCount")) {
            return ItemHelper.cloneStack((ItemStack)stack, (int)compound.func_74762_e("IntCount"));
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, boolean count) {
        if (item instanceof ItemStack) {
            ItemStack stack = (ItemStack)item;
            FontRenderer font = null;
            if (!stack.func_190926_b()) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = gui.getFontRenderer();
            }
            RenderHelper.enableGUIStandardItemLighting();
            gui.field_146296_j.func_180450_b(stack, x, y);
            gui.field_146296_j.func_180453_a(font, stack, x, y - (gui.field_147012_x.func_190926_b() ? 0 : 8), count ? null : "");
        } else if (item instanceof FluidStack) {
            FluidStack fluid = (FluidStack)item;
            GlStateManager.func_179140_f();
            gui.drawFluid(x, y, fluid, 16, 16);
            if (count) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                String amount = StringHelper.formatNumber((long)fluid.amount);
                gui.getFontRenderer().func_175063_a(amount, (float)((x + 16) * 2 - gui.getFontRenderer().func_78256_a(amount)), (float)((y + 12) * 2), 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, String text) {
        if (item instanceof ItemStack) {
            gui.drawItemStack((ItemStack)item, x, y, true, "");
        } else if (item instanceof FluidStack) {
            gui.drawFluid(x, y, (FluidStack)item, 16, 16);
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        gui.getFontRenderer().func_175063_a(text, (float)((x + 16) * 2 - gui.getFontRenderer().func_78256_a(text)), (float)((y + 12) * 2), 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(GuiContainerCore gui, Object item) {
        if (item instanceof ItemStack) {
            return gui.func_191927_a((ItemStack)item);
        }
        if (item instanceof FluidStack) {
            return Collections.singletonList(((FluidStack)item).getLocalizedName());
        }
        throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
    }

    @SideOnly(value=Side.CLIENT)
    public static ElementBase getSlot(GuiContainerCore gui, int x, int y, GuiCrafter.Slot<?> slot) {
        Class<?> c = slot.getCrafter().getItemClass();
        if (c == ItemStack.class) {
            return new ElementSlotItem(gui, x, y, slot, slot, true);
        }
        if (c == FluidStack.class) {
            return new ElementSlotFluid(gui, x, y, slot, slot, true);
        }
        throw new IllegalArgumentException("Unknown item type " + c.getName());
    }

    public static Map<ItemPrint, MutablePair<Long, Boolean>> getItems(IRequester<ItemStack> requester, @Nullable Set<IItemHandler> handlers) {
        IItemHandler handler;
        HashMap<ItemPrint, MutablePair<Long, Boolean>> items = new HashMap<ItemPrint, MutablePair<Long, Boolean>>();
        DuctUnitItem duct = (DuctUnitItem)requester.getDuct();
        if (duct == null) {
            return items;
        }
        if (handlers == null) {
            handlers = new HashSet<IItemHandler>();
        }
        if ((handler = requester.getCachedInv()) != null) {
            handlers.add(handler);
        }
        for (DuctUnitItem start : ((GridItem)duct.getGrid()).nodeSet) {
            for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
                MutablePair pair;
                ItemPrint print;
                IItemHandler inv;
                DuctUnitItem.Cache cache;
                if (!start.isInput(side) && !start.isOutput(side) || !start.parent.getConnectionType((int)side).allowTransfer || (cache = ((DuctUnitItem.Cache[])start.tileCache)[side]) == null || (inv = cache.getItemHandler(side ^ 1)) == null || handlers.contains(inv)) continue;
                Attachment attachment = start.parent.getAttachment(side);
                if (attachment != null) {
                    if (attachment instanceof ICrafter && ((ICrafter)attachment).isEnabled()) {
                        for (ItemStack out : ((ICrafter)attachment).getOutputs()) {
                            if (out.func_190926_b()) continue;
                            print = new ItemPrint(out);
                            pair = (MutablePair)items.get(print);
                            if (pair != null) {
                                pair.right = true;
                                continue;
                            }
                            items.put(print, (MutablePair<Long, Boolean>)MutablePair.of((Object)0L, (Object)true));
                        }
                    }
                    if (!attachment.canSend()) continue;
                }
                if (cache.tile != null && cache.tile instanceof ICrafter && ((ICrafter)cache.tile).isEnabled()) {
                    for (ItemStack out : ((ICrafter)cache.tile).getOutputs()) {
                        if (out.func_190926_b()) continue;
                        print = new ItemPrint(out);
                        pair = (MutablePair)items.get(print);
                        if (pair != null) {
                            pair.right = true;
                            continue;
                        }
                        items.put(print, (MutablePair<Long, Boolean>)MutablePair.of((Object)0L, (Object)true));
                    }
                }
                for (int slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack extract = inv.getStackInSlot(slot);
                    if (extract.func_190926_b()) continue;
                    print = new ItemPrint(extract);
                    pair = (MutablePair)items.get(print);
                    if (pair != null) {
                        MutablePair mutablePair = pair;
                        Long.valueOf((Long)mutablePair.left + (long)extract.func_190916_E());
                        mutablePair.left = mutablePair.left;
                        continue;
                    }
                    items.put(print, (MutablePair<Long, Boolean>)MutablePair.of((Object)extract.func_190916_E(), (Object)false));
                }
                handlers.add(inv);
            }
        }
        return items;
    }
}

