/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.IRequesterContainer;
import cofh.core.network.PacketBase;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RequesterReference<I> {
    public final int dim;
    public final BlockPos pos;
    public final byte side;
    public final int index;
    public final List<I> outputs = NonNullList.func_191196_a();
    private long tick;
    private IRequester<I> cache;
    private ItemStack icon = ItemStack.field_190927_a;
    private ItemStack tile = ItemStack.field_190927_a;

    public RequesterReference(int dim, BlockPos pos, byte side) {
        this(dim, pos, side, 0);
    }

    public RequesterReference(int dim, BlockPos pos, byte side, int index) {
        this.dim = dim;
        this.pos = pos;
        this.side = side;
        this.index = index;
    }

    public static NBTTagCompound writeNBT(RequesterReference<?> reference) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("dim", reference.dim);
        nbt.func_74768_a("x", reference.pos.func_177958_n());
        nbt.func_74768_a("y", reference.pos.func_177956_o());
        nbt.func_74768_a("z", reference.pos.func_177952_p());
        nbt.func_74774_a("side", reference.side);
        nbt.func_74768_a("index", reference.index);
        return nbt;
    }

    public static <I> RequesterReference<I> readNBT(NBTTagCompound nbt) {
        return new RequesterReference<I>(nbt.func_74762_e("dim"), new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt.func_74771_c("side"), nbt.func_74762_e("index"));
    }

    public static void writePacket(PacketBase packet, RequesterReference<?> reference) {
        packet.addInt(reference.dim);
        packet.addCoords(reference.pos.func_177958_n(), reference.pos.func_177956_o(), reference.pos.func_177952_p());
        packet.addByte(reference.side);
        packet.addInt(reference.index);
        IRequester<?> requester = reference.getAttachment();
        packet.addItemStack(requester.getIcon());
        packet.addItemStack(requester.getTileIcon());
    }

    public static <I> RequesterReference<I> readPacket(PacketBase packet) {
        RequesterReference<I> reference = new RequesterReference<I>(packet.getInt(), packet.getCoords(), packet.getByte(), packet.getInt());
        reference.icon = packet.getItemStack();
        reference.tile = packet.getItemStack();
        return reference;
    }

    public boolean isLoaded() {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        return world != null && world.func_175667_e(this.pos);
    }

    public boolean isLoaded(World world) {
        return world.field_73011_w.getDimension() == this.dim && world.func_175667_e(this.pos);
    }

    public IRequester<I> getAttachment() {
        return this.getAttachment((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim));
    }

    public IRequester<I> getAttachment(World world) {
        if (world.field_73011_w.getDimension() != this.dim) {
            return null;
        }
        if (world.func_82737_E() == this.tick) {
            return this.cache;
        }
        this.tick = world.func_82737_E();
        this.cache = null;
        TileEntity tile = world.func_175625_s(this.pos);
        try {
            if (tile instanceof IRequester) {
                this.cache = (IRequester)tile;
            } else if (tile instanceof IRequesterContainer) {
                this.cache = ((IRequesterContainer)tile).getRequester(this.index);
            } else if (tile instanceof TileGrid) {
                Attachment attachment = ((TileGrid)tile).getAttachment((int)this.side);
                if (attachment instanceof IRequester) {
                    this.cache = (IRequester)attachment;
                } else if (attachment instanceof IRequesterContainer) {
                    this.cache = ((IRequesterContainer)attachment).getRequester(this.index);
                }
            }
        }
        catch (ClassCastException ignore) {
            this.cache = null;
        }
        return this.cache;
    }

    public boolean references(IRequester<?> requester) {
        return this.dim == requester.getTile().func_145831_w().field_73011_w.getDimension() && this.pos.equals((Object)requester.getTile().func_174877_v()) && this.side == requester.getSide();
    }

    public boolean equals(Object object) {
        if (object instanceof RequesterReference) {
            RequesterReference reference = (RequesterReference)object;
            return reference.dim == this.dim && reference.pos.equals((Object)this.pos) && reference.side == this.side;
        }
        return false;
    }

    public int hashCode() {
        return (Integer.hashCode(this.dim) * 31 + this.pos.hashCode()) * 31 + Integer.hashCode(this.side);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public ItemStack getTileIcon() {
        return this.tile;
    }
}

