/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.CrafterFluid;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.client.gui.IFluidGui;
import astavie.thermallogistics.client.gui.element.ElementSlot;
import astavie.thermallogistics.client.gui.tab.TabFluid;
import astavie.thermallogistics.client.gui.tab.TabLink;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.util.StackHandler;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabRedstoneControl;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiCrafter
extends GuiContainerCore
implements IFluidGui {
    private static final String ICON_PATH = "thermallogistics:textures/gui/crafter.png";
    private static final String TEX_PATH = "thermaldynamics:textures/gui/connection.png";
    private static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/connection.png");
    private static final int[][] levelButtonPos = new int[][]{{-1, -1}, {0, 204}, {80, 204}};
    private static final int[][] flagButtonsPos = new int[][]{{176, 0}, {176, 60}, {216, 0}, {216, 60}, {176, 120}, {216, 120}, {176, 180}, {216, 180}};
    private final ConnectionBase attachment;
    private final ICrafterWrapper<?> wrapper;
    private ElementButton splitButton;
    private ElementButton[] flagButtons = new ElementButton[0];
    private ElementButton[] levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
    private int buttonSize;
    private FluidStack fluid = null;
    public final List<ElementSlot> slots = new LinkedList<ElementSlot>();
    public final ICrafter<?> crafter;
    public TabFluid tab = null;

    public <C extends ConnectionBase> GuiCrafter(InventoryPlayer inventoryPlayer, C crafter) {
        super((Container)new ContainerCrafter(inventoryPlayer, crafter), TEXTURE);
        this.crafter = (ICrafter)crafter;
        this.attachment = crafter;
        this.attachment.getFilter();
        this.name = this.attachment.getName();
        this.field_147000_g = 204;
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this.attachment.baseTile, (int)this.attachment.side);
        this.wrapper = tile == null ? null : ThermalLogistics.INSTANCE.getWrapper(tile.getClass());
        String info = this.attachment.getInfo();
        if (info != null) {
            this.generateInfo(info);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermaldynamics.conChange");
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        if (this.attachment.canAlterRS()) {
            this.addTab((TabBase)new TabRedstoneControl((GuiContainerCore)this, (IRedstoneControl)this.attachment));
        }
        this.addTab(new TabLink(this, this.crafter));
        if (this.attachment instanceof CrafterFluid) {
            this.tab = new TabFluid(this, this);
            this.addTab(this.tab);
        }
        int[] flagNums = new int[this.attachment.filter.validFlags().length - 1];
        System.arraycopy(this.attachment.filter.validFlags(), 1, flagNums, 0, flagNums.length);
        this.flagButtons = new ElementButton[this.attachment.filter.numFlags()];
        int[] levelNums = this.attachment.filter.getValidLevels();
        this.levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
        int buttonNo = flagNums.length + levelNums.length;
        if (this.attachment.type > 0) {
            ++buttonNo;
        }
        if (buttonNo != 0) {
            int j;
            int i;
            this.buttonSize = 20;
            int button_offset = this.buttonSize + 6;
            int x0 = this.field_146999_f / 2 - buttonNo * (button_offset / 2) + 3;
            int y0 = 82;
            if (this.attachment.type > 0) {
                this.splitButton = new ElementButton((GuiContainerCore)this, x0, y0, "split", 0, 0, 0, this.buttonSize, 0, this.buttonSize * 2, this.buttonSize, this.buttonSize, ICON_PATH);
                this.addElement((ElementBase)this.splitButton);
            }
            int offset = this.attachment.type > 0 ? 1 : 0;
            for (i = 0; i < flagNums.length; ++i) {
                j = flagNums[i];
                this.flagButtons[j] = new ElementButton((GuiContainerCore)this, x0 + button_offset * (i + offset), y0, this.attachment.filter.flagType(j), flagButtonsPos[j][0], flagButtonsPos[j][1], flagButtonsPos[j][0], flagButtonsPos[j][1] + this.buttonSize, flagButtonsPos[j][0], flagButtonsPos[j][1] + this.buttonSize * 2, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.flagButtons[j]);
            }
            for (i = 0; i < levelNums.length; ++i) {
                j = levelNums[i];
                this.levelButtons[j] = new ElementButton((GuiContainerCore)this, x0 + button_offset * (i + offset + flagNums.length), y0, FilterLogic.levelNames[j], levelButtonPos[j][0], levelButtonPos[j][1], levelButtonPos[j][0], levelButtonPos[j][1] + this.buttonSize, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.levelButtons[j]);
            }
        }
        if (this.wrapper != null) {
            ElementButton button = new ElementButton((GuiContainerCore)this, 10, 48, "import", 80, 0, 80, 16, 16, 16, ICON_PATH);
            button.setToolTip("info.logistics.import");
            this.addElement((ElementBase)button);
        }
    }

    private void setButtons() {
        int x;
        int i;
        if (this.splitButton != null) {
            int x2 = Math.min(CrafterItem.SIZE[this.attachment.type] / this.crafter.getRecipes().size() - 1, 3) * this.buttonSize;
            this.splitButton.setSheetX(x2);
            this.splitButton.setHoverX(x2);
            this.splitButton.setToolTipLocalized(StringHelper.localizeFormat((String)"info.logistics.split", (Object[])new Object[]{this.crafter.getRecipes().size()}));
        }
        for (i = 0; i < this.flagButtons.length; ++i) {
            if (this.flagButtons[i] == null) continue;
            boolean b = this.attachment.filter.getFlag(i);
            x = flagButtonsPos[i][0] + (b ? this.buttonSize : 0);
            this.flagButtons[i].setSheetX(x);
            this.flagButtons[i].setHoverX(x);
            this.flagButtons[i].setToolTip("info.thermaldynamics.filter." + this.flagButtons[i].getName() + (b ? ".on" : ".off"));
        }
        for (i = 0; i < this.levelButtons.length; ++i) {
            if (this.levelButtons[i] == null) continue;
            int level = this.attachment.filter.getLevel(i);
            x = levelButtonPos[i][0] + level * this.buttonSize;
            this.levelButtons[i].setSheetX(x);
            this.levelButtons[i].setHoverX(x);
            this.levelButtons[i].setToolTip("info.thermaldynamics.filter." + this.levelButtons[i].getName() + "." + level);
        }
        this.elements.removeAll(this.slots);
        this.slots.clear();
        if (this.attachment.type > 0) {
            int slots = CrafterItem.SIZE[this.attachment.type];
            int recipeSlots = slots / this.crafter.getRecipes().size();
            int start = slots * 9 + (this.crafter.getRecipes().size() - 1);
            int x0 = this.field_146999_f / 2 - start;
            int y0 = 20;
            for (int i2 = 0; i2 < this.crafter.getRecipes().size(); ++i2) {
                for (int x3 = 0; x3 < recipeSlots; ++x3) {
                    int posX = x0 + (x3 + i2 * recipeSlots) * 18 + i2 * 2;
                    Slot up = new Slot(this.crafter, i2, true, x3 * 2);
                    this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, posX, y0, up)));
                    Slot down = new Slot(this.crafter, i2, true, x3 * 2 + 1);
                    this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, posX, y0 + 18, down)));
                    Slot output = new Slot(this.crafter, i2, false, x3);
                    this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, posX, y0 + 38, output)));
                }
            }
        } else {
            int x0 = this.field_146999_f / 2;
            int y0 = 38;
            Slot left = new Slot(this.crafter, 0, true, 0);
            this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, x0 - 18, y0, left)));
            Slot right = new Slot(this.crafter, 0, true, 1);
            this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, x0, y0, right)));
            Slot output = new Slot(this.crafter, 0, false, 0);
            this.slots.add((ElementSlot)this.addElement(StackHandler.getSlot(this, x0 - 9, y0 + 20, output)));
        }
    }

    protected void updateElementInformation() {
        this.setButtons();
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (this.fluid != null && this.slots.stream().noneMatch(slot -> slot.intersectsWith(mX - this.field_147003_i, mY - this.field_147009_r))) {
            this.fluid = null;
        } else {
            super.func_73864_a(mX, mY, mouseButton);
        }
    }

    protected void func_146273_a(int mX, int mY, int lastClick, long timeSinceClick) {
        if (lastClick == 0 && (this.slots.stream().anyMatch(slot -> slot.intersectsWith(mX - this.field_147003_i, mY - this.field_147009_r)) || this.tab != null && this.tab.slot.intersectsWith(mX - this.field_147003_i - this.tab.posX(), mY - this.field_147009_r - this.tab.getPosY()))) {
            try {
                this.func_73864_a(mX, mY, lastClick);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            super.func_146273_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    protected boolean func_193983_c(int x, int y, int left, int top) {
        if (this.fluid != null) {
            return false;
        }
        boolean yes = super.func_193983_c(x, y, left, top);
        if (yes && this.tab != null && this.tab.slot.intersectsWith(x - left - this.tab.posX(), y - top - this.tab.getPosY())) {
            return false;
        }
        return yes;
    }

    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        if (this.tab != null && this.tab.isFullyOpened() && this.tab.onKeyTyped(characterTyped, keyPressed)) {
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        ElementButton button;
        int i;
        if (this.splitButton != null && this.splitButton.getName().equals(buttonName)) {
            int index;
            int offset;
            int n = mouseButton == 0 ? 1 : (offset = mouseButton == 1 ? -1 : 0);
            if (offset != 0 && (index = Ints.indexOf((int[])CrafterItem.SPLITS[this.attachment.type], (int)(CrafterItem.SIZE[this.attachment.type] / this.crafter.getRecipes().size()))) != -1) {
                if ((index += offset) < 0) {
                    index = CrafterItem.SPLITS[this.attachment.type].length - 1;
                } else if (index >= CrafterItem.SPLITS[this.attachment.type].length) {
                    index = 0;
                }
                int split = CrafterItem.SPLITS[this.attachment.type][index];
                this.crafter.split(split);
                GuiCrafter.playClickSound((float)0.8f);
                PacketTileInfo packet = this.crafter.getNewPacket((byte)0);
                packet.addByte(1);
                packet.addInt(split);
                PacketHandler.sendToServer((PacketBase)packet);
            }
            this.setButtons();
            return;
        }
        for (i = 0; i < this.flagButtons.length; ++i) {
            button = this.flagButtons[i];
            if (button == null || !button.getName().equals(buttonName)) continue;
            if (this.attachment.filter.setFlag(i, !this.attachment.filter.getFlag(i))) {
                if (this.attachment.filter.getFlag(i)) {
                    GuiCrafter.playClickSound((float)0.8f);
                } else {
                    GuiCrafter.playClickSound((float)0.6f);
                }
            }
            this.setButtons();
            return;
        }
        for (i = 0; i < this.levelButtons.length; ++i) {
            button = this.levelButtons[i];
            if (button == null || !button.getName().equals(buttonName)) continue;
            if (mouseButton == 0) {
                this.attachment.filter.incLevel(i);
                GuiCrafter.playClickSound((float)0.8f);
            } else if (mouseButton == 1) {
                this.attachment.filter.decLevel(i);
                GuiCrafter.playClickSound((float)0.6f);
            }
            this.setButtons();
            return;
        }
        if (buttonName.equals("import")) {
            GuiCrafter.playClickSound((float)0.8f);
            PacketTileInfo packet = this.crafter.getNewPacket((byte)0);
            packet.addByte(3);
            PacketHandler.sendToServer((PacketBase)packet);
        }
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.fluid != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)64.0f);
            this.field_73735_i = 200.0f;
            this.field_146296_j.field_77023_b = 200.0f;
            StackHandler.render((GuiContainerCore)this, x - this.field_147003_i - 8, y - this.field_147009_r - 8, (Object)this.fluid, true);
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179121_F();
        }
    }

    protected void func_191948_b(int x, int y) {
        if (this.fluid == null) {
            super.func_191948_b(x, y);
        }
    }

    public void addTooltips(List<String> tooltip) {
        if (this.fluid == null) {
            super.addTooltips(tooltip);
        }
    }

    @Override
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public static class Slot<I>
    implements Supplier<I>,
    Consumer<I> {
        private final ICrafter<I> crafter;
        private final boolean input;
        private final int recipe;
        private final int index;

        private Slot(ICrafter<I> crafter, int recipe, boolean input, int index) {
            this.crafter = crafter;
            this.recipe = recipe;
            this.input = input;
            this.index = index;
        }

        @Override
        public void accept(I stack) {
            if (this.recipe < this.crafter.getRecipes().size()) {
                ICrafter.Recipe<I> recipe = this.crafter.getRecipes().get(this.recipe);
                if (this.input) {
                    if (this.index < recipe.inputs.size()) {
                        recipe.inputs.set(this.index, stack);
                    }
                } else if (this.index < recipe.outputs.size()) {
                    recipe.outputs.set(this.index, stack);
                }
            }
            PacketTileInfo packet = this.crafter.getNewPacket((byte)0);
            packet.addByte(0);
            packet.addInt(this.recipe);
            packet.addBool(this.input);
            packet.addInt(this.index);
            StackHandler.writePacket((PacketBase)packet, stack, this.crafter.getItemClass(), false);
            PacketHandler.sendToServer((PacketBase)packet);
        }

        @Override
        public I get() {
            if (this.recipe < this.crafter.getRecipes().size()) {
                ICrafter.Recipe<I> recipe = this.crafter.getRecipes().get(this.recipe);
                if (this.input) {
                    if (this.index < recipe.inputs.size()) {
                        return recipe.inputs.get(this.index);
                    }
                } else if (this.index < recipe.outputs.size()) {
                    return recipe.outputs.get(this.index);
                }
            }
            return null;
        }

        public ICrafter<I> getCrafter() {
            return this.crafter;
        }
    }
}

