/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import primal_tech.ModBlocks;
import primal_tech.inventory.InventoryWrapperKilnGrill;
import primal_tech.tiles.TileEntityInventoryHelper;

public class TileEntityStoneGrill
extends TileEntityInventoryHelper
implements ITickable {
    private IItemHandler itemHandler;
    private static final int[] SLOTS = new int[]{0, 1};
    public int temp = 0;
    public boolean active;
    public byte rotation = 0;

    public TileEntityStoneGrill() {
        super(2);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if ((this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.CHARCOAL_HOPPER || this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150480_ab) && this.getTemp() < 200 && this.canSmelt()) {
            this.setTemp(this.getTemp() + 1);
        }
        if (this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() != ModBlocks.CHARCOAL_HOPPER && this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150480_ab && this.getTemp() > 0) {
            this.setTemp(this.getTemp() - 1);
        }
        if (this.func_145831_w().func_180495_p(pos) != null && this.getTemp() >= 200 && this.canSmelt()) {
            this.smeltItem();
            this.setTemp(0);
        }
        if (!this.canSmelt()) {
            this.setTemp(0);
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.getItems().get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.getItems().get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.getItems().get(1);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= 16;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.getItems().get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.getItems().get(1);
            if (itemstack2.func_190926_b()) {
                this.getItems().set(1, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public void setTemp(int temperature) {
        this.temp = temperature;
        this.markForUpdate();
    }

    public int getTemp() {
        return this.temp;
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("temp", this.temp);
        nbt.func_74774_a("rotation", this.rotation);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.temp = nbt.func_74762_e("temp");
        this.rotation = nbt.func_74771_c("rotation");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return ((ItemStack)this.getItems().get(0)).func_190926_b() || ((ItemStack)this.getItems().get(0)).func_190916_E() < this.func_70297_j_();
    }

    @Override
    public int func_70297_j_() {
        return 16;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InventoryWrapperKilnGrill((IInventory)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

