/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class TileGuidanceComputer
extends TileInventoryHatch
implements IModularInventory {
    int destinationId = -2147483647;
    Vector3F<Float> landingPos = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    Map<Integer, HashedBlockPosition> landingLoc = new HashMap<Integer, HashedBlockPosition>();

    public TileGuidanceComputer() {
        super(1);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        return modules;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void setLandingLocation(int stationId, StationLandingLocation loc) {
        if (loc == null) {
            this.landingLoc.remove(stationId);
        } else {
            this.landingLoc.put(stationId, loc.getPos());
        }
    }

    public StationLandingLocation getLandingLocation(int stationId) {
        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(stationId);
        if (obj == null) {
            this.landingLoc.remove(stationId);
            return null;
        }
        HashedBlockPosition myLoc = this.landingLoc.get(stationId);
        if (myLoc == null) {
            return null;
        }
        return ((SpaceObject)obj).getPadAtLocation(myLoc);
    }

    public long getTargetSatellite() {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            return ((ItemSatelliteIdentificationChip)stack.func_77973_b()).getSatelliteId(stack);
        }
        return -1L;
    }

    public int getDestinationDimId(int currentDimension, BlockPos pos) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            SatelliteBase sat;
            long l;
            Item itemType = stack.func_77973_b();
            if (itemType instanceof ItemPlanetIdentificationChip) {
                ItemPlanetIdentificationChip item = (ItemPlanetIdentificationChip)itemType;
                return item.getDimensionId(stack);
            }
            if (itemType instanceof ItemStationChip) {
                if (Configuration.spaceDimId == currentDimension) {
                    ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
                    if (object != null) {
                        if (ItemStationChip.getUUID(stack) == object.getId()) {
                            return object.getOrbitingPlanetId();
                        }
                    } else {
                        return -2147483647;
                    }
                }
                return Configuration.spaceDimId;
            }
            if (itemType instanceof ItemAsteroidChip) {
                this.destinationId = currentDimension;
                this.landingPos = new Vector3F((Object)Float.valueOf(pos.func_177958_n()), (Object)Float.valueOf(pos.func_177956_o()), (Object)Float.valueOf(pos.func_177952_p()));
                return currentDimension;
            }
            if (itemType instanceof ItemSatelliteIdentificationChip && (l = this.getTargetSatellite()) != -2147483647L && (sat = DimensionManager.getInstance().getSatellite(l)) != null) {
                return sat.getDimensionId();
            }
        }
        return this.destinationId;
    }

    public Vector3F<Float> getLandingLocation(int landingDimension, boolean commit) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip chip = (ItemStationChip)stack.func_77973_b();
            if (landingDimension == Configuration.spaceDimId) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                HashedBlockPosition vec = null;
                if (object instanceof SpaceObject) {
                    if (this.landingLoc.get(object.getId()) != null) {
                        vec = this.landingLoc.get(object.getId());
                        if (commit) {
                            ((SpaceObject)object).getPadAtLocation(this.landingLoc.get(object.getId())).setOccupied(true);
                        }
                    } else {
                        vec = ((SpaceObject)object).getNextLandingPad(commit);
                    }
                }
                if (object == null) {
                    return null;
                }
                if (vec == null) {
                    vec = object.getSpawnLocation();
                }
                return new Vector3F((Object)new Float(vec.x), (Object)new Float(vec.y), (Object)new Float(vec.z));
            }
            return chip.getTakeoffCoords(stack, landingDimension);
        }
        return null;
    }

    public void setFallbackDestination(int dimID, Vector3F<Float> coords) {
        this.destinationId = dimID;
        this.landingPos = coords;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("destDimId", this.destinationId);
        nbt.func_74776_a("landingx", ((Float)this.landingPos.x).floatValue());
        nbt.func_74776_a("landingy", ((Float)this.landingPos.y).floatValue());
        nbt.func_74776_a("landingz", ((Float)this.landingPos.z).floatValue());
        NBTTagList stationList = new NBTTagList();
        for (int locationID : this.landingLoc.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            HashedBlockPosition loc = this.landingLoc.get(locationID);
            tag.func_74783_a("pos", new int[]{loc.x, loc.y, loc.z});
            tag.func_74768_a("id", locationID);
            stationList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("stationMapping", (NBTBase)stationList);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.destinationId = nbt.func_74762_e("destDimId");
        this.landingPos.x = Float.valueOf(nbt.func_74760_g("landingx"));
        this.landingPos.y = Float.valueOf(nbt.func_74760_g("landingy"));
        this.landingPos.z = Float.valueOf(nbt.func_74760_g("landingz"));
        NBTTagList stationList = nbt.func_150295_c("stationMapping", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound tag = stationList.func_150305_b(i);
            int[] pos = tag.func_74759_k("pos");
            int id = tag.func_74762_e("id");
            this.landingLoc.put(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!stack.func_190926_b()) {
            this.destinationId = -2147483647;
        }
    }

    public void setReturnPosition(Vector3F<Float> pos, int dimId) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip item = (ItemStationChip)stack.func_77973_b();
            item.setTakeoffCoords(stack, pos, dimId);
        }
    }

    public String getModularInventoryName() {
        return "tile.guidanceComputer.name";
    }
}

