/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules.support;

import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.PotentialSpawnRule;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.CommonRuleEvaluator;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.varia.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class GenericRuleEvaluator
extends CommonRuleEvaluator {
    public GenericRuleEvaluator(AttributeMap map) {
        super(map, InControl.setup.getLogger(), (IModRuleCompatibilityLayer)new ModRuleCompatibilityLayer());
    }

    protected void addChecks(AttributeMap map) {
        super.addChecks(map);
        if (map.has(RuleKeys.HOSTILE)) {
            this.addHostileCheck(map);
        }
        if (map.has(RuleKeys.PASSIVE)) {
            this.addPassiveCheck(map);
        }
        if (map.has(RuleKeys.CANSPAWNHERE)) {
            this.addCanSpawnHereCheck(map);
        }
        if (map.has(RuleKeys.NOTCOLLIDING)) {
            this.addNotCollidingCheck(map);
        }
        if (map.has(RuleKeys.SPAWNER)) {
            this.addSpawnerCheck(map);
        }
        if (map.has(RuleKeys.MOB)) {
            this.addMobsCheck(map);
        }
        if (map.has(RuleKeys.PLAYER)) {
            this.addPlayerCheck(map);
        }
        if (map.has(RuleKeys.REALPLAYER)) {
            this.addRealPlayerCheck(map);
        }
        if (map.has(RuleKeys.FAKEPLAYER)) {
            this.addFakePlayerCheck(map);
        }
        if (map.has(RuleKeys.EXPLOSION)) {
            this.addExplosionCheck(map);
        }
        if (map.has(RuleKeys.PROJECTILE)) {
            this.addProjectileCheck(map);
        }
        if (map.has(RuleKeys.FIRE)) {
            this.addFireCheck(map);
        }
        if (map.has(RuleKeys.MAGIC)) {
            this.addMagicCheck(map);
        }
        if (map.has(RuleKeys.SOURCE)) {
            this.addSourceCheck(map);
        }
        if (map.has(RuleKeys.MOD)) {
            this.addModsCheck(map);
        }
        if (map.has(RuleKeys.MINCOUNT)) {
            this.addMinCountCheck(map);
        }
        if (map.has(RuleKeys.MAXCOUNT)) {
            this.addMaxCountCheck(map);
        }
    }

    private void addCanSpawnHereCheck(AttributeMap map) {
        boolean c = (Boolean)map.get(RuleKeys.CANSPAWNHERE);
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof EntityLiving) {
                    return ((EntityLiving)entity).func_70601_bi();
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof EntityLiving) {
                    return !((EntityLiving)entity).func_70601_bi();
                }
                return true;
            });
        }
    }

    private void addNotCollidingCheck(AttributeMap map) {
        boolean c = (Boolean)map.get(RuleKeys.NOTCOLLIDING);
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof EntityLiving) {
                    return ((EntityLiving)entity).func_70058_J();
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof EntityLiving) {
                    return !((EntityLiving)entity).func_70058_J();
                }
                return true;
            });
        }
    }

    private void addSpawnerCheck(AttributeMap map) {
        boolean c = (Boolean)map.get(RuleKeys.SPAWNER);
        if (c) {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return checkSpawn.isSpawner();
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return !checkSpawn.isSpawner();
                }
                return false;
            });
        }
    }

    private void addHostileCheck(AttributeMap map) {
        if (((Boolean)map.get(RuleKeys.HOSTILE)).booleanValue()) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof IMob);
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof IMob));
        }
    }

    private void addPassiveCheck(AttributeMap map) {
        if (((Boolean)map.get(RuleKeys.PASSIVE)).booleanValue()) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof IAnimals && !(query.getEntity(event) instanceof IMob));
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof IAnimals) || query.getEntity(event) instanceof IMob);
        }
    }

    private void addMobsCheck(AttributeMap map) {
        List mobs = map.getList(RuleKeys.MOB);
        if (mobs.size() == 1) {
            Class clazz;
            String name = (String)mobs.get(0);
            String id = PotentialSpawnRule.fixEntityId(name);
            EntityEntry ee = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            Class clazz2 = clazz = ee == null ? null : ee.getEntityClass();
            if (clazz != null) {
                this.checks.add((event, query) -> clazz.equals(query.getEntity(event).getClass()));
            } else {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + name + "'!");
            }
        } else {
            HashSet<Class> classes = new HashSet<Class>();
            for (String name : mobs) {
                Class clazz;
                String id = PotentialSpawnRule.fixEntityId(name);
                EntityEntry ee = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
                Class clazz3 = clazz = ee == null ? null : ee.getEntityClass();
                if (clazz != null) {
                    classes.add(clazz);
                    continue;
                }
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + name + "'!");
            }
            if (!classes.isEmpty()) {
                this.checks.add((event, query) -> classes.contains(query.getEntity(event).getClass()));
            }
        }
    }

    private void addModsCheck(AttributeMap map) {
        List mods = map.getList(RuleKeys.MOD);
        if (mods.size() == 1) {
            String modid = (String)mods.get(0);
            this.checks.add((event, query) -> {
                String id = Tools.findModID((Object)query.getEntity(event));
                return modid.equals(id);
            });
        } else {
            HashSet<String> modids = new HashSet<String>();
            for (String modid : mods) {
                modids.add(modid);
            }
            this.checks.add((event, query) -> {
                String id = Tools.findModID((Object)query.getEntity(event));
                return modids.contains(id);
            });
        }
    }

    private void addMinCountCheck(AttributeMap map) {
        int amount;
        String mincount = (String)map.get(RuleKeys.MINCOUNT);
        String[] splitted = StringUtils.split((String)mincount, (char)',');
        Class entityClass = null;
        try {
            amount = Integer.parseInt(splitted[0]);
        }
        catch (NumberFormatException e) {
            InControl.setup.getLogger().log(Level.ERROR, "Bad amount for mincount '" + splitted[0] + "'!");
            return;
        }
        if (splitted.length > 1) {
            String id = PotentialSpawnRule.fixEntityId(splitted[1]);
            EntityEntry ee = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            Class clazz = entityClass = ee == null ? null : ee.getEntityClass();
            if (entityClass == null) {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + splitted[1] + "'!");
                return;
            }
        }
        Class finalEntityClass = entityClass;
        this.checks.add((event, query) -> {
            int count = InControl.setup.cache.getCount(query.getWorld(event), (Class<? extends Entity>)(finalEntityClass == null ? query.getEntity(event).getClass() : finalEntityClass));
            return count >= amount;
        });
    }

    private void addMaxCountCheck(AttributeMap map) {
        int amount;
        String maxcount = (String)map.get(RuleKeys.MAXCOUNT);
        String[] splitted = StringUtils.split((String)maxcount, (char)',');
        Class entityClass = null;
        try {
            amount = Integer.parseInt(splitted[0]);
        }
        catch (NumberFormatException e) {
            InControl.setup.getLogger().log(Level.ERROR, "Bad amount for maxcount '" + splitted[0] + "'!");
            return;
        }
        if (splitted.length > 1) {
            String id = PotentialSpawnRule.fixEntityId(splitted[1]);
            EntityEntry ee = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            Class clazz = entityClass = ee == null ? null : ee.getEntityClass();
            if (entityClass == null) {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + splitted[1] + "'!");
                return;
            }
        }
        Class finalEntityClass = entityClass;
        this.checks.add((event, query) -> {
            int count = InControl.setup.cache.getCount(query.getWorld(event), (Class<? extends Entity>)(finalEntityClass == null ? query.getEntity(event).getClass() : finalEntityClass));
            return count < amount;
        });
    }

    private void addPlayerCheck(AttributeMap map) {
        boolean asPlayer = (Boolean)map.get(RuleKeys.PLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof EntityPlayer);
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof EntityPlayer);
        }
    }

    private boolean isFakePlayer(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        PlayerList playerList = DimensionManager.getWorld((int)0).func_73046_m().func_184103_al();
        EntityPlayerMP playerByUUID = playerList.func_177451_a(((EntityPlayer)entity).func_146103_bH().getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    private boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        return !this.isFakePlayer(entity);
    }

    private void addRealPlayerCheck(AttributeMap map) {
        boolean asPlayer = (Boolean)map.get(RuleKeys.REALPLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isRealPlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isRealPlayer(query.getAttacker(event)));
        }
    }

    private void addFakePlayerCheck(AttributeMap map) {
        boolean asPlayer = (Boolean)map.get(RuleKeys.FAKEPLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isFakePlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isFakePlayer(query.getAttacker(event)));
        }
    }

    private void addExplosionCheck(AttributeMap map) {
        boolean explosion = (Boolean)map.get(RuleKeys.EXPLOSION);
        if (explosion) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_94541_c());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_94541_c());
        }
    }

    private void addProjectileCheck(AttributeMap map) {
        boolean projectile = (Boolean)map.get(RuleKeys.PROJECTILE);
        if (projectile) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76352_a());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76352_a());
        }
    }

    private void addFireCheck(AttributeMap map) {
        boolean fire = (Boolean)map.get(RuleKeys.FIRE);
        if (fire) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76347_k());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76347_k());
        }
    }

    private void addMagicCheck(AttributeMap map) {
        boolean magic = (Boolean)map.get(RuleKeys.MAGIC);
        if (magic) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_82725_o());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_82725_o());
        }
    }

    private void addSourceCheck(AttributeMap map) {
        List sources = map.getList(RuleKeys.SOURCE);
        HashSet sourceSet = new HashSet(sources);
        this.checks.add((event, query) -> {
            if (query.getSource(event) == null) {
                return false;
            }
            return sourceSet.contains(query.getSource(event).func_76355_l());
        });
    }

    public boolean match(Event event, IEventQuery query) {
        for (BiFunction rule : this.checks) {
            if (((Boolean)rule.apply(event, query)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

