/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.CommonRuleEvaluator;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import mcjty.tools.varia.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LootRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<LivingDropsEvent> EVENT_QUERY = new IEventQuery<LivingDropsEvent>(){

        public World getWorld(LivingDropsEvent o) {
            return o.getEntity().func_130014_f_();
        }

        public BlockPos getPos(LivingDropsEvent o) {
            return o.getEntity().func_180425_c();
        }

        public BlockPos getValidBlockPos(LivingDropsEvent o) {
            return o.getEntity().func_180425_c().func_177977_b();
        }

        public int getY(LivingDropsEvent o) {
            return o.getEntity().func_180425_c().func_177956_o();
        }

        public Entity getEntity(LivingDropsEvent o) {
            return o.getEntity();
        }

        public DamageSource getSource(LivingDropsEvent o) {
            return o.getSource();
        }

        public Entity getAttacker(LivingDropsEvent o) {
            return o.getSource().func_76346_g();
        }

        public EntityPlayer getPlayer(LivingDropsEvent o) {
            Entity entity = o.getSource().func_76346_g();
            return entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static Random rnd = new Random();
    private final GenericRuleEvaluator ruleEvaluator;
    private List<Predicate<ItemStack>> toRemoveItems = new ArrayList<Predicate<ItemStack>>();
    private List<Pair<ItemStack, Function<Integer, Integer>>> toAddItems = new ArrayList<Pair<ItemStack, Function<Integer, Integer>>>();
    private boolean removeAll = false;

    private LootRule(AttributeMap map) {
        super(InControl.setup.getLogger());
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public static LootRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new LootRule(map);
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        super.addActions(map, layer);
        if (map.has(RuleKeys.ACTION_ITEM)) {
            this.addItem(map);
        }
        if (map.has(RuleKeys.ACTION_REMOVE)) {
            this.removeItem(map);
        }
        if (map.has(RuleKeys.ACTION_REMOVEALL)) {
            this.removeAll = (Boolean)map.get(RuleKeys.ACTION_REMOVEALL);
        }
    }

    public List<Predicate<ItemStack>> getToRemoveItems() {
        return this.toRemoveItems;
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public List<Pair<ItemStack, Function<Integer, Integer>>> getToAddItems() {
        return this.toAddItems;
    }

    private Function<Integer, Integer> getCountFunction(@Nullable String itemcount) {
        if (itemcount == null) {
            return looting -> 1;
        }
        String[] loottable = StringUtils.split((String)itemcount, (char)'/');
        int[] min = new int[loottable.length];
        int[] max = new int[loottable.length];
        for (int i = 0; i < loottable.length; ++i) {
            String[] minmax = StringUtils.split((String)loottable[i], (char)'-');
            if (minmax.length == 1) {
                try {
                    min[i] = max[i] = Integer.parseInt(minmax[0]);
                }
                catch (NumberFormatException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad amount specified in loot rule: " + minmax);
                    max[i] = 1;
                    min[i] = 1;
                }
                continue;
            }
            if (minmax.length == 2) {
                try {
                    min[i] = Integer.parseInt(minmax[0]);
                    max[i] = Integer.parseInt(minmax[1]);
                }
                catch (NumberFormatException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad amounts specified in loot rule: " + minmax);
                    max[i] = 1;
                    min[i] = 1;
                }
                continue;
            }
            InControl.setup.getLogger().log(Level.ERROR, "Bad amount range specified in loot rule: " + minmax);
            max[i] = 1;
            min[i] = 1;
        }
        if (loottable.length == 1) {
            if (min[0] == max[0]) {
                return looting -> min[0];
            }
            return looting -> rnd.nextInt(max[0] - min[0] + 1) + min[0];
        }
        return looting -> {
            if (looting >= min.length) {
                return rnd.nextInt(max[min.length - 1] - min[min.length - 1] + 1) + min[min.length - 1];
            }
            if (looting >= 0) {
                return rnd.nextInt(max[looting] - min[looting] + 1) + min[looting];
            }
            return rnd.nextInt(max[0] - min[0] + 1) + min[0];
        };
    }

    private List<Pair<ItemStack, Function<Integer, Integer>>> getItems(List<String> itemNames, @Nullable String nbtJson, @Nullable String itemcount) {
        Function<Integer, Integer> countFunction = this.getCountFunction(itemcount);
        ArrayList<Pair<ItemStack, Function<Integer, Integer>>> items = new ArrayList<Pair<ItemStack, Function<Integer, Integer>>>();
        for (String name : itemNames) {
            ItemStack stack = Tools.parseStack((String)name, (Logger)InControl.setup.getLogger());
            if (stack.func_190926_b()) {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown item '" + name + "'!");
                continue;
            }
            if (nbtJson != null) {
                try {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)nbtJson));
                }
                catch (NBTException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad nbt for '" + name + "'!");
                }
            }
            items.add((Pair<ItemStack, Function<Integer, Integer>>)Pair.of((Object)stack, countFunction));
        }
        return items;
    }

    private void addItem(AttributeMap map) {
        String nbt = (String)map.get(RuleKeys.ACTION_ITEMNBT);
        String itemcount = (String)map.get(RuleKeys.ACTION_ITEMCOUNT);
        this.toAddItems.addAll(this.getItems(map.getList(RuleKeys.ACTION_ITEM), nbt, itemcount));
    }

    private void removeItem(AttributeMap map) {
        this.toRemoveItems.addAll(CommonRuleEvaluator.getItems((List)map.getList(RuleKeys.ACTION_REMOVE), (Logger)this.logger));
    }

    public boolean match(LivingDropsEvent event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    static {
        FACTORY.attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create((Key)RuleKeys.INBUILDING)).attribute(Attribute.create((Key)RuleKeys.INCITY)).attribute(Attribute.create((Key)RuleKeys.GAMESTAGE)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.create((Key)RuleKeys.INSTREET)).attribute(Attribute.create((Key)RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.PLAYER)).attribute(Attribute.create(RuleKeys.REALPLAYER)).attribute(Attribute.create(RuleKeys.FAKEPLAYER)).attribute(Attribute.create(RuleKeys.PROJECTILE)).attribute(Attribute.create(RuleKeys.EXPLOSION)).attribute(Attribute.create(RuleKeys.FIRE)).attribute(Attribute.create(RuleKeys.MAGIC)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.SOURCE)).attribute(Attribute.createMulti((Key)RuleKeys.HELMET)).attribute(Attribute.createMulti((Key)RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti((Key)RuleKeys.LEGGINGS)).attribute(Attribute.createMulti((Key)RuleKeys.BOOTS)).attribute(Attribute.createMulti((Key)RuleKeys.AMULET)).attribute(Attribute.createMulti((Key)RuleKeys.RING)).attribute(Attribute.createMulti((Key)RuleKeys.BELT)).attribute(Attribute.createMulti((Key)RuleKeys.TRINKET)).attribute(Attribute.createMulti((Key)RuleKeys.HEAD)).attribute(Attribute.createMulti((Key)RuleKeys.BODY)).attribute(Attribute.createMulti((Key)RuleKeys.CHARM)).attribute(Attribute.create((Key)RuleKeys.STATE)).attribute(Attribute.create((Key)RuleKeys.PSTATE)).attribute(Attribute.createMulti((Key)RuleKeys.HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_ITEMNBT)).attribute(Attribute.create(RuleKeys.ACTION_ITEMCOUNT)).attribute(Attribute.createMulti(RuleKeys.ACTION_ITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_REMOVE)).attribute(Attribute.create(RuleKeys.ACTION_REMOVEALL));
    }
}

