/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.container.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemPickupManager
extends ItemLocationBoundModular
implements IKeyBound {
    public static final String TAG_NAME_CONTAINER = "PickupManager";
    public static final String TAG_NAME_TX_INVENTORY = "TransportItems";
    public static final String TAG_NAME_FILTER_INVENTORY_PRE = "FilterItems_";
    public static final String TAG_NAME_PRESET_SELECTION = "SelPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final String TAG_NAME_INVFILTER_ENABLED = "InvFiltEnabled";
    public static final String TAG_NAME_INVFILTER_MODE = "InvFiltMode";
    public static final String TAG_NAME_INVFILTER_META = "InvFiltMeta";
    public static final String TAG_NAME_INVFILTER_NBT = "InvFiltNBT";
    public static final String TAG_NAME_TXFILTER_ENABLED = "TxFiltEnabled";
    public static final String TAG_NAME_TXFILTER_MODE = "TxFiltMode";
    public static final String TAG_NAME_TXFILTER_META = "TxFiltMeta";
    public static final String TAG_NAME_TXFILTER_NBT = "TxFiltNBT";
    public static final int ENDER_CHARGE_COST_PER_SENT_ITEM = 2;
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_CHANGE_PRESET = 1;
    public static final int GUI_ACTION_TOGGLE_INVENTORY_SETTINGS = 2;
    public static final int GUI_ACTION_TOGGLE_TRANSPORT_SETTINGS = 3;
    public static final SlotRange TRANSPORT_FILTER_SLOTS = new SlotRange(0, 18);
    public static final SlotRange INVENTORY_FILTER_SLOTS = new SlotRange(18, 18);

    public ItemPickupManager(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (player.func_70093_af() && te != null && (te.getClass() == TileEntityEnderChest.class || te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side))) {
                ItemStack stack = player.func_184586_b(hand);
                UtilItemModular.setTarget(stack, player, pos, side, hitX, hitY, hitZ, false, false);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
            player.field_71070_bA.func_75142_b();
            player.openGui((Object)EnderUtilities.instance, 1004, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        byte preset = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        int lc = UtilItemModular.getStoredModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String pre = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String str = " - pre: " + pre + (preset + 1) + rst + " LC: " + pre + lc + rst;
        String target = this.getTargetDisplayName(stack);
        if (target != null) {
            str = str + " - " + pre + target + rst;
        }
        return this.getBaseItemDisplayName(stack) + str;
    }

    @Override
    public void addTooltipLines(ItemStack containerStack, EntityPlayer player, List<String> list, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String str = ItemPickupManager.isEnabled(containerStack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        list.add(str);
        int preset = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION) + 1;
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.preset", (Object[])new Object[0]) + ": " + TextFormatting.BLUE.toString() + preset + rst);
        super.addTooltipLines(containerStack, player, list, verbose);
    }

    public static NBTTagCompound getSelectedPresetTag(ItemStack stack, boolean create) {
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagCompound containerTag = NBTUtils.getCompoundTag(stack, TAG_NAME_CONTAINER, create);
        if (containerTag != null) {
            byte selection = containerTag.func_74771_c(TAG_NAME_PRESET_SELECTION);
            if (containerTag.func_150297_b(TAG_NAME_PRESET + selection, 10)) {
                return containerTag.func_74775_l(TAG_NAME_PRESET + selection);
            }
            if (create) {
                NBTTagCompound tag = new NBTTagCompound();
                containerTag.func_74782_a(TAG_NAME_PRESET + selection, (NBTBase)tag);
                return tag;
            }
        }
        return null;
    }

    public static byte getSettingValue(ItemStack stack, String tagName) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, false);
        return tag != null ? tag.func_74771_c(tagName) : (byte)0;
    }

    public static void setSettingValue(ItemStack stack, String tagName, byte value) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, true);
        tag.func_74774_a(tagName, value);
    }

    public static boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    public static List<ItemStack> getEnabledItems(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.PICKUP_MANAGER);
        ArrayList<ItemStack> enabledItems = new ArrayList<ItemStack>();
        for (int slot : slots) {
            ItemStack stack = playerInv.getStackInSlot(slot);
            if (!ItemPickupManager.isEnabled(stack)) continue;
            enabledItems.add(stack);
        }
        return enabledItems;
    }

    public static ItemStack getFirstEnabledItem(EntityPlayer player) {
        List<ItemStack> items = ItemPickupManager.getEnabledItems(player);
        return items.size() > 0 ? items.get(0) : ItemStack.field_190927_a;
    }

    public boolean tryTransportItemsFromTransportSlot(InventoryItem inv, EntityPlayer player, ItemStack manager) {
        ItemStack stack = inv.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return false;
        }
        int sizeOrig = stack.func_190916_E();
        int max = stack.func_77976_d();
        stack = inv.extractItem(0, max, false);
        while (!stack.func_190926_b()) {
            if (!(stack = this.tryTransportItems(player, manager, stack)).func_190926_b()) {
                inv.insertItem(0, stack, false);
                break;
            }
            stack = inv.extractItem(0, max, false);
        }
        return (stack = inv.getStackInSlot(0)).func_190926_b() || stack.func_190916_E() != sizeOrig;
    }

    public ItemStack tryTransportItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        if (itemsIn.func_190926_b()) {
            return itemsIn;
        }
        IItemHandler inv = UtilItemModular.getBoundInventory(manager, player, 30);
        if (inv == null) {
            return itemsIn;
        }
        ItemStack stackToSend = itemsIn.func_77946_l();
        int cost = 2;
        if (!UtilItemModular.useEnderCharge(manager, cost * itemsIn.func_190916_E(), true)) {
            int available = UtilItemModular.getAvailableEnderCharge(manager);
            if (available < cost) {
                return itemsIn;
            }
            stackToSend.func_190920_e(Math.min(itemsIn.func_190916_E(), available / cost));
        }
        int numTransported = stackToSend.func_190916_E();
        ItemStack itemsRemaining = InventoryUtils.tryInsertItemStackToInventory(inv, stackToSend);
        if (!itemsRemaining.func_190926_b()) {
            numTransported -= itemsRemaining.func_190916_E();
        }
        itemsIn.func_190918_g(numTransported);
        UtilItemModular.useEnderCharge(manager, numTransported * cost, false);
        if (itemsIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return itemsIn;
    }

    public Result handleItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        byte mode;
        boolean match;
        boolean ignoreNbt;
        boolean ignoreMeta;
        byte preset = NBTUtils.getByte(manager, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        InventoryItem inv = new InventoryItem(manager, 36, 1, false, player.func_130014_f_().field_72995_K, TAG_NAME_FILTER_INVENTORY_PRE + preset);
        inv.readFromContainerItemStack();
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange(inv, TRANSPORT_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_MODE);
            if (mode != 0 && match || mode == 0 && !match) {
                ItemStack stackTmp = this.tryTransportItems(player, manager, itemsIn);
                if (stackTmp.func_190926_b()) {
                    return Result.TRANSPORTED;
                }
                itemsIn.func_190920_e(stackTmp.func_190916_E());
            }
        }
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange(inv, INVENTORY_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_MODE);
            if (mode != 0) {
                return match ? Result.WHITELISTED : Result.NOT_WHITELISTED;
            }
            if (mode == 0) {
                return match ? Result.BLACKLISTED : Result.NOT_BLACKLISTED;
            }
        }
        return Result.NOT_HANDLED;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return false;
        }
        EntityPlayer player = event.getEntityPlayer();
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        boolean blackListed = false;
        boolean transported = false;
        Iterator<ItemStack> iter = event.drops.iterator();
        block0: while (iter.hasNext()) {
            ItemStack stackIn = iter.next();
            if (stackIn.func_190926_b()) continue;
            for (ItemStack manager : managers) {
                Result result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stackIn);
                if (result == Result.BLACKLISTED) {
                    blackListed = true;
                    deny = true;
                    continue block0;
                }
                if (result == Result.TRANSPORTED) {
                    iter.remove();
                    transported = true;
                    continue block0;
                }
                if (result == Result.WHITELISTED && !blackListed) {
                    deny = false;
                    continue block0;
                }
                if (blackListed || result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
                deny = false;
            }
        }
        if (transported) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (deny) {
            event.setCanceled(true);
        }
        return deny;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        EntityItem entityItem = event.getItem();
        ItemStack stack = entityItem.func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_130014_f_().field_72995_K || entityItem.field_70128_L || stack.func_190926_b()) {
            return true;
        }
        ItemStack origStack = ItemStack.field_190927_a;
        int origStackSize = stack.func_190916_E();
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        for (ItemStack manager : managers) {
            Result result;
            if (origStack == ItemStack.field_190927_a) {
                origStack = stack.func_77946_l();
            }
            if ((result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stack)) == Result.BLACKLISTED || result == Result.TRANSPORTED) {
                if (result == Result.TRANSPORTED) {
                    entityItem.func_70106_y();
                }
                deny = true;
                break;
            }
            if (result == Result.WHITELISTED) {
                deny = false;
                break;
            }
            if (result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
            deny = false;
        }
        if (stack.func_190916_E() != origStackSize || entityItem.field_70128_L) {
            if (!entityItem.func_174814_R()) {
                player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((player.func_130014_f_().field_73012_v.nextFloat() - player.func_130014_f_().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (stack.func_190926_b() || entityItem.field_70128_L) {
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, entityItem, origStack);
                player.func_71001_a((Entity)entityItem, origStackSize);
            }
        }
        if (deny) {
            event.setCanceled(true);
        }
        return deny;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        return super.doKeyBindingAction(player, stack, key);
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (!(player.field_71070_bA instanceof ContainerPickupManager)) {
            return;
        }
        ContainerPickupManager container = (ContainerPickupManager)player.field_71070_bA;
        ItemStack stack = container.getContainerItem();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemPickupManager)) {
            return;
        }
        if (action == 0 && element >= 0 && element < 3) {
            UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, element);
            ((ItemPickupManager)stack.func_77973_b()).tryTransportItemsFromTransportSlot(container.inventoryItemTransmit, player, stack);
        } else if (action == 1 && element >= 0 && element < 4) {
            NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            container.inventoryItemFilters.setItemStorageTagName(TAG_NAME_FILTER_INVENTORY_PRE + element);
            container.inventoryItemFilters.readFromContainerItemStack();
        } else if (action == 2 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_INVFILTER_ENABLED : (element == 1 ? TAG_NAME_INVFILTER_MODE : (element == 2 ? TAG_NAME_INVFILTER_META : TAG_NAME_INVFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        } else if (action == 3 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_TXFILTER_ENABLED : (element == 1 ? TAG_NAME_TXFILTER_MODE : (element == 2 ? TAG_NAME_TXFILTER_META : TAG_NAME_TXFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
            return 3;
        }
        if (ItemModule.ModuleType.TYPE_ENDERCAPACITOR.equals(moduleType)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_77973_b() instanceof IModule) {
            IModule imodule = (IModule)moduleStack.func_77973_b();
            ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
            if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
                if (imodule.getModuleTier(moduleStack) == 1) {
                    return this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                }
            } else {
                return this.getMaxModules(containerStack, moduleType);
            }
        }
        return 0;
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "locked=false"), new ModelResourceLocation(rl, "locked=true")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "locked=" + NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED));
    }

    public static enum Result {
        TRANSPORTED,
        WHITELISTED,
        NOT_WHITELISTED,
        BLACKLISTED,
        NOT_BLACKLISTED,
        NOT_HANDLED;

    }
}

