/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerDrawbridge;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityDrawbridge;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiDrawbridge
extends GuiEnderUtilities
implements IButtonStateCallback {
    private final TileEntityDrawbridge tedb;
    private final boolean advanced;

    public GuiDrawbridge(ContainerDrawbridge container, TileEntityDrawbridge te) {
        super(container, 176, 136, "gui.container.drawbridge_normal");
        this.tedb = te;
        this.advanced = te.isAdvanced();
        if (this.advanced) {
            this.field_147000_g = 210;
            this.guiTexture = ReferenceTextures.getGuiTexture("gui.container.drawbridge_advanced");
        }
        this.infoArea = new GuiEnderUtilities.InfoArea(160, 5, 11, 11, "enderutilities.gui.infoarea.drawbridge", new Object[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)("enderutilities.container.drawbridge" + (this.advanced ? "_advanced" : "")), (Object[])new Object[0]), 8, 5, 0x404040);
        if (this.advanced) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 117, 0x404040);
            String str = I18n.func_135052_a((String)"enderutilities.gui.label.drawbridge.delay_num", (Object[])new Object[]{this.tedb.getDelay()});
            this.field_146289_q.func_78276_b(str, 70, 19, 0x404040);
            str = I18n.func_135052_a((String)"enderutilities.gui.label.drawbridge.length_num", (Object[])new Object[]{this.tedb.getMaxLength()});
            this.field_146289_q.func_78276_b(str, 70, 31, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 43, 0x404040);
            String str = I18n.func_135052_a((String)"enderutilities.gui.label.drawbridge.delay_num", (Object[])new Object[]{this.tedb.getDelay()});
            this.field_146289_q.func_78276_b(str, 76, 19, 0x404040);
            str = I18n.func_135052_a((String)"enderutilities.gui.label.drawbridge.length_num", (Object[])new Object[]{this.tedb.getMaxLength()});
            this.field_146289_q.func_78276_b(str, 76, 31, 0x404040);
        }
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        super.func_146976_a(gameTicks, mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.advanced) {
            SlotRange range = this.container.getCustomInventorySlotRange();
            for (int i = range.first; i < range.lastExc; ++i) {
                Slot slot = this.container.func_75139_a(i);
                if (slot == null) continue;
                this.func_73729_b(x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, 7, 127, 18, 18);
            }
        }
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.advanced) {
            this.field_146292_n.add(new GuiButtonHoverText(0, x + 18, y + 24, 14, 14, 60, 42, this.guiTextureWidgets, 14, 0, "enderutilities.gui.label.drawbridge.take_blocks"));
            this.field_146292_n.add(new GuiButtonHoverText(1, x + 57, y + 19, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.drawbridge.delay"));
            this.field_146292_n.add(new GuiButtonHoverText(2, x + 57, y + 30, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.drawbridge.block_count"));
            this.field_146292_n.add(new GuiButtonStateCallback(3, x + 36, y + 24, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 210, "enderutilities.gui.label.drawbridge.redstone_mode.extend_when_powered"), GuiButtonStateCallback.ButtonState.createTranslate(60, 196, "enderutilities.gui.label.drawbridge.redstone_mode.retract_when_powered"), GuiButtonStateCallback.ButtonState.createTranslate(60, 238, "enderutilities.gui.label.drawbridge.redstone_mode.toggle_on_pulse")));
        } else {
            this.field_146292_n.add(new GuiButtonHoverText(0, x + 27, y + 22, 14, 14, 60, 42, this.guiTextureWidgets, 14, 0, "enderutilities.gui.label.drawbridge.take_blocks"));
            this.field_146292_n.add(new GuiButtonHoverText(1, x + 63, y + 19, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.drawbridge.delay"));
            this.field_146292_n.add(new GuiButtonHoverText(2, x + 63, y + 31, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.drawbridge.block_count"));
            this.field_146292_n.add(new GuiButtonStateCallback(3, x + 45, y + 22, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 210, "enderutilities.gui.label.drawbridge.redstone_mode.extend_when_powered"), GuiButtonStateCallback.ButtonState.createTranslate(60, 196, "enderutilities.gui.label.drawbridge.redstone_mode.retract_when_powered"), GuiButtonStateCallback.ButtonState.createTranslate(60, 238, "enderutilities.gui.label.drawbridge.redstone_mode.toggle_on_pulse")));
        }
    }

    @Override
    protected void actionPerformedWithButton(GuiButton button, int mouseButton) throws IOException {
        int dim = this.tedb.func_145831_w().field_73011_w.getDimension();
        int amount = 0;
        if (mouseButton == 0 || mouseButton == 11) {
            amount = 1;
        } else if (mouseButton == 1 || mouseButton == 9) {
            amount = -1;
        }
        if (button.field_146127_k >= 0 && button.field_146127_k <= 3) {
            if (GuiScreen.func_146272_n()) {
                amount *= 8;
            }
            if (GuiScreen.func_146271_m()) {
                amount *= 4;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tedb.func_174877_v(), 0, button.field_146127_k, amount));
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        if (callbackId == 3) {
            return this.tedb.getRedstoneModeIntValue();
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }
}

