/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TMultiPart;
import codechicken.translocators.client.render.RenderTranslocator;
import codechicken.translocators.container.ContainerItemTranslocator;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.init.ModItems;
import codechicken.translocators.network.TranslocatorSPH;
import codechicken.translocators.part.TranslocatorPart;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemTranslocatorPart
extends TranslocatorPart
implements IRedstonePart {
    public boolean regulate;
    public boolean signal;
    public boolean a_powering;
    public ItemStack[] filters;
    public List<MovingItem> movingItems = new LinkedList<MovingItem>();

    public ItemTranslocatorPart() {
        this.filters = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.field_190927_a);
    }

    public ResourceLocation getType() {
        return new ResourceLocation("translocators", "item_translocator");
    }

    @Override
    public int getTType() {
        return 0;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((Item)ModItems.translocatorPart, 1, 0);
    }

    @Override
    public int getIconIndex() {
        int i = super.getIconIndex();
        if (this.regulate) {
            i |= 8;
        }
        if (this.signal) {
            i |= this.a_powering ? 32 : 16;
        }
        return i;
    }

    @Override
    public boolean canStay() {
        BlockPos pos = this.pos().func_177972_a(EnumFacing.field_82609_l[this.side]);
        TileEntity tile = this.world().func_175625_s(pos);
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.world().field_72995_K) {
            this.movingItems.removeIf(MovingItem::update);
        } else {
            IItemHandler[] handlers;
            if (this.a_eject) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = this.canInsert(i) || i == this.side ? InventoryUtils.getItemHandlerOrEmpty((IBlockAccess)this.world(), (BlockPos)this.pos().func_177972_a(EnumFacing.field_82609_l[i]), (int)(i ^ 1)) : EmptyHandler.INSTANCE;
                }
                IItemHandler myHandler = handlers[this.side];
                int largestSize = 0;
                int largestSlot = 0;
                for (int slot = 0; slot < myHandler.getSlots(); ++slot) {
                    int size;
                    ItemStack stack = myHandler.getStackInSlot(slot);
                    if (stack.func_190926_b() || !InventoryUtils.canExtractStack((IItemHandler)myHandler, (int)slot)) continue;
                    int n = size = this.fast ? stack.func_190916_E() : 1;
                    if (size <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getExtractableAmount(stack, this, myHandler))) <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getInsertableAmount(stack, this, handlers))) <= largestSize) continue;
                    largestSlot = slot;
                    largestSize = size;
                }
                if (largestSize > 0) {
                    ItemStack move = myHandler.extractItem(largestSlot, largestSize, true);
                    move = move.func_77946_l();
                    int initialCount = move.func_190916_E();
                    ArrayList<MovingItem> transfers = new ArrayList<MovingItem>();
                    this.spreadOutput(move, false, handlers, transfers);
                    this.spreadOutput(move, true, handlers, transfers);
                    myHandler.extractItem(largestSlot, initialCount - move.func_190916_E(), false);
                    this.sendTransferPacket(transfers);
                }
            }
            if (this.signal) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = InventoryUtils.getItemHandlerOrEmpty((IBlockAccess)this.world(), (BlockPos)this.pos().func_177972_a(EnumFacing.field_82609_l[i]), (int)(i ^ 1));
                }
                if (this.a_eject) {
                    boolean allSatisfied = true;
                    for (int i = 0; i < 6; ++i) {
                        TMultiPart other = this.tile().partMap(i);
                        ItemTranslocatorPart otherPart = (ItemTranslocatorPart)other;
                        if (otherPart.a_eject || otherPart.isSatisfied(handlers[i])) continue;
                        allSatisfied = false;
                    }
                    this.setPowering(allSatisfied);
                } else {
                    this.setPowering(!this.canTransferFilter(handlers[this.side], handlers));
                }
            }
        }
    }

    private void sendTransferPacket(List<MovingItem> transfers) {
        MCDataOutput packet = this.getIncStream();
        packet.writeVarInt(transfers.size());
        for (MovingItem transfer : transfers) {
            packet.writeByte(transfer.dst);
            packet.writeItemStack(transfer.stack);
        }
    }

    private boolean canTransferFilter(IItemHandler access, IItemHandler[] attached) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (this.regulate && InventoryUtils.countMatchingStacks((IItemHandler)access, (ItemStack)filter, (boolean)false) <= ItemTranslocatorPart.filterCount(this, filter) || ItemTranslocatorPart.getInsertableAmount(filter, this, attached) <= 0) continue;
            return true;
        }
        return !filterSet;
    }

    private boolean isSatisfied(IItemHandler handler) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (!(this.regulate ? InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)filter, (!this.a_eject ? 1 : 0) != 0) < ItemTranslocatorPart.filterCount(this, filter) : InventoryUtils.getInsertableQuantity((IItemHandler)handler, (ItemStack)filter) > 0)) continue;
            return false;
        }
        return filterSet || !this.hasEmptySpace(handler);
    }

    private boolean hasEmptySpace(IItemHandler handler) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            boolean b;
            ItemStack stack = handler.getStackInSlot(slot);
            boolean bl = b = stack.func_190926_b() || stack.func_77985_e() && stack.func_190916_E() < Math.min(stack.func_77976_d(), handler.getSlotLimit(slot));
            if (!InventoryUtils.canInsertStack((IItemHandler)handler, (int)slot, (ItemStack)new ItemStack(Items.field_151045_i)) || !b) continue;
            return true;
        }
        return false;
    }

    private void spreadOutput(ItemStack move, boolean rspass, IItemHandler[] attached, List<MovingItem> transfers) {
        if (move.func_190916_E() == 0) {
            return;
        }
        int outputCount = 0;
        int[] outputQuantities = new int[6];
        for (byte i = 0; i < 6; ++i) {
            ItemTranslocatorPart part;
            TMultiPart p = this.tile().partMap((int)i);
            if (!(p instanceof ItemTranslocatorPart) || (part = (ItemTranslocatorPart)p).canEject() || part.redstone != rspass || i == this.side) continue;
            outputQuantities[i] = ItemTranslocatorPart.getInsertableAmount(move, part, attached[i]);
            if (outputQuantities[i] <= 0) continue;
            ++outputCount;
        }
        for (int dst = 0; dst < 6 && move.func_190916_E() > 0; ++dst) {
            int qty = outputQuantities[dst];
            if (qty <= 0) continue;
            qty = Math.min(qty, move.func_190916_E() / outputCount + this.world().field_73012_v.nextInt(move.func_190916_E() % outputCount + 1));
            --outputCount;
            if (qty == 0) continue;
            IItemHandler handler = attached[dst];
            ItemStack add = ItemUtils.copyStack((ItemStack)move, (int)qty);
            ItemStack remain = InventoryUtils.insertItem((IItemHandler)handler, (ItemStack)add, (boolean)false);
            move.func_190918_g(qty - remain.func_190916_E());
            add.func_190918_g(remain.func_190916_E());
            if (add.func_190926_b()) continue;
            transfers.add(new MovingItem(dst, add));
        }
    }

    private static int filterCount(ItemTranslocatorPart part, ItemStack stack) {
        boolean filterSet = false;
        int match = 0;
        for (ItemStack filter : part.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (!ItemUtils.areStacksSameType((ItemStack)stack, (ItemStack)filter)) continue;
            match += filter.func_190916_E();
        }
        return filterSet ? match : -1;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler[] handler) {
        int insertableAmount = 0;
        for (int i = 0; i < 6; ++i) {
            if (!me.canInsert(i)) continue;
            insertableAmount += ItemTranslocatorPart.getInsertableAmount(stack, (ItemTranslocatorPart)((Object)me.getOther(i)), handler[i]);
        }
        return insertableAmount;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler range) {
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return 0;
        }
        int fit = InventoryUtils.getInsertableQuantity((IItemHandler)range, (ItemStack)stack);
        if (fit == 0) {
            return 0;
        }
        if (me.regulate && filter > 0) {
            fit = Math.min(fit, filter - InventoryUtils.countMatchingStacks((IItemHandler)range, (ItemStack)stack, (boolean)true));
        }
        return fit > 0 ? fit : 0;
    }

    private static int getExtractableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler handler) {
        int qty;
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return me.regulate ? stack.func_77976_d() : 0;
        }
        int n = qty = filter < 0 ? stack.func_77976_d() : filter;
        if (me.regulate && filter > 0) {
            qty = Math.min(qty, InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)stack, (boolean)false) - filter);
        }
        return qty > 0 ? qty : 0;
    }

    @Override
    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack held, EnumHand hand) {
        if (this.world().field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (ItemUtils.areStacksSameType((ItemStack)stack, (ItemStack)ConfigHandler.nugget) && !this.regulate) {
            this.regulate = true;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.markUpdate();
            return true;
        }
        if (stack.func_77973_b() == Items.field_151042_j && !this.signal) {
            this.signal = true;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.markUpdate();
            return true;
        }
        return super.activate(player, hit, stack, hand);
    }

    @Override
    public void stripModifiers() {
        super.stripModifiers();
        if (this.regulate) {
            this.regulate = false;
            this.dropItem(ItemUtils.copyStack((ItemStack)ConfigHandler.nugget, (int)1));
        }
        if (this.signal) {
            this.setPowering(false);
            this.signal = false;
            this.dropItem(new ItemStack(Items.field_151042_j));
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        this.openItemGui(player, this.filters, this.regulate ? "translocators.regulate" : "translocators.filter");
    }

    private void openItemGui(EntityPlayer player, ItemStack[] filters, String string) {
        ServerUtils.openSMPContainer((EntityPlayerMP)((EntityPlayerMP)player), (Container)new ContainerItemTranslocator(new InventorySimple(filters, this.filterStackLimit()){

            public void func_70296_d() {
                ItemTranslocatorPart.this.markUpdate();
            }
        }, player.field_71071_by), (player1, windowId) -> {
            PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 4);
            packet.writeByte(windowId.intValue());
            packet.writeShort(this.filterStackLimit());
            packet.writeString(string);
            packet.sendToPlayer((EntityPlayer)player1);
        });
    }

    private int filterStackLimit() {
        if (this.regulate) {
            return 65535;
        }
        if (this.fast) {
            return 64;
        }
        return 1;
    }

    public void setPowering(boolean b) {
        if ((this.signal || !b) && b != this.a_powering) {
            this.a_powering = b;
            this.world().func_175685_c(this.pos(), (Block)Blocks.field_150488_af, true);
            this.world().func_175685_c(this.pos().func_177972_a(EnumFacing.field_82609_l[this.side]), (Block)Blocks.field_150488_af, true);
            this.markUpdate();
        }
    }

    @Override
    public void readIncUpdate(MCDataInput packet) {
        int expected = packet.readVarInt();
        for (int i = 0; i < expected; ++i) {
            byte dst = packet.readByte();
            ItemStack stack = packet.readItemStack();
            this.movingItems.add(new MovingItem(dst, stack));
        }
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74757_a("regulate", this.regulate);
        tag.func_74757_a("signal", this.signal);
        tag.func_74757_a("powering", this.a_powering);
        tag.func_74782_a("filters", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.filters, (int)65536));
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.regulate = tag.func_74767_n("regulate");
        this.signal = tag.func_74767_n("signal");
        this.a_powering = tag.func_74767_n("powering");
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.filters, (NBTTagList)tag.func_150295_c("filters", 10));
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeBoolean(this.regulate);
        packet.writeBoolean(this.signal);
        packet.writeBoolean(this.a_powering);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.regulate = packet.readBoolean();
        this.signal = packet.readBoolean();
        this.a_powering = packet.readBoolean();
    }

    @Override
    public void renderDynamic(Vector3 pos, int pass, float frame) {
        RenderTranslocator.renderItem(this, pos, frame);
        super.renderDynamic(pos, pass, frame);
    }

    @Override
    public boolean canRenderDynamic(int pass) {
        return super.canRenderDynamic(pass) || pass == 0 && !this.movingItems.isEmpty();
    }

    public int strongPowerLevel(int side) {
        return this.a_powering && side == this.side ? 15 : 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        return this.redstone;
    }

    public class MovingItem {
        public int dst;
        public ItemStack stack;
        public double a_progress;
        public double b_progress;

        public MovingItem(int dst, ItemStack stack) {
            this.dst = dst;
            this.stack = stack;
        }

        public boolean update() {
            if (this.a_progress >= 1.0) {
                return true;
            }
            this.b_progress = this.a_progress;
            this.a_progress = MathHelper.approachLinear((double)this.a_progress, (double)1.0, (double)0.2);
            return false;
        }
    }
}

