/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.network.Sync;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.DataImporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import org.apache.commons.lang3.math.NumberUtils;

public class ChatCommand
extends CommandBase {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;
    private final List<String> playerSubCommands = Arrays.asList("get", "set", "add", "subtract", "reset");
    private final String helpString = "/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>";

    public String func_71517_b() {
        return "nutrition";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return ChatCommand.func_175762_a((String[])args, Arrays.asList("get", "set", "add", "subtract", "reset", "reload"));
        }
        if (args.length == 2 && this.playerSubCommands.contains(args[0])) {
            return ChatCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            ArrayList<String> nutrientList = new ArrayList<String>();
            for (Nutrient nutrient : NutrientList.get()) {
                nutrientList.add(nutrient.name);
            }
            return ChatCommand.func_175762_a((String[])args, nutrientList);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = null;
        if (args.length > 0 && this.playerSubCommands.contains(args[0])) {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        }
        if (args.length == 0 || args[0].equals("help")) {
            this.commandHelp(sender);
        } else if (args[0].equals("get")) {
            this.commandGetNutrition((EntityPlayer)player, sender, args);
        } else if (args[0].equals("set")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.SET);
        } else if (args[0].equals("add")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.ADD);
        } else if (args[0].equals("subtract")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.SUBTRACT);
        } else if (args[0].equals("reset")) {
            this.commandResetNutrition((EntityPlayer)player, sender, args);
        } else if (args[0].equals("reload")) {
            this.commandReload(server, sender);
        }
    }

    private void commandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>"));
    }

    private void commandReload(MinecraftServer server, ICommandSender sender) {
        DataImporter.reload();
        DataImporter.updatePlayerCapabilitiesOnServer(server);
        sender.func_145747_a((ITextComponent)new TextComponentString("Nutrients and effects reloaded"));
    }

    private void commandGetNutrition(EntityPlayer player, ICommandSender sender, String[] args) {
        Nutrient nutrient = NutrientList.getByName(args[2]);
        if (nutrient != null) {
            Float nutrientValue = ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).get(nutrient);
            sender.func_145747_a((ITextComponent)new TextComponentString(nutrient.name + ": " + String.format("%.2f", nutrientValue) + "%"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("'" + args[2] + "' is not a valid nutrient."));
        }
    }

    private void commandSetNutrition(EntityPlayer player, ICommandSender sender, String[] args, actions action) {
        if (!this.validNumber(sender, args[3])) {
            return;
        }
        Nutrient nutrient = NutrientList.getByName(args[2]);
        if (nutrient != null) {
            if (action == actions.SET) {
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).set(nutrient, Float.valueOf(Float.parseFloat(args[3])));
            } else if (action == actions.ADD) {
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).add(nutrient, Float.parseFloat(args[3]));
            } else if (action == actions.SUBTRACT) {
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).subtract(nutrient, Float.parseFloat(args[3]));
            }
            Sync.serverRequest(player);
            sender.func_145747_a((ITextComponent)new TextComponentString(nutrient.name + " updated!"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("'" + args[2] + "' is not a valid nutrient."));
        }
    }

    private void commandResetNutrition(EntityPlayer player, ICommandSender sender, String[] args) {
        if (args.length == 3) {
            Nutrient nutrient = NutrientList.getByName(args[2]);
            if (nutrient != null) {
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).reset(nutrient);
                sender.func_145747_a((ITextComponent)new TextComponentString("Nutrient " + nutrient.name + " reset for " + player.func_70005_c_() + "!"));
            }
        } else if (args.length == 2) {
            ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).reset();
            sender.func_145747_a((ITextComponent)new TextComponentString("Nutrition reset for " + player.func_70005_c_() + "!"));
        }
        Sync.serverRequest(player);
    }

    private boolean validNumber(ICommandSender sender, String value) {
        if (!NumberUtils.isCreatable((String)value)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("'" + value + "' is not a number."));
            return false;
        }
        float newValue = Float.parseFloat(value);
        if (!(newValue >= 0.0f) || !(newValue <= 100.0f)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("'" + value + "' is not a number between 0 and 100."));
            return false;
        }
        return true;
    }

    private static enum actions {
        SET,
        ADD,
        SUBTRACT;

    }
}

