/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlEvent;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class GuiTimeline
extends GuiParent {
    protected double ticksPerPixel;
    protected double basePixelWidth;
    protected static final double maxZoom = 10.0;
    protected SmoothValue zoom = new SmoothValue(100L);
    protected SmoothValue scrollX = new SmoothValue(100L);
    protected SmoothValue scrollY = new SmoothValue(100L);
    protected int duration;
    public DisplayStyle timelineBackground = new ColoredDisplayStyle(255, 255, 255);
    public List<TimelineChannel> channels;
    public int sidebarWidth = 50;
    private int channelHeight = 10;
    private int timelineHeight = 11;
    protected KeyControl dragged = null;
    private KeyControl selected = null;
    private boolean movedSelected = false;
    private int movedStart = 0;
    private double lastZoom = 0.0;
    protected double sizeX;
    protected double maxScrollX;
    protected double sizeY;
    protected double maxScrollY;

    public GuiTimeline(String name, int x, int y, int width, int height, int duration, List<TimelineChannel> channels) {
        super(name, x, y, width, height);
        this.marginWidth = 0;
        this.channels = channels;
        int i = 0;
        for (TimelineChannel channel : channels) {
            channel.index = i;
            for (KeyControl control : channel.controls) {
                this.adjustKeyPositionY(control);
                this.addControl(control);
            }
            ++i;
        }
        this.setDuration(duration);
    }

    public GuiTimeline setSidebarWidth(int width) {
        this.sidebarWidth = width;
        return this;
    }

    public void adjustKeyPositionY(KeyControl control) {
        control.posY = this.timelineHeight + control.height / 2 + this.channelHeight * control.channel.index;
    }

    public void adjustKeyPositionX(KeyControl control) {
        control.posX = (int)((double)control.tick * this.getTickWidth()) - control.width / 2;
    }

    public void adjustKeysPositionX() {
        double tickWidth = this.getTickWidth();
        for (TimelineChannel channel : this.channels) {
            for (KeyControl control : channel.controls) {
                control.posX = (int)((double)control.tick * tickWidth) - control.width / 2;
            }
        }
    }

    @Override
    protected double getOffsetX() {
        return (double)this.sidebarWidth - this.scrollX.current();
    }

    @Override
    public void mouseMove(int x, int y, int button) {
        if (this.dragged != null) {
            int tick;
            if (!this.movedSelected) {
                boolean bl = this.movedSelected = Math.abs(this.movedStart - x) > 5;
            }
            if (this.movedSelected && this.dragged.channel.isSpaceFor(this.dragged, tick = Math.max(0, this.getTickAt(x)))) {
                this.dragged.tick = tick;
                this.adjustKeyPositionX(this.dragged);
            }
        }
        super.mouseMove(x, y, button);
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        int channel;
        this.selected = null;
        boolean result = super.mousePressed(x, y, button);
        for (GuiControl control : this.controls) {
            if (!(control instanceof KeyControl) || this.selected == control || !((KeyControl)control).selected) continue;
            ((KeyControl)control).selected = false;
            if (this.selected != null) continue;
            this.raiseEvent(new KeyDeselectedEvent((KeyControl)control));
        }
        if (!result && this.selected == null && button == 1 && (channel = this.getChannelAt(y)) != -1) {
            int tick = this.getTickAt(x);
            KeyControl control = this.channels.get(channel).addKey(tick, this.channels.get(channel).getValueAt(tick));
            this.adjustKeyPositionX(control);
            this.adjustKeyPositionY(control);
            this.addControl(control);
        }
        return result;
    }

    @Override
    protected void clickControl(GuiControl control, int x, int y, int button) {
        if (control instanceof KeyControl) {
            if (button == 1) {
                ((KeyControl)control).removeKey();
                this.selected = null;
                return;
            }
            this.dragged = (KeyControl)control;
            this.dragged.selected = true;
            this.selected = this.dragged;
            this.movedSelected = false;
            this.movedStart = x;
            this.raiseEvent(new KeySelectedEvent(this.selected));
        }
        super.clickControl(control, x, y, button);
    }

    @Override
    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        if (this.dragged != null) {
            this.dragged.channel.movedKey(this.dragged);
            this.dragged = null;
        }
    }

    public GuiTimeline setDuration(int duration) {
        int useableWidth = this.width - this.sidebarWidth - 2 - this.getContentOffset() * 2;
        this.ticksPerPixel = (double)duration / (double)useableWidth;
        this.basePixelWidth = 1.0 / this.ticksPerPixel;
        this.zoom.setStart(0.0);
        this.duration = duration;
        this.scrollX.setStart(0.0);
        this.scrollY.setStart(0.0);
        this.adjustKeysPositionX();
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (GuiScreen.func_146272_n()) {
            this.scrollX.set(MathHelper.func_151237_a((double)(this.scrollX.aimed() - (double)(scrolled * 10)), (double)0.0, (double)this.maxScrollX));
        } else if (GuiScreen.func_146271_m()) {
            this.scrollY.set(MathHelper.func_151237_a((double)(this.scrollY.aimed() + (double)scrolled), (double)0.0, (double)this.maxScrollY));
        } else {
            int focusedTick = Math.max(0, this.getTickAtAimed(x));
            this.zoom.set(MathHelper.func_151237_a((double)(this.zoom.aimed() + (double)scrolled * this.basePixelWidth * 2.0 * Math.max(this.basePixelWidth * 2.0, this.zoom.aimed()) / 10.0), (double)0.0, (double)10.0));
            int currentTick = Math.max(0, this.getTickAtAimed(x));
            double aimedTickWidth = this.getTickWidthAimed();
            double sizeX = aimedTickWidth * (double)this.duration;
            double maxScrollX = Math.max(0.0, sizeX - (double)(this.width - this.getContentOffset() * 2));
            this.scrollX.set(MathHelper.func_151237_a((double)(this.scrollX.aimed() + (double)(focusedTick - currentTick) * aimedTickWidth), (double)0.0, (double)maxScrollX));
        }
        return true;
    }

    public int getChannelAt(int y) {
        int channel = (y - this.timelineHeight) / this.channelHeight;
        if (channel < 0 || channel >= this.channels.size()) {
            return -1;
        }
        return channel;
    }

    public int getTickAt(int x) {
        if (x <= this.sidebarWidth) {
            return -1;
        }
        return MathHelper.func_76125_a((int)((int)(((double)(x - this.sidebarWidth) + this.getTickWidth() / 2.0 + this.scrollX.current()) / this.getTickWidth())), (int)0, (int)this.duration);
    }

    public int getTickAtAimed(int x) {
        if (x <= this.sidebarWidth) {
            return -1;
        }
        return MathHelper.func_76125_a((int)((int)(((double)(x - this.sidebarWidth) + this.getTickWidth() / 2.0 + this.scrollX.aimed()) / this.getTickWidthAimed())), (int)0, (int)this.duration);
    }

    protected double getTickWidth() {
        return this.basePixelWidth + this.zoom.current();
    }

    protected double getTickWidthAimed() {
        return this.basePixelWidth + this.zoom.aimed();
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        int i;
        this.zoom.tick();
        this.scrollX.tick();
        this.scrollY.tick();
        int usuableWidth = width - this.sidebarWidth;
        double tickWidth = this.getTickWidth();
        if (this.lastZoom != this.zoom.current()) {
            this.sizeX = tickWidth * (double)this.duration;
            this.maxScrollX = Math.max(0.0, this.sizeX - (double)usuableWidth);
            this.lastZoom = this.zoom.current();
            this.adjustKeysPositionX();
        }
        GlStateManager.func_179094_E();
        this.timelineBackground.renderStyle(helper, this.sidebarWidth, height);
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        for (int i2 = 0; i2 < this.channels.size(); ++i2) {
            font.func_78276_b(this.channels.get((int)i2).name, 1, 1, -16777216);
            GlStateManager.func_179109_b((float)0.0f, (float)this.channelHeight, (float)0.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)this.sidebarWidth, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        this.timelineBackground.renderStyle(helper, width, this.timelineHeight);
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        this.getStyle().getBorder(this).renderStyle(helper, width, 1);
        int ticks = (int)((double)usuableWidth / tickWidth);
        int area = 5;
        int halfArea = 5;
        int smallestStep = 0;
        while (Math.pow(area, smallestStep) * tickWidth < 3.0) {
            ++smallestStep;
        }
        smallestStep = (int)Math.pow(area, smallestStep);
        double stepWidth = tickWidth * (double)smallestStep;
        int stepOffset = (int)(this.scrollX.current() / stepWidth);
        int stamps = ticks / smallestStep;
        int begin = Math.max(0, stepOffset);
        int end = stepOffset + stamps + 1;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-this.scrollX.current() + (double)begin * stepWidth), (double)-2.0, (double)0.0);
        for (i = begin; i < end; ++i) {
            if (i % halfArea == 0) {
                this.getStyle().getBorder(this).renderStyle(helper, 1, 2);
                String text = "" + i * smallestStep;
                font.func_78276_b(text, 0 - font.func_78256_a(text) / 2, -8, -16777216);
            } else {
                this.getStyle().getBorder(this).renderStyle(helper, 1, 1);
            }
            GlStateManager.func_179137_b((double)stepWidth, (double)0.0, (double)0.0);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        for (i = 0; i < this.channels.size(); ++i) {
            GlStateManager.func_179109_b((float)0.0f, (float)this.channelHeight, (float)0.0f);
            this.getStyle().getBorder(this).renderStyle(helper, usuableWidth, 1);
        }
        GlStateManager.func_179121_F();
        if (this.maxScrollX > 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.scrollX.current() / this.sizeX * (double)usuableWidth), (double)(height - 2), (double)0.0);
            this.getStyle().getBorder(this).renderStyle(helper, (int)Math.max(1.0, (1.0 - this.maxScrollX / this.sizeX) * (double)usuableWidth), 1);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean hasMouseOverEffect() {
        return false;
    }

    @Override
    public List<String> getTooltip() {
        int channelId;
        Vec3d mouse = this.getMousePos();
        double x = mouse.field_72450_a + this.getOffsetX();
        ArrayList<String> lines = new ArrayList<String>();
        if (x > (double)this.sidebarWidth && x < (double)(this.width - this.getContentOffset() * 2) && (channelId = this.getChannelAt((int)mouse.field_72448_b)) >= 0) {
            TimelineChannel channel = this.channels.get(channelId);
            int tick = this.getTickAt((int)x);
            lines.add("" + tick + ". " + channel.name + ": " + Math.round(channel.getValueAt(tick) * 100.0) / 100L);
        }
        return lines;
    }

    public static class KeyDeselectedEvent
    extends GuiControlEvent {
        public KeyDeselectedEvent(KeyControl source) {
            super(source);
        }

        @Override
        public boolean isCancelable() {
            return false;
        }
    }

    public static class KeySelectedEvent
    extends GuiControlEvent {
        public KeySelectedEvent(KeyControl source) {
            super(source);
        }

        @Override
        public boolean isCancelable() {
            return false;
        }
    }

    public static class KeyControl
    extends GuiControl
    implements Comparable<KeyControl> {
        public TimelineChannel channel;
        public int tick;
        public boolean selected = false;
        public double value;

        public KeyControl(TimelineChannel channel, int index, int tick, double value) {
            super("" + index + ".", 0, 0, 0, 0);
            this.channel = channel;
            this.rotation = 45.0f;
            this.tick = tick;
            this.value = value;
        }

        @Override
        public DisplayStyle getBorderDisplay(DisplayStyle display) {
            if (this.selected) {
                return new ColoredDisplayStyle(40, 40, 140);
            }
            if (this.isMouseOver()) {
                return new ColoredDisplayStyle(20, 20, 20);
            }
            return super.getBorderDisplay(display);
        }

        @Override
        protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        }

        @Override
        public boolean mousePressed(int x, int y, int button) {
            return true;
        }

        @Override
        public List<String> getTooltip() {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("" + this.value);
            return tooltip;
        }

        public void removeKey() {
            this.channel.removeKey(this);
            this.getParent().removeControl(this);
        }

        @Override
        public int compareTo(KeyControl o) {
            return Integer.compare(this.tick, o.tick);
        }
    }

    public static class TimelineChannel {
        public int index;
        public String name;
        public List<KeyControl> controls = new ArrayList<KeyControl>();

        public TimelineChannel(String name) {
            this.name = name;
        }

        public TimelineChannel addKeys(PairList<Integer, Double> keys) {
            if (keys == null || keys.isEmpty()) {
                return this;
            }
            for (Pair pair : keys) {
                this.addKey((Integer)pair.key, (Double)pair.value);
            }
            return this;
        }

        public KeyControl addKey(int tick, double value) {
            KeyControl control = new KeyControl(this, this.controls.size(), tick, value);
            for (int i = 0; i < this.controls.size(); ++i) {
                KeyControl other = this.controls.get(i);
                if (other.tick == tick) {
                    return other;
                }
                if (other.tick <= tick) continue;
                this.controls.add(i, control);
                return control;
            }
            this.controls.add(control);
            return control;
        }

        public void removeKey(KeyControl control) {
            this.controls.remove(control);
        }

        public void movedKey(KeyControl control) {
            Collections.sort(this.controls);
        }

        public boolean isSpaceFor(KeyControl control, int tick) {
            for (int i = 0; i < this.controls.size(); ++i) {
                int otherTick = this.controls.get((int)i).tick;
                if (otherTick == tick) {
                    return false;
                }
                if (otherTick <= tick) continue;
                return true;
            }
            return true;
        }

        public double getValueAt(int tick) {
            if (this.controls.isEmpty()) {
                return 0.0;
            }
            int higher = this.controls.size();
            for (int i = 0; i < this.controls.size(); ++i) {
                int otherTick = this.controls.get((int)i).tick;
                if (otherTick == tick) {
                    return this.controls.get((int)i).value;
                }
                if (otherTick <= tick) continue;
                higher = i;
                break;
            }
            if (higher == 0 || higher == this.controls.size()) {
                return this.controls.get((int)(higher == 0 ? 0 : this.controls.size() - 1)).value;
            }
            KeyControl before = this.controls.get(higher - 1);
            KeyControl after = this.controls.get(higher);
            double percentage = (double)(tick - before.tick) / (double)(after.tick - before.tick);
            return Math.round(((after.value - before.value) * percentage + before.value) * 100.0) / 100L;
        }

        public PairList<Integer, Double> getPairs() {
            if (this.controls.isEmpty()) {
                return null;
            }
            PairList<Integer, Double> list = new PairList<Integer, Double>();
            for (KeyControl control : this.controls) {
                list.add((Integer)control.tick, control.value);
            }
            return list;
        }
    }
}

