/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import teamroots.emberroot.EmberRootZoo;
import teamroots.emberroot.config.ConfigManager;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.cat.EntityWitherCat;
import teamroots.emberroot.entity.cat.RenderWitherCat;
import teamroots.emberroot.entity.creeper.EntityConcussionCreeper;
import teamroots.emberroot.entity.creeper.RenderConcussionCreeper;
import teamroots.emberroot.entity.deer.EntityDeer;
import teamroots.emberroot.entity.deer.RenderDeer;
import teamroots.emberroot.entity.endermini.EntityEnderminy;
import teamroots.emberroot.entity.endermini.RenderEnderminy;
import teamroots.emberroot.entity.fairy.EntityFairy;
import teamroots.emberroot.entity.fairy.RenderFairy;
import teamroots.emberroot.entity.frozen.EntityFrozenKnight;
import teamroots.emberroot.entity.frozen.RenderFrozenKnight;
import teamroots.emberroot.entity.golem.DamageGolem;
import teamroots.emberroot.entity.golem.EntityAncientGolem;
import teamroots.emberroot.entity.golem.EntityGolemLaser;
import teamroots.emberroot.entity.golem.RenderAncientGolem;
import teamroots.emberroot.entity.golem.RenderEmberPacket;
import teamroots.emberroot.entity.hero.EntityFallenHero;
import teamroots.emberroot.entity.hero.RenderFallenHero;
import teamroots.emberroot.entity.knight.EntityFallenKnight;
import teamroots.emberroot.entity.knight.RenderFallenKnight;
import teamroots.emberroot.entity.mount.EntityFallenMount;
import teamroots.emberroot.entity.mount.RenderFallenMount;
import teamroots.emberroot.entity.owl.EntityOwl;
import teamroots.emberroot.entity.owl.EntityOwlEgg;
import teamroots.emberroot.entity.owl.RenderEntityOwlEgg;
import teamroots.emberroot.entity.owl.RenderOwl;
import teamroots.emberroot.entity.slime.EntityRainbowSlime;
import teamroots.emberroot.entity.slime.RenderWaterSlime;
import teamroots.emberroot.entity.slimedirt.EntityDireSlime;
import teamroots.emberroot.entity.slimedirt.RenderDireSlime;
import teamroots.emberroot.entity.sprite.EntitySprite;
import teamroots.emberroot.entity.sprite.RenderSprite;
import teamroots.emberroot.entity.spritegreater.EntityGreaterSprite;
import teamroots.emberroot.entity.spritegreater.EntitySpriteProjectile;
import teamroots.emberroot.entity.spritegreater.RenderGreaterSprite;
import teamroots.emberroot.entity.spritegreater.RenderSpriteProjectile;
import teamroots.emberroot.entity.spriteguardian.EntitySpriteGuardianBoss;
import teamroots.emberroot.entity.spriteguardian.RenderSpriteGuardian;
import teamroots.emberroot.entity.spriteling.EntitySpriteling;
import teamroots.emberroot.entity.spriteling.RenderSpriteling;
import teamroots.emberroot.entity.sprout.EntitySprout;
import teamroots.emberroot.entity.sprout.RenderSprout;
import teamroots.emberroot.entity.witch.EntityWitherWitch;
import teamroots.emberroot.entity.witch.RenderWitherWitch;
import teamroots.emberroot.entity.wolfdire.EntityDireWolf;
import teamroots.emberroot.entity.wolfdire.RenderDirewolf;
import teamroots.emberroot.entity.wolftimber.EntityTimberWolf;
import teamroots.emberroot.entity.wolftimber.RenderTimberWolf;
import teamroots.emberroot.util.Util;

public class RegistryManager {
    private List<SoundEvent> sounds = new ArrayList<SoundEvent>();
    private List<Item> items = new ArrayList<Item>();

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static void registerAll() {
        RegistryManager.registerDamageSources();
        RegistryManager.registerEntities();
        RegistryManager.registerSpawning();
    }

    public static void registerSpawning() {
        ArrayList<Biome> allBiomes = new ArrayList<Biome>();
        for (BiomeManager.BiomeEntry b : BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL)) {
            allBiomes.add(b.biome);
        }
        for (BiomeManager.BiomeEntry b : BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT)) {
            allBiomes.add(b.biome);
        }
        for (BiomeManager.BiomeEntry b : BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY)) {
            allBiomes.add(b.biome);
        }
        for (BiomeManager.BiomeEntry b : BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM)) {
            allBiomes.add(b.biome);
        }
        allBiomes.addAll(BiomeManager.oceanBiomes);
        for (ConfigSpawnEntity cfg : ConfigManager.entityConfigs) {
            EmberRootZoo.log("entity " + cfg.entityClass.getName() + System.lineSeparator() + cfg.toString());
            if (cfg.settings.weightedProb <= 0 || cfg.settings.max <= 0) {
                EmberRootZoo.log("entity " + cfg.entityClass.getName() + " Has been disabled from spawning fully");
                continue;
            }
            if (cfg.settings.useAllBiomes) {
                EntityRegistry.addSpawn(cfg.entityClass, (int)cfg.settings.weightedProb, (int)cfg.settings.min, (int)cfg.settings.max, (EnumCreatureType)cfg.typeOfCreature, (Biome[])allBiomes.toArray(new Biome[0]));
                continue;
            }
            EntityRegistry.addSpawn(cfg.entityClass, (int)cfg.settings.weightedProb, (int)cfg.settings.min, (int)cfg.settings.max, (EnumCreatureType)cfg.typeOfCreature, (Biome[])cfg.getBiomeFilter());
        }
    }

    public static void registerEntities() {
        int id = 0;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "deers"), EntityDeer.class, (String)"deers", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "deers"), (int)RegistryManager.intColor(159, 132, 88), (int)RegistryManager.intColor(94, 77, 51));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "sprouts"), EntitySprout.class, (String)"sprouts", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "sprouts"), (int)RegistryManager.intColor(136, 189, 33), (int)RegistryManager.intColor(165, 232, 42));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "fairies"), EntityFairy.class, (String)"fairies", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "fairies"), (int)RegistryManager.intColor(255, 208, 255), (int)RegistryManager.intColor(209, 255, 173));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rainbowslime"), EntityRainbowSlime.class, (String)"rainbowslime", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rainbowslime"), (int)RegistryManager.intColor(111, 208, 22), (int)RegistryManager.intColor(111, 255, 173));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "ember_projectile"), EntityGolemLaser.class, (String)"ember_projectile", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rainbow_golem"), EntityAncientGolem.class, (String)"rainbow_golem", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rainbow_golem"), (int)RegistryManager.intColor(48, 38, 35), (int)RegistryManager.intColor(79, 66, 61));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "hero"), EntityFallenHero.class, (String)"hero", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "hero"), (int)RegistryManager.intColor(159, 255, 222), (int)RegistryManager.intColor(222, 111, 51));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "creeper"), EntityConcussionCreeper.class, (String)"creeper", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "creeper"), (int)5701518, (int)16714274);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "owl"), EntityOwl.class, (String)"owl", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "owl"), (int)12679497, (int)16768454);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "slime"), EntityDireSlime.class, (String)"slime", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "slime"), (int)12158300, (int)5848361);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "EntityOwlEgg"), EntityOwlEgg.class, (String)"EntityOwlEgg", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "dire_wolf"), EntityDireWolf.class, (String)"dire_wolf", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "dire_wolf"), (int)0x606060, (int)0xA0A0A0);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "withercat"), EntityWitherCat.class, (String)"withercat", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "withercat"), (int)0x303030, (int)0xFFFFFF);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "witherwitch"), EntityWitherWitch.class, (String)"witherwitch", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "witherwitch"), (int)2511373, (int)9461315);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "enderminy"), EntityEnderminy.class, (String)"enderminy", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "enderminy"), (int)2581069, (int)0x212121);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "knight_fallen"), EntityFallenKnight.class, (String)"knight_fallen", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "knight_fallen"), (int)3562021, (int)0xA0A0A0);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "fallenmount"), EntityFallenMount.class, (String)"fallenmount", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "fallenmount"), (int)3562021, (int)0xA0A0A0);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "timberwolf"), EntityTimberWolf.class, (String)"timberwolf", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "timberwolf"), (int)7372944, (int)0xD3D3D3);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rootsonesprite"), EntitySprite.class, (String)"rootsonesprite", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rootsonesprite"), (int)Util.intColor(130, 255, 60), (int)Util.intColor(130, 255, 60));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rootsonespriteling"), EntitySpriteling.class, (String)"rootsonespriteling", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rootsonespriteling"), (int)Util.intColor(130, 255, 60), (int)Util.intColor(130, 255, 60));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rootsonespriteprojectile"), EntitySpriteProjectile.class, (String)"rootsonespriteprojectile", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rootsonespritegreater"), EntityGreaterSprite.class, (String)"rootsonespritegreater", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rootsonespritegreater"), (int)Util.intColor(130, 255, 60), (int)Util.intColor(130, 255, 60));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "rootsonespriteboss"), EntitySpriteGuardianBoss.class, (String)"rootsonespriteboss", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "rootsonespriteboss"), (int)Util.intColor(120, 245, 50), (int)Util.intColor(160, 255, 60));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("emberroot", "skeleton_frozen"), EntityFrozenKnight.class, (String)"skeleton_frozen", (int)id++, (Object)EmberRootZoo.instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("emberroot", "skeleton_frozen"), (int)RegistryManager.intColor(87, 58, 134), (int)0xA0A0A0);
    }

    public static void registerDamageSources() {
        EmberRootZoo.damage_ember = new DamageGolem();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerRendering(ModelRegistryEvent event) {
        for (Item item : this.items) {
            String name = "emberroot:" + item.func_77658_a().replaceAll("item.", "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityDeer.class, (IRenderFactory)new RenderDeer.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySprout.class, (IRenderFactory)new RenderSprout.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFairy.class, (IRenderFactory)new RenderFairy.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityRainbowSlime.class, (IRenderFactory)new RenderWaterSlime.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGolemLaser.class, (Render)new RenderEmberPacket(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityAncientGolem.class, (IRenderFactory)new RenderAncientGolem.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFallenHero.class, (IRenderFactory)new RenderFallenHero.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityConcussionCreeper.class, (IRenderFactory)new RenderConcussionCreeper.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDireSlime.class, (IRenderFactory)new RenderDireSlime.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityOwl.class, (IRenderFactory)new RenderOwl.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDireWolf.class, (IRenderFactory)new RenderDirewolf.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityWitherCat.class, (IRenderFactory)new RenderWitherCat.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityWitherWitch.class, (IRenderFactory)new RenderWitherWitch.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderminy.class, (IRenderFactory)new RenderEnderminy.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFallenKnight.class, (IRenderFactory)new RenderFallenKnight.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFallenMount.class, (IRenderFactory)new RenderFallenMount.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityOwlEgg.class, (IRenderFactory)new RenderEntityOwlEgg.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTimberWolf.class, (IRenderFactory)new RenderTimberWolf.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySprite.class, (IRenderFactory)new RenderSprite.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpriteling.class, (IRenderFactory)new RenderSpriteling.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGreaterSprite.class, (IRenderFactory)new RenderGreaterSprite.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpriteProjectile.class, (IRenderFactory)new RenderSpriteProjectile.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpriteGuardianBoss.class, (IRenderFactory)new RenderSpriteGuardian.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFrozenKnight.class, (IRenderFactory)new RenderFrozenKnight.Factory());
    }

    public SoundEvent registerSound(String name) {
        ResourceLocation res = new ResourceLocation("emberroot", name);
        SoundEvent sound = new SoundEvent(res);
        sound.setRegistryName(res);
        this.sounds.add(sound);
        return sound;
    }

    public void register(Item r) {
        this.items.add(r);
    }

    @SubscribeEvent
    public void onRegisterSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.sounds.toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.items.toArray(new Item[0]));
    }
}

