/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.oredict.OreDictionary;
import shadows.placebo.Placebo;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.interfaces.ITreeEnum;
import shadows.placebo.util.PlaceboUtil;
import shadows.plants2.block.BlockEnumBush;
import shadows.plants2.data.PlantConstants;
import shadows.plants2.data.enums.TheBigBookOfEnums;

public class BlockEnumSapling<E extends Enum<E>>
extends BlockEnumBush<E>
implements IGrowable,
IHasRecipe {
    public static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    protected final Collection<Block> soils;

    public BlockEnumSapling(String name, EnumPlantType type, SoundType s, float hard, float res, Class<E> clazz, int predicate, Block ... otherSoils) {
        super(name, type, clazz, predicate);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.property, (Comparable)this.types.get(0)).func_177226_a((IProperty)PlantConstants.INV, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(s);
        this.func_149711_c(hard);
        this.func_149752_b(res);
        this.soils = Arrays.asList(otherSoils);
    }

    public BlockEnumSapling(String name, SoundType s, float hard, float res, Class<E> clazz, int predicate, Block ... otherSoils) {
        this(name, EnumPlantType.Plains, s, hard, res, clazz, predicate, otherSoils);
    }

    public BlockEnumSapling(String name, EnumPlantType type, Class<E> clazz, int predicate) {
        this(name, type, SoundType.field_185850_c, 0.0f, 0.0f, clazz, predicate, new Block[0]);
    }

    public BlockEnumSapling(String name, Class<E> clazz, int predicate) {
        this(name, EnumPlantType.Plains, clazz, predicate);
    }

    public BlockEnumSapling(String name, EnumPlantType type, SoundType s, float hard, float res, E e, Block ... otherSoils) {
        super(name, type, e);
        this.func_149675_a(true);
        this.func_149672_a(s);
        this.func_149711_c(hard);
        this.func_149752_b(res);
        this.soils = Arrays.asList(otherSoils);
    }

    public BlockEnumSapling(String name, SoundType s, float hard, float res, E e, Block ... otherSoils) {
        this(name, EnumPlantType.Plains, s, hard, res, e, otherSoils);
    }

    public BlockEnumSapling(String name, EnumPlantType type, E e) {
        this(name, type, SoundType.field_185850_c, 0.0f, 0.0f, e, new Block[0]);
    }

    public BlockEnumSapling(String name, E e) {
        this(name, EnumPlantType.Plains, e);
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
    }

    @Override
    @Deprecated
    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && (soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || this.isValidSoil(world, pos, this.func_176223_P(), soil));
    }

    public boolean canPlaceBlockAt(IBlockState state, World world, BlockPos pos, EnumFacing side) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && (soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || this.isValidSoil(world, pos, state, soil));
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || this.isValidSoil(world, pos, state, soil);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.func_175671_l(pos.func_177984_a()) >= 6 && rand.nextInt(7) == 0) {
            this.func_176474_b(world, rand, pos, state);
        }
    }

    @Override
    public String func_149739_a() {
        return "tile.plants2.sapling";
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public void initModels(ModelRegistryEvent e) {
        if (this.property == null) {
            PlaceboUtil.sMRL((String)"saplings", (Block)this, (int)0, (String)("inventory=true,type=" + ((IPropertyEnum)this.value).func_176610_l()));
        } else {
            for (int i = 0; i < this.types.size(); ++i) {
                PlaceboUtil.sMRL((String)"saplings", (Block)this, (int)i, (String)("inventory=true," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l()));
            }
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "saplings", this.property == null ? ",type=" + ((IPropertyEnum)this.value).func_176610_l() : "");
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return world.field_73012_v.nextFloat() < 0.45f;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        WorldGenerator gen;
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        world.func_175698_g(pos);
        WorldGenerator worldGenerator = gen = this.property == null ? ((ITreeEnum)this.value).getTreeGen() : ((ITreeEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getTreeGen();
        if (!gen.func_180709_b(world, rand, pos)) {
            world.func_175656_a(pos, state);
        }
    }

    @Override
    protected void addStatesToList() {
    }

    @Override
    public boolean isValidSoil(World world, BlockPos pos, IBlockState state, IBlockState soil) {
        if (this.property != null && state.func_177229_b((IProperty)this.property) == TheBigBookOfEnums.Logs.BLACK_KAURI) {
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150330_I);
        }
        return this.soils.contains(soil.func_177230_c());
    }
}

