/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.Random;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumHarvestBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.enums.TheBigBookOfEnums;

public class BlockEnumNetherHarvest<E extends Enum<E>>
extends BlockEnumHarvestBush<E>
implements IHasRecipe {
    public BlockEnumNetherHarvest(String name, Class<E> enumClass, int predicate) {
        super(name, EnumPlantType.Nether, enumClass, predicate);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && state.func_177230_c() instanceof BlockNetherrack || super.func_176196_c(world, pos);
    }

    @Override
    public boolean isValidSoil(World world, BlockPos pos, IBlockState state, IBlockState soil) {
        return soil.func_177230_c() instanceof BlockNetherrack;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemShears) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        player.func_70015_d(10);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.func_176473_a(world, pos, state, false)) {
            boolean couldGrow;
            boolean bl = couldGrow = rand.nextInt(PlantConfig.netherHarvestChance) == 0;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)couldGrow)) {
                this.func_176474_b(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    @Override
    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return super.func_176473_a(world, pos, state, isClient) && PlantConfig.hardNether ? world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) : true;
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> event) {
        Plants2.HELPER.addSimpleShapeless((IForgeRegistryEntry)Items.field_151065_br, TheBigBookOfEnums.Generic.BLAZE_PETAL.get(), 3);
        Plants2.HELPER.addSimpleShapeless((IForgeRegistryEntry)Items.field_151064_bs, TheBigBookOfEnums.Generic.MAGMA_JELLY.get(), 3);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (this.harvesters.get() == null) {
            return;
        }
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextFloat() < 0.03f) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), 0.06, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), new int[0]);
        }
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }
}

