/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.dimstages;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="dimstages", name="Dimension Stages", version="2.0.23", dependencies="required-after:bookshelf;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class DimensionStages {
    public static final Map<Integer, String> DIMENSION_MAP = new HashMap<Integer, String>();
    public static final int MESSAGE_ID = 95505255;
    public static final LoggingHelper LOG = new LoggingHelper("dimstages");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDimChange(EntityTravelToDimensionEvent event) {
        String requiredStage = DIMENSION_MAP.get(event.getDimension());
        if (requiredStage != null && !requiredStage.isEmpty()) {
            if (event.getEntity() instanceof EntityPlayer) {
                DimensionStages.attemptEntryBlock(event.getEntity(), requiredStage, (Event)event);
            } else if (event.getEntity() instanceof EntityThrowable) {
                EntityThrowable throwable = (EntityThrowable)event.getEntity();
                DimensionStages.attemptEntryBlock((Entity)throwable.func_85052_h(), requiredStage, (Event)event);
            } else if (event.getEntity() instanceof EntityItem) {
                EntityItem item = (EntityItem)event.getEntity();
                if (item.func_145800_j() != null && !item.func_145800_j().isEmpty()) {
                    DimensionStages.attemptEntryBlock((Entity)event.getEntity().func_130014_f_().func_72924_a(item.func_145800_j()), requiredStage, (Event)event);
                }
            } else if (event.getEntity() instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)event.getEntity();
                DimensionStages.attemptEntryBlock(arrow.field_70250_c, requiredStage, (Event)event);
            }
        }
    }

    private static void attemptEntryBlock(Entity entity, String requiredStage, Event event) {
        if (entity instanceof EntityPlayer && !GameStageHelper.hasStage((EntityPlayer)((EntityPlayer)entity), (String)requiredStage)) {
            event.setCanceled(true);
        }
    }
}

