/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import shadows.ApotheosisCore;
import shadows.ApotheosisTransformer;
import shadows.CustomClassWriter;

public class DeadlyTransformer
implements ApotheosisTransformer.IApotheosisTransformer {
    @Override
    public boolean accepts(String name, String transformedName) {
        return "net.minecraft.world.gen.feature.WorldGenDungeons".equals(transformedName);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ApotheosisCore.enableDeadly) {
            return basicClass;
        }
        return DeadlyTransformer.transformDungeons(basicClass);
    }

    static byte[] transformDungeons(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming WorldGenDungeons...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode generate = ApotheosisCore.findMethod(classNode, ApotheosisCore::isGenerate);
        if (generate != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 2));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/deadly/asm/DeadlyHooks", "setDungeonMobSpawner", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V", false));
            int size = generate.instructions.size();
            AbstractInsnNode trueReturn = null;
            for (int i = size - 1; i >= 0; --i) {
                AbstractInsnNode n = generate.instructions.get(i);
                if (n.getOpcode() != 4) continue;
                trueReturn = n;
                break;
            }
            if (trueReturn != null) {
                generate.instructions.insertBefore(trueReturn, insn);
            } else {
                ApotheosisCore.LOG.error("Failed to find return node in WorldGenDungeons!");
            }
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed WorldGenDungeons");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming WorldGenDungeons");
        return basicClass;
    }
}

