/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionNameUtil {
    private static Map<Integer, String> nameCache = new HashMap<Integer, String>();

    public static String getUnlocalizedName(int dimension) {
        if (nameCache.isEmpty()) {
            DimensionNameUtil.recache();
        }
        return "dimension." + nameCache.getOrDefault(dimension, Integer.toString(dimension));
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLocalizedName(int dimension) {
        return I18n.func_135052_a((String)DimensionNameUtil.getUnlocalizedName(dimension), (Object[])new Object[0]);
    }

    private static void recache() {
        Integer[] ids = DimensionManager.getStaticDimensionIDs();
        if (ids.length == nameCache.size()) {
            return;
        }
        Integer[] integerArray = ids;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dimension = integerArray[i];
            if (nameCache.containsKey(dimension)) continue;
            WorldProvider provider = DimensionManager.createProviderFor((int)dimension);
            nameCache.put(dimension, provider.func_186058_p().func_186065_b());
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        DimensionNameUtil.recache();
    }
}

