/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile.base;

import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import modulardiversity.block.prop.EmberHatchSize;
import modulardiversity.components.requirements.RequirementEmber;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.power.DefaultEmberCapability;

public abstract class TileEntityEmber
extends TileColorableMachineComponent
implements MachineComponentTile,
ICraftingResourceHolder<RequirementEmber.ResourceToken> {
    public DefaultEmberCapability capability = new DefaultEmberCapability();
    private EmberHatchSize size;

    public TileEntityEmber() {
    }

    public TileEntityEmber(EmberHatchSize size) {
        this.size = size;
        this.capability.setEmberCapacity(size.getSize());
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.size = EmberHatchSize.values()[MathHelper.func_76125_a((int)compound.func_74762_e("size"), (int)0, (int)(EmberHatchSize.values().length - 1))];
        this.capability.readFromNBT(compound.func_74775_l("ember"));
        this.capability.setEmberCapacity(this.size.getSize());
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("size", this.size.ordinal());
        NBTTagCompound emberTag = new NBTTagCompound();
        this.capability.writeToNBT(emberTag);
        compound.func_74782_a("ember", (NBTBase)emberTag);
    }

    @Override
    public boolean consume(RequirementEmber.ResourceToken token, boolean doConsume) {
        double emberConsumed = this.capability.removeAmount(token.getEmber(), true);
        token.setEmber(token.getEmber() - emberConsumed);
        this.capability.removeAmount(emberConsumed, doConsume);
        return emberConsumed > 0.0;
    }

    @Override
    public boolean generate(RequirementEmber.ResourceToken token, boolean doGenerate) {
        double emberAdded = this.capability.addAmount(token.getEmber(), true);
        token.setEmber(token.getEmber() - emberAdded);
        this.capability.addAmount(emberAdded, doGenerate);
        return emberAdded > 0.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == EmbersCapabilities.EMBER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == EmbersCapabilities.EMBER_CAPABILITY ? this.capability : super.getCapability(capability, facing));
    }

    @Override
    public String getInputProblem(RequirementEmber.ResourceToken token) {
        return "craftcheck.ember.input";
    }

    @Override
    public String getOutputProblem(RequirementEmber.ResourceToken token) {
        return "craftcheck.ember.output";
    }
}

