/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile;

import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirChangeable;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementHotAir;
import modulardiversity.tile.base.TileEntityHotAir;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public class TileHotAirOutput
extends TileEntityHotAir
implements ITickable {
    private HotAirChangeable hotAir = new HotAir();
    private int coolDownClock;

    public TileHotAirOutput() {
        this.resetCoolDownClock();
    }

    @Override
    public boolean consume(RequirementHotAir.ResourceToken token, boolean doConsume) {
        return false;
    }

    @Override
    public boolean generate(RequirementHotAir.ResourceToken token, boolean doGenerate) {
        token.setRequiredTempMet();
        if (doGenerate) {
            this.setAirTemp(token.getTemp());
        }
        return true;
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponents.HotAirHatch(MachineComponent.IOType.OUTPUT){

            public ICraftingResourceHolder<RequirementHotAir.ResourceToken> getContainerProvider() {
                return TileHotAirOutput.this;
            }
        };
    }

    public int getOutAirTemperature() {
        return this.getAirTemp();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityHotAir.HOT_AIR && facing == EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityHotAir.HOT_AIR && facing == EnumFacing.UP) {
            return (T)this.hotAir;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        this.lowerTemp();
    }

    private void lowerTemp() {
        if (this.getAirTemp() <= 30) {
            return;
        }
        if (this.coolDownClock > 1) {
            --this.coolDownClock;
        } else {
            int newTemp = this.getAirTemp() - 1;
            this.setAirTemp(newTemp);
            this.hotAir.setTemperature(newTemp);
            this.resetCoolDownClock();
        }
    }

    private void resetCoolDownClock() {
        this.coolDownClock = 20;
    }

    private class HotAir
    extends HotAirChangeable {
    }
}

