/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.ingredients;

import modulardiversity.jei.IFakeIngredient;
import mysticalmechanics.api.IMechUnit;
import mysticalmechanics.api.MysticalMechanicsAPI;

public class MysticalMechanics
implements IFakeIngredient {
    private double requiredLevelMin;
    private double requiredLevelMax;
    private double outputLevel;
    private EnumType type;
    public double currentAngle;

    public MysticalMechanics(double requiredLevelMin, double requiredLevelMax) {
        this.requiredLevelMin = requiredLevelMin;
        this.requiredLevelMax = requiredLevelMax;
        this.type = EnumType.INPUT;
    }

    public MysticalMechanics(double outputLevel) {
        this.outputLevel = outputLevel;
        this.type = EnumType.OUTPUT;
    }

    public double getRequiredLevelMin() {
        return this.type == EnumType.INPUT ? this.requiredLevelMin : this.outputLevel;
    }

    public double getRequiredLevelMax() {
        return this.type == EnumType.INPUT ? this.requiredLevelMax : this.outputLevel;
    }

    @Override
    public String getDisplayName() {
        double max = this.getRequiredLevelMax();
        double min = this.getRequiredLevelMin();
        IMechUnit unit = MysticalMechanicsAPI.IMPL.getDefaultUnit();
        if (max == min) {
            return unit.format(min);
        }
        if (Double.isInfinite(max)) {
            return ">" + unit.format(min);
        }
        if (min <= 0.0) {
            return "<" + unit.format(max);
        }
        return unit.format(min) + " - " + unit.format(max);
    }

    @Override
    public String getUniqueID() {
        return "mysticalmechanics";
    }

    public static enum EnumType {
        INPUT,
        OUTPUT;

    }
}

