/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;
import modulardiversity.components.EnvironmentalComponent;
import modulardiversity.util.IResourceToken;

public abstract class RequirementEnvironmental<T, V extends IResourceToken>
extends ComponentRequirement.PerTick<T> {
    V checkToken;
    V outputToken;
    V perTickToken;
    boolean perTick;

    public RequirementEnvironmental(ComponentType componentType, MachineComponent.IOType actionType) {
        super(componentType, actionType);
    }

    public RequirementEnvironmental<T, V> setPerTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (this.perTick) {
            return true;
        }
        switch (this.getActionType()) {
            case INPUT: {
                this.consumeToken(component, context, this.outputToken, true);
                return this.outputToken.isEmpty();
            }
        }
        return false;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (this.perTick) {
            return true;
        }
        switch (this.getActionType()) {
            case OUTPUT: {
                this.generateToken(component, context, this.outputToken, true);
                return this.outputToken.isEmpty();
            }
        }
        return false;
    }

    protected abstract String getInputProblem(V var1);

    protected abstract String getOutputProblem(V var1);

    protected String getMissingInput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".input";
    }

    protected String getMissingOutput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".output";
    }

    protected String getMiscProblem() {
        return "craftcheck.failure.misc";
    }

    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> list) {
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = this.consumeToken(component, context, this.checkToken, false);
                if (!didConsume) {
                    return CraftCheck.failure((String)this.getInputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingInput());
            }
            case OUTPUT: {
                boolean didGenerate = this.generateToken(component, context, this.checkToken, false);
                if (!didGenerate) {
                    return CraftCheck.failure((String)this.getOutputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingOutput());
            }
        }
        return CraftCheck.failure((String)this.getMiscProblem());
    }

    public void startRequirementCheck(ResultChance resultChance, RecipeCraftingContext context) {
        this.checkToken = this.emitConsumptionToken(context);
        this.checkToken.applyModifiers(context, this.getActionType(), 1.0f);
        this.outputToken = this.emitConsumptionToken(context);
        this.outputToken.applyModifiers(context, this.getActionType(), 1.0f);
        EnvironmentalComponent.attach(this.getRequiredComponentType(), context);
    }

    public void endRequirementCheck() {
        this.checkToken = this.emitConsumptionToken(null);
        this.outputToken = this.emitConsumptionToken(null);
    }

    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.perTickToken.applyModifiers(context, this.getActionType(), durationMultiplier);
        EnvironmentalComponent.attach(this.getRequiredComponentType(), context);
    }

    public CraftCheck resetIOTick(RecipeCraftingContext context) {
        boolean enough = !this.perTick || this.perTickToken != null && this.perTickToken.isEmpty();
        this.perTickToken = this.emitConsumptionToken(context);
        if (enough) {
            return CraftCheck.success();
        }
        if (this.getActionType() == MachineComponent.IOType.INPUT) {
            return CraftCheck.failure((String)this.getMissingInput());
        }
        return CraftCheck.failure((String)this.getMissingOutput());
    }

    @Nonnull
    public CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (!this.perTick) {
            return CraftCheck.success();
        }
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = this.consumeToken(component, context, this.perTickToken, true);
                if (!didConsume) {
                    return CraftCheck.failure((String)this.getInputProblem(this.perTickToken));
                }
                if (this.perTickToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingInput());
            }
            case OUTPUT: {
                boolean didGenerate = this.generateToken(component, context, this.perTickToken, true);
                if (!didGenerate) {
                    return CraftCheck.failure((String)this.getOutputProblem(this.perTickToken));
                }
                if (this.perTickToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingOutput());
            }
        }
        return CraftCheck.failure((String)this.getMiscProblem());
    }

    protected abstract V emitConsumptionToken(RecipeCraftingContext var1);

    protected abstract boolean consumeToken(MachineComponent var1, RecipeCraftingContext var2, V var3, boolean var4);

    protected abstract boolean generateToken(MachineComponent var1, RecipeCraftingContext var2, V var3, boolean var4);
}

