/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentEmberWorld;
import modulardiversity.jei.ingredients.EmberWorld;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.util.EmberGenUtil;

public class RequirementEmberWorld
extends RequirementEnvironmental<EmberWorld, ResourceToken> {
    public float emberMin;
    public float emberMax;
    public float stabilityMin;
    public float stabilityMax;

    public RequirementEmberWorld(MachineComponent.IOType actionType, float emberMin, float emberMax, float stabilityMin, float stabilityMax) {
        super(ComponentType.Registry.getComponent((String)"mantle"), actionType);
        this.emberMin = emberMin;
        this.emberMax = emberMax;
        this.stabilityMin = stabilityMin;
        this.stabilityMax = stabilityMax;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        if (token.isEmberMatched() && !token.isStabilityMatched()) {
            return "craftcheck.ember_stability";
        }
        return "craftcheck.ember";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.emberMin, this.emberMax, this.stabilityMin, this.stabilityMax);
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            float density = EmberGenUtil.getEmberDensity((long)world.func_72905_C(), (int)pos.func_177958_n(), (int)pos.func_177952_p());
            float stability = EmberGenUtil.getEmberStability((long)world.func_72905_C(), (int)pos.func_177958_n(), (int)pos.func_177952_p());
            if (density >= this.emberMin && density <= this.emberMax) {
                token.setEmberMatched(true);
            }
            if (stability >= this.stabilityMin && stability <= this.stabilityMax) {
                token.setStabilityMatched(true);
            }
        }
        return token.isEmpty();
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return true;
    }

    public ComponentRequirement<EmberWorld> deepCopy() {
        return new RequirementEmberWorld(this.getActionType(), this.emberMin, this.emberMax, this.stabilityMin, this.stabilityMax);
    }

    public ComponentRequirement<EmberWorld> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementEmberWorld(this.getActionType(), Misc.applyModifiers(modifiers, "ember_min", this.getActionType(), this.emberMin, false), Misc.applyModifiers(modifiers, "ember_max", this.getActionType(), this.emberMax, false), Misc.applyModifiers(modifiers, "ember_stability_min", this.getActionType(), this.stabilityMin, false), Misc.applyModifiers(modifiers, "ember_stability_max", this.getActionType(), this.stabilityMax, false));
    }

    public ComponentRequirement.JEIComponent<EmberWorld> provideJEIComponent() {
        return new JEIComponentEmberWorld(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        public float emberMin;
        public float emberMax;
        public float stabilityMin;
        public float stabilityMax;
        boolean emberMatched;
        boolean stabilityMatched;

        public ResourceToken(float emberMin, float emberMax, float stabilityMin, float stabilityMax) {
            this.emberMin = emberMin;
            this.emberMax = emberMax;
            this.stabilityMin = stabilityMin;
            this.stabilityMax = stabilityMax;
        }

        public boolean isEmberMatched() {
            return this.emberMatched;
        }

        public void setEmberMatched(boolean emberMatched) {
            this.emberMatched = emberMatched;
        }

        public boolean isStabilityMatched() {
            return this.stabilityMatched;
        }

        public void setStabilityMatched(boolean stabilityMatched) {
            this.stabilityMatched = stabilityMatched;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.emberMin = Misc.applyModifiers(modifiers, "ember_min", ioType, this.emberMin, false);
            this.emberMax = Misc.applyModifiers(modifiers, "ember_max", ioType, this.emberMax, false);
            this.stabilityMin = Misc.applyModifiers(modifiers, "ember_stability_min", ioType, this.stabilityMin, false);
            this.stabilityMax = Misc.applyModifiers(modifiers, "ember_stability_max", ioType, this.stabilityMax, false);
        }

        @Override
        public boolean isEmpty() {
            return this.emberMatched && this.stabilityMatched;
        }
    }
}

