/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.lwjgl.opengl.OpenGLException;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.file.PNGExporter;
import xaero.map.file.RegionCacheInfo;
import xaero.map.file.RegionDetection;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapSaveLoad {
    private static final int currentSaveMajorVersion = 0;
    private static final int currentSaveVersion = 1;
    public static final int currentCacheSaveVersion = 2;
    private ArrayList<MapRegion> toSave = new ArrayList();
    private ArrayList<MapRegion> toLoad = new ArrayList();
    private ArrayList<MapRegion> toRequestToLoad;
    private ArrayList<MapRegion> prioritizedToRequestToLoad;
    private ArrayList<MapRegion> toCache = new ArrayList();
    private ArrayList<File> cacheToConvertFromTemp;
    private MapRegion nextToLoadByViewing;
    private boolean regionDetectionComplete;
    private ArrayList<Path> cacheFolders;
    private Path lastRealmOwnerPath;
    public boolean loadingFiles;
    private OverlayBuilder overlayBuilder;
    private PNGExporter pngExporter;

    public MapSaveLoad(OverlayManager overlayManager, PNGExporter pngExporter) {
        this.toRequestToLoad = new ArrayList();
        this.prioritizedToRequestToLoad = new ArrayList();
        this.cacheFolders = new ArrayList();
        this.cacheToConvertFromTemp = new ArrayList();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.pngExporter = pngExporter;
    }

    public void exportPNG() throws OpenGLException {
        MapProcessor.instance.pushProcessorPause();
        try {
            this.pngExporter.export();
        }
        catch (Exception e) {
            System.out.println("Failed to export PNG with exception!");
            MapProcessor.instance.setCrashedBy(e);
        }
        MapProcessor.instance.popProcessorPause();
    }

    private File getSecondaryFile(String extension, File realFile) {
        if (realFile == null) {
            return null;
        }
        String p = realFile.getPath();
        return new File(p.substring(0, p.lastIndexOf(".")) + extension);
    }

    public File getTempFile(File realFile) {
        return this.getSecondaryFile(".zip.temp", realFile);
    }

    public void updateCacheFolderList(Path subFolder) {
        Stream<Path> allFiles;
        try {
            allFiles = Files.list(subFolder);
        }
        catch (Exception e) {
            this.cacheFolders.clear();
            return;
        }
        Object[] filesArray = allFiles.toArray();
        allFiles.close();
        this.cacheFolders.clear();
        for (int i = 0; i < filesArray.length; ++i) {
            Path path = (Path)filesArray[i];
            if (!Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().startsWith("cache_") || path.getFileName().toString().split("_")[1].equals("" + MapProcessor.instance.getGlobalVersion())) continue;
            this.cacheFolders.add(path);
            if (!WorldMap.settings.debug) continue;
            System.out.println(path.toString());
        }
        this.cacheFolders.add(subFolder);
    }

    public Path getCacheFolder(Path subFolder) {
        if (subFolder != null) {
            return subFolder.resolve("cache_" + MapProcessor.instance.getGlobalVersion());
        }
        return null;
    }

    public File getCacheFile(RegionCacheInfo region, boolean checkOldFolders, boolean requestCache) throws IOException {
        Path subFolder = this.getSubFolder(region.getWorld());
        Path latestCacheFolder = this.getCacheFolder(subFolder);
        if (latestCacheFolder == null) {
            return null;
        }
        Files.createDirectories(latestCacheFolder, new FileAttribute[0]);
        Path cacheFile = latestCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
        if (!checkOldFolders || Files.exists(cacheFile, new LinkOption[0])) {
            return cacheFile.toFile();
        }
        if (requestCache) {
            region.setShouldCache(true, "cache file");
        }
        for (int i = 0; i < this.cacheFolders.size(); ++i) {
            Path oldCacheFolder = this.cacheFolders.get(i);
            Path oldCacheFile = oldCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
            if (!Files.exists(oldCacheFile, new LinkOption[0])) continue;
            return oldCacheFile.toFile();
        }
        return cacheFile.toFile();
    }

    public File getFile(MapRegion region) {
        Path testPath;
        File testFile;
        if (region.getWorld() == null) {
            return null;
        }
        if (region.getLoadedFromFile() != null) {
            return region.getLoadedFromFile();
        }
        String[] args = region.getWorld().split("_");
        boolean realms = region.getWorld().startsWith("Realms_");
        boolean multiplayer = region.getWorld().startsWith("Multiplayer_") || realms;
        Path mainFolder = this.getMainFolder(region.getWorld(), multiplayer);
        Path subFolder = this.getSubFolder(region.getWorld(), mainFolder, multiplayer);
        try {
            File subFolderFile = subFolder.toFile();
            if (!subFolderFile.exists()) {
                Path ownerPath;
                Files.createDirectories(subFolderFile.toPath(), new FileAttribute[0]);
                if (realms && WorldMap.events.getLatestRealm() != null && !(ownerPath = mainFolder.resolve(WorldMap.events.getLatestRealm().owner + ".owner")).equals(this.lastRealmOwnerPath)) {
                    if (!Files.exists(ownerPath, new LinkOption[0])) {
                        Files.createFile(ownerPath, new FileAttribute[0]);
                    }
                    this.lastRealmOwnerPath = ownerPath;
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File file = subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xaero").toFile();
        if (multiplayer && (testFile = (testPath = WorldMap.saveFolder.toPath().resolve(args[0] + "_" + args[1] + "_" + args[2])).resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xaero").toFile()).exists() && !file.exists()) {
            try {
                if (WorldMap.settings.debug) {
                    System.out.println("Moving: " + testFile.getPath());
                    System.out.println("To: " + file.getPath());
                }
                Files.move(testFile.toPath(), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File zipFile = subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile();
        if (file.exists() && !zipFile.exists()) {
            this.xaeroToZip(file);
        }
        return zipFile;
    }

    private Path getMainFolder(String world, boolean multiplayer) {
        if (world == null) {
            return null;
        }
        String[] args = world.split("_");
        return WorldMap.saveFolder.toPath().resolve(args[0] + "_" + args[1] + (multiplayer ? "_" + args[2] : ""));
    }

    private Path getSubFolder(String world, Path mainFolder, boolean multiplayer) {
        if (world == null) {
            return null;
        }
        String[] args = world.split("_");
        Path subFolder = mainFolder.resolve(multiplayer ? args[3] : "");
        return subFolder;
    }

    public Path getSubFolder(String world) {
        if (world == null) {
            return null;
        }
        boolean mp = world.startsWith("Multiplayer_") || world.startsWith("Realms_");
        return this.getSubFolder(world, this.getMainFolder(world, mp), mp);
    }

    private void xaeroToZip(File xaero) {
        File zipFile = xaero.toPath().getParent().resolve(xaero.getName().substring(0, xaero.getName().lastIndexOf(46)) + ".zip").toFile();
        try {
            int got;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(xaero), 1024);
            ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipEntry e = new ZipEntry("region.xaero");
            zipOutput.putNextEntry(e);
            byte[] bytes = new byte[1024];
            while ((got = in.read(bytes)) > 0) {
                zipOutput.write(bytes, 0, got);
            }
            zipOutput.closeEntry();
            zipOutput.flush();
            zipOutput.close();
            in.close();
            Files.deleteIfExists(xaero.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void detectRegions() {
        MapProcessor.instance.getDetectedRegions(MapProcessor.instance.getCurrentDimension()).clear();
        if (MapProcessor.instance.getCurrentWorldString() == null) {
            return;
        }
        Path worldFolder = this.getSubFolder(MapProcessor.instance.getCurrentWorldString());
        if (!worldFolder.toFile().exists()) {
            return;
        }
        int total = 0;
        try {
            Stream<Path> files = Files.list(worldFolder);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                String regionName;
                Path file = (Path)iter.next();
                if (Files.isDirectory(file, new LinkOption[0]) || !(regionName = file.getFileName().toString()).matches("-?\\d+_-?\\d+\\.(zip|xaero)")) continue;
                String[] args = regionName.substring(0, regionName.lastIndexOf(46)).split("_");
                int x = Integer.parseInt(args[0]);
                int z = Integer.parseInt(args[1]);
                RegionDetection regionDetection = new RegionDetection(MapProcessor.instance.getCurrentWorldString(), x, z);
                File cacheFile = this.getCacheFile(regionDetection, true, true);
                regionDetection.setCacheFile(cacheFile);
                MapProcessor.instance.addRegionDetection(regionDetection);
                ++total;
            }
            files.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (WorldMap.settings.debug) {
            System.out.println(String.format("%d regions detected!", total));
        }
    }

    public boolean saveRegion(MapRegion region) {
        try {
            File permFile = this.getFile(region);
            File file = this.getTempFile(permFile);
            if (file == null) {
                return true;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            DataOutputStream out = new DataOutputStream(zipOut);
            ZipEntry e = new ZipEntry("region.xaero");
            zipOut.putNextEntry(e);
            out.write(255);
            out.writeInt(1);
            boolean regionIsEmpty = true;
            for (int o = 0; o < 8; ++o) {
                for (int p = 0; p < 8; ++p) {
                    MapTileChunk chunk = region.getChunk(o, p);
                    if (chunk == null) continue;
                    if (chunk.includeInSave()) {
                        out.write(o << 4 | p);
                        boolean chunkIsEmpty = true;
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                MapTile tile = chunk.getTile(i, j);
                                if (tile != null && tile.isLoaded()) {
                                    chunkIsEmpty = false;
                                    for (int x = 0; x < 16; ++x) {
                                        MapBlock[] c = tile.getBlockColumn(x);
                                        for (int z = 0; z < 16; ++z) {
                                            this.savePixel(c[z], out);
                                        }
                                    }
                                    continue;
                                }
                                out.writeInt(-1);
                            }
                        }
                        if (chunkIsEmpty) continue;
                        regionIsEmpty = false;
                        continue;
                    }
                    region.setChunk(o, p, null);
                }
            }
            zipOut.closeEntry();
            out.close();
            if (regionIsEmpty) {
                Files.deleteIfExists(permFile.toPath());
                Files.deleteIfExists(file.toPath());
                if (WorldMap.settings.debug) {
                    System.out.println("Save cancelled because the region is empty: " + region + " " + region.getWorld());
                }
                return false;
            }
            Files.move(file.toPath(), permFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (WorldMap.settings.debug) {
                System.out.println("Region saved: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + MapProcessor.instance.getMapWriter().getUpdateCounter());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private Path getBackupFolder(Path filePath, int saveVersion, int backupVersion) {
        return filePath.getParent().resolve(saveVersion + "_backup_" + backupVersion);
    }

    public void backupFile(File file, int saveVersion) throws IOException {
        Path filePath = file.toPath();
        int backupVersion = 0;
        Path backupFolder = this.getBackupFolder(filePath, saveVersion, backupVersion);
        String backupName = filePath.getFileName().toString();
        Path backup = backupFolder.resolve(backupName);
        while (Files.exists(backup, new LinkOption[0])) {
            backupFolder = this.getBackupFolder(filePath, saveVersion, ++backupVersion);
            backup = backupFolder.resolve(backupName);
        }
        Files.createDirectories(backupFolder, new FileAttribute[0]);
        Files.move(file.toPath(), backup, new CopyOption[0]);
        System.out.println("File " + file.getPath() + " backed up to " + backupFolder.toFile().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadRegion(World world, MapRegion region) {
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            if (region.getLoadState() == 4) {
                region.deleteTexturesAndBuffers();
                region.setBeingWritten(false);
                region.setSaveExists(null);
            }
            return false;
        }
        int saveVersion = -1;
        boolean versionReached = false;
        int[] overlayBiomeBuffer = new int[3];
        try {
            MapRegion nextRegion = MapProcessor.instance.getMapRegion(region.getRegionX(), region.getRegionZ() + 1, false);
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
            DataInputStream in = new DataInputStream(zipIn);
            zipIn.getNextEntry();
            MapRegion mapRegion = region;
            synchronized (mapRegion) {
                region.setLoadState((byte)1);
            }
            region.setSaveExists(true);
            region.setLoadedFromFile(file);
            region.restoreBufferUpdateObjects();
            int firstByte = in.read();
            if (firstByte == 255) {
                saveVersion = in.readInt();
                if (1 < saveVersion) {
                    zipIn.closeEntry();
                    in.close();
                    System.out.println("Trying to load a newer region " + region.getRegionX() + "_" + region.getRegionZ() + " save using an older version of Xaero's World Map!");
                    this.backupFile(file, saveVersion);
                    return false;
                }
                firstByte = -1;
            }
            versionReached = true;
            int totalChunks = 0;
            while (true) {
                MapTileChunk nextChunk;
                int chunkCoords;
                int n = chunkCoords = firstByte == -1 ? in.read() : firstByte;
                if (chunkCoords == -1) break;
                firstByte = -1;
                int o = chunkCoords >> 4;
                int p = chunkCoords & 0xF;
                MapTileChunk chunk = region.getChunk(o, p);
                if (chunk == null) {
                    chunk = new MapTileChunk(region, region.getRegionX() * 8 + o, region.getRegionZ() * 8 + p);
                    region.setChunk(o, p, chunk);
                }
                chunk.setLoadState((byte)1);
                int totalTiles = 0;
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        Integer nextTile = in.readInt();
                        if (nextTile == -1) continue;
                        MapTile tile = MapProcessor.instance.getTilePool().get(MapProcessor.instance.getCurrentDimension(), chunk.getX() * 4 + i, chunk.getZ() * 4 + j);
                        chunk.setTile(i, j, tile);
                        for (int x = 0; x < 16; ++x) {
                            MapBlock[] c = tile.getBlockColumn(x);
                            for (int z = 0; z < 16; ++z) {
                                if (c[z] == null) {
                                    c[z] = new MapBlock();
                                } else {
                                    c[z].prepareForWriting();
                                }
                                this.loadPixel(nextTile, c[z], in, saveVersion, world, tile.getChunkX() * 16 + x, tile.getChunkZ() * 16 + z, overlayBiomeBuffer);
                                nextTile = null;
                            }
                        }
                        tile.setLoaded(true);
                        ++totalTiles;
                    }
                }
                if (totalTiles == 0) {
                    chunk = null;
                    region.setChunk(o, p, null);
                    continue;
                }
                region.pushWriterPause();
                ++totalChunks;
                chunk.updateBuffers(world);
                chunk.setLoadState((byte)2);
                region.popWriterPause();
                if (nextRegion == null || nextRegion.getVersion() <= 0 || region.getChunk(o, p) != chunk || p != 7 || (nextChunk = nextRegion.getChunk(o, 0)) == null || nextChunk.wasSuccessful()) continue;
                region.setWaitingForRegionBelow(true);
                nextRegion.setVersion(nextRegion.getVersion() - 1);
            }
            zipIn.closeEntry();
            in.close();
            if (totalChunks > 0) {
                if (WorldMap.settings.debug) {
                    System.out.println("Region loaded: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + saveVersion);
                }
                return true;
            }
            region.setSaveExists(null);
            Files.deleteIfExists(file.toPath());
            if (WorldMap.settings.debug) {
                System.out.println("Cancelled loading an empty region: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + saveVersion);
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("Region failed to load: " + region.getRegionX() + "_" + region.getRegionZ() + (versionReached ? " " + saveVersion : ""));
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beingLoaded(int regX, int regZ) {
        if (this.loadingFiles) {
            return true;
        }
        for (int i = 0; i < this.toLoad.size(); ++i) {
            ArrayList<MapRegion> arrayList = this.toLoad;
            synchronized (arrayList) {
                if (i >= this.toLoad.size()) {
                    return false;
                }
                MapRegion r = this.toLoad.get(i);
                if (r != null && r.getRegionX() == regX && r.getRegionZ() == regZ) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    public boolean beingSaved(String dim, int regX, int regZ) {
        for (int i = 0; i < this.toSave.size(); ++i) {
            MapRegion r = this.toSave.get(i);
            if (r == null || r.getDim() != dim || r.getRegionX() != regX || r.getRegionZ() != regZ) continue;
            return true;
        }
        return false;
    }

    public void requestLoad(MapRegion region, String reason) {
        this.requestLoad(region, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLoad(MapRegion region, String reason, boolean prioritize) {
        region.setReloadHasBeenRequested(true, reason);
        if (prioritize) {
            ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
            synchronized (arrayList) {
                this.prioritizedToRequestToLoad.remove(region);
                this.prioritizedToRequestToLoad.add(region);
            }
        }
        ArrayList<MapRegion> arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            if (!this.toRequestToLoad.contains(region)) {
                this.toRequestToLoad.add(region);
            }
        }
        if (WorldMap.settings.debug && reason != null) {
            System.out.println("Requesting load for: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllLoadRequests(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
        synchronized (arrayList) {
            this.prioritizedToRequestToLoad.remove(region);
        }
        arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            this.toRequestToLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadRequests() {
        ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
        synchronized (arrayList) {
            this.prioritizedToRequestToLoad.clear();
        }
        arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            this.toRequestToLoad.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToLoad() {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.clear();
        }
    }

    public int getSizeOfToLoad() {
        return this.toLoad.size();
    }

    public boolean saveExists(MapRegion region) {
        if (region.getSaveExists() != null) {
            return region.getSaveExists();
        }
        boolean result = true;
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            result = false;
        }
        region.setSaveExists(result);
        return result;
    }

    public void updateSave(MapRegion region) {
        if (region.getLoadState() == 2 && region.isBeingWritten() && System.currentTimeMillis() - region.getLastSaveTime() > 60000L && !this.beingSaved(region.getDim(), region.getRegionX(), region.getRegionZ())) {
            this.toSave.add(region);
            region.setSaveExists(true);
            region.setLastSaveTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(World world) throws Exception {
        MapRegion region;
        MapRegion region2;
        ArrayList<MapRegion> arrayList;
        int limit;
        for (limit = this.toRequestToLoad.size(); !this.toRequestToLoad.isEmpty() && limit > 0; --limit) {
            arrayList = this.toRequestToLoad;
            synchronized (arrayList) {
                if (this.toRequestToLoad.isEmpty()) {
                    break;
                }
                region2 = this.toRequestToLoad.remove(0);
            }
            if (region2.getLoadState() != 0 && region2.getLoadState() != 4 || this.beingLoaded(region2.getRegionX(), region2.getRegionZ())) continue;
            this.addToLoad(region2);
        }
        for (limit = this.prioritizedToRequestToLoad.size(); !this.prioritizedToRequestToLoad.isEmpty() && limit > 0; --limit) {
            arrayList = this.prioritizedToRequestToLoad;
            synchronized (arrayList) {
                if (this.prioritizedToRequestToLoad.isEmpty()) {
                    break;
                }
                region2 = this.prioritizedToRequestToLoad.remove(0);
            }
            if (region2.getLoadState() != 0 && region2.getLoadState() != 4) continue;
            arrayList = this.toLoad;
            synchronized (arrayList) {
                this.toLoad.remove(region2);
                this.toLoad.add(0, region2);
                continue;
            }
        }
        if (!this.toLoad.isEmpty()) {
            boolean loaded = false;
            arrayList = MapProcessor.instance.loadingSync;
            synchronized (arrayList) {
                this.loadingFiles = true;
                while (!(MapProcessor.instance.isWaitingForWorldUpdate() || loaded || this.toLoad.isEmpty())) {
                    boolean needsLoading;
                    ArrayList<MapRegion> arrayList2 = this.toLoad;
                    synchronized (arrayList2) {
                        if (this.toLoad.isEmpty()) {
                            break;
                        }
                        region = this.toLoad.get(0);
                    }
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        boolean bl = needsLoading = region.getLoadState() == 0 || region.getLoadState() == 4;
                        if (needsLoading) {
                            if (region.hasVersion() && region.getVersion() != MapProcessor.instance.getGlobalVersion() || !region.hasVersion() && region.getInitialVersion() != MapProcessor.instance.getGlobalVersion()) {
                                region.setShouldCache(true, "loading");
                            }
                            region.setVersion(MapProcessor.instance.getGlobalVersion());
                        }
                    }
                    if (needsLoading) {
                        boolean shouldLoadProperly;
                        if (region.getLoadState() == 0) {
                            this.requestCacheIfNeeded(region);
                        }
                        MapProcessor.instance.addToProcess(region);
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            boolean goingToPrepareCache = region.shouldCache() && (region.getLoadState() == 4 || region.getCacheFile() == null || !region.getCacheFile().exists());
                            boolean bl = shouldLoadProperly = region.isBeingWritten() || goingToPrepareCache;
                            if (!shouldLoadProperly) {
                                region.setLoadState((byte)3);
                            } else if (goingToPrepareCache) {
                                region.setRecacheHasBeenRequested(true, "loading");
                            }
                        }
                        if (shouldLoadProperly) {
                            loaded = this.loadRegion(world, region);
                            if (!loaded) {
                                region.setRecacheHasBeenRequested(false, "couldn't load");
                                if (region.getSaveExists() == null) {
                                    if (region.isBeingWritten()) {
                                        region.clean();
                                    } else {
                                        MapProcessor.instance.removeMapRegion(region);
                                        MapProcessor.instance.removeToProcess(region);
                                    }
                                }
                            }
                            this.removeToCache(region);
                            mapRegion2 = region;
                            synchronized (mapRegion2) {
                                if (region.getLoadState() <= 1) {
                                    region.setLoadState((byte)2);
                                }
                                region.setLastSaveTime(System.currentTimeMillis());
                            }
                            MapRegion prevRegion = MapProcessor.instance.getMapRegion(region.getRegionX(), region.getRegionZ() - 1, false);
                            if (prevRegion != null) {
                                prevRegion.setWaitingForRegionBelow(false);
                            }
                        } else {
                            if (region.recacheHasBeenRequested()) {
                                region.setRecacheHasBeenRequested(false, "loading");
                            }
                            if (WorldMap.settings.debug) {
                                System.out.println("Loaded from cache only for " + region);
                            }
                        }
                        region.setReloadHasBeenRequested(false, "loading");
                    }
                    this.removeToLoad(region);
                }
                this.loadingFiles = false;
            }
        }
        if (!this.toSave.isEmpty()) {
            boolean regionLoaded;
            MapRegion region3;
            region = region3 = this.toSave.get(0);
            synchronized (region) {
                regionLoaded = region3.getLoadState() == 2;
            }
            if (regionLoaded) {
                if (!region3.isBeingWritten()) {
                    throw new Exception("Saving a weird region: " + region3.getRegionX() + "_" + region3.getRegionZ());
                }
                region3.pushWriterPause();
                boolean notEmpty = this.saveRegion(region3);
                if (notEmpty) {
                    if (!region3.isAllCachePrepared()) {
                        region3.requestRefresh();
                    }
                    region3.setRecacheHasBeenRequested(true, "saving");
                    region3.setShouldCache(true, "saving");
                    region3.setBeingWritten(false);
                } else {
                    MapProcessor.instance.removeMapRegion(region3);
                    MapProcessor.instance.removeToProcess(region3);
                }
                region3.popWriterPause();
                if (region3.getWorld() == null || !region3.getWorld().equals(MapProcessor.instance.getCurrentWorldString())) {
                    region3.setRecacheHasBeenRequested(false, "clearing");
                    region3.cancelRefresh();
                    if (region3.getCacheFile() != null) {
                        Files.deleteIfExists(region3.getCacheFile().toPath());
                        if (WorldMap.settings.debug) {
                            System.out.println(String.format("Deleting cache for region %s because it IS outdated.", region3));
                        }
                    }
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            MapTileChunk c = region3.getChunk(i, j);
                            if (c == null) continue;
                            c.setLoadState((byte)3);
                            region3.setLoadState((byte)3);
                            c.clean();
                        }
                    }
                    region3.deleteGLBuffers();
                    region3.setLoadState((byte)4);
                    if (WorldMap.settings.debug) {
                        System.out.println("Cleared region! " + region3 + " " + region3.getWorld() + " " + region3.getRegionX() + "_" + region3.getRegionZ());
                    }
                }
            } else if (WorldMap.settings.debug) {
                System.out.println("Tried to save a weird region: " + region3 + " " + region3.getWorld() + " " + region3.getRegionX() + "_" + region3.getRegionZ() + " " + region3.getLoadState());
            }
            this.toSave.remove(region3);
        }
        while (!this.toCache.isEmpty()) {
            MapRegion region4 = this.removeToCache(0);
            region4.pushWriterPause();
            if (!region4.shouldCache() || !region4.isAllCachePrepared() || region4.getVersion() != MapProcessor.instance.getGlobalVersion()) {
                region4.setRecacheHasBeenRequested(false, "toCache cancel");
                region4.popWriterPause();
                continue;
            }
            File permFile = this.getCacheFile(region4, false, false);
            File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
            region4.saveCacheTextures(tempFile);
            this.cacheToConvertFromTemp.add(permFile);
            region4.setCacheFile(permFile);
            region4.setShouldCache(false, "");
            region4.setRecacheHasBeenRequested(false, "toCache normal");
            region4.popWriterPause();
            for (int i = 0; i < this.cacheFolders.size(); ++i) {
                Path oldCacheFolder = this.cacheFolders.get(i);
                Path oldCacheFile = oldCacheFolder.resolve(permFile.getName());
                Path oldPngFile = oldCacheFolder.resolve(permFile.getName().substring(0, permFile.getName().indexOf(46)) + ".png");
                Files.deleteIfExists(oldCacheFile);
                Files.deleteIfExists(oldPngFile);
                if (!oldCacheFolder.getFileName().toString().startsWith("cache_")) continue;
                Stream<Path> dirContent = Files.list(oldCacheFolder);
                if (!dirContent.iterator().hasNext()) {
                    Files.deleteIfExists(oldCacheFolder);
                    this.cacheFolders.remove(i--);
                }
                dirContent.close();
            }
        }
        for (int i = 0; i < this.cacheToConvertFromTemp.size(); ++i) {
            File permFile = this.cacheToConvertFromTemp.get(i);
            File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
            try {
                Files.move(tempFile.toPath(), permFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.cacheToConvertFromTemp.remove(i);
                --i;
                continue;
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    private void requestCacheIfNeeded(MapRegion region) throws IOException {
        if (!region.isBeingWritten()) {
            region.loadCacheTextures(4);
        }
    }

    private void savePixel(MapBlock pixel, DataOutputStream out) throws IOException {
        out.writeInt(pixel.getParametres());
        if (!pixel.isGrass()) {
            out.writeInt(pixel.getState());
        }
        if (pixel.getNumberOfOverlays() != 0) {
            out.write(pixel.getOverlays().size());
            for (int i = 0; i < pixel.getOverlays().size(); ++i) {
                this.saveOverlay(pixel.getOverlays().get(i), out);
            }
        }
        if (pixel.getColourType() == 3) {
            out.writeInt(pixel.getCustomColour());
        }
        if (pixel.getBiome() != -1) {
            out.write(pixel.getBiome());
        }
    }

    private void loadPixel(Integer next, MapBlock pixel, DataInputStream in, int saveVersion, World world, int globalX, int globalZ, int[] overlayBiomeBuffer) throws IOException {
        int parametres = next != null ? next.intValue() : in.readInt();
        if ((parametres & 1) != 0) {
            pixel.setState(in.readInt());
        } else {
            pixel.setState(Block.func_176210_f((IBlockState)Blocks.field_150349_c.func_176223_P()));
        }
        pixel.setHeightType((byte)(parametres >> 4 & 3));
        if ((parametres & 0x40) != 0) {
            pixel.setHeight(in.read());
        } else {
            pixel.setHeight(parametres >> 12 & 0xFF);
        }
        if ((parametres & 2) != 0) {
            int amount = in.read();
            this.overlayBuilder.startBuilding();
            for (int i = 0; i < amount; ++i) {
                this.loadOverlay(pixel, in, saveVersion, world, overlayBiomeBuffer);
            }
            this.overlayBuilder.finishBuilding(pixel);
        }
        pixel.setColourType((byte)(parametres >> 2 & 3));
        if (pixel.getColourType() == 3) {
            pixel.setCustomColour(in.readInt());
        }
        if (pixel.getColourType() != 0 && pixel.getColourType() != 3 || (parametres & 0x100000) != 0) {
            pixel.setBiome(in.read());
        }
        if (pixel.getColourType() == 3 && pixel.getCustomColour() == -1) {
            pixel.setColourType((byte)0);
        }
        pixel.setCaveBlock((parametres & 0x80) != 0);
        pixel.setLight((byte)(parametres >> 8 & 0xF));
        pixel.setGlowing(MapProcessor.instance.getMapWriter().isGlowing(Misc.getStateById(pixel.getState())));
    }

    private void saveOverlay(Overlay o, DataOutputStream out) throws IOException {
        out.writeInt(o.getParametres());
        if (!o.isWater()) {
            out.writeInt(o.getState());
        }
        if (o.getColourType() == 2) {
            out.writeInt(o.getCustomColour());
        }
        if (o.getOpacity() > 1) {
            out.writeInt(o.getOpacity());
        }
    }

    private void loadOverlay(MapBlock pixel, DataInputStream in, int saveVersion, World world, int[] overlayBiomeBuffer) throws IOException {
        int parametres = in.readInt();
        int state = (parametres & 1) != 0 ? in.readInt() : Block.func_176210_f((IBlockState)Blocks.field_150355_j.func_176223_P());
        int opacity = 1;
        if (saveVersion < 1 && (parametres & 2) != 0) {
            in.readInt();
        }
        overlayBiomeBuffer[2] = -1;
        overlayBiomeBuffer[1] = -1;
        overlayBiomeBuffer[0] = (byte)(parametres >> 8 & 3);
        if (overlayBiomeBuffer[0] == 2 || (parametres & 4) != 0) {
            overlayBiomeBuffer[0] = 2;
            overlayBiomeBuffer[2] = in.readInt();
            if (overlayBiomeBuffer[2] == -1) {
                overlayBiomeBuffer[0] = 0;
            }
        }
        if ((parametres & 8) != 0) {
            opacity = in.readInt();
        }
        byte light = (byte)(parametres >> 4 & 0xF);
        this.overlayBuilder.build(state, overlayBiomeBuffer, opacity, light, world);
    }

    public boolean isRegionDetectionComplete() {
        return this.regionDetectionComplete;
    }

    public void setRegionDetectionComplete(boolean regionDetectionComplete) {
        this.regionDetectionComplete = regionDetectionComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCache(MapRegion region) {
        if (!this.toCache.contains(region)) {
            ArrayList<MapRegion> arrayList = this.toCache;
            synchronized (arrayList) {
                this.toCache.add(region);
            }
            if (WorldMap.settings.debug) {
                System.out.println("Requesting cache! " + region.getRegionX() + "_" + region.getRegionZ());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion removeToCache(int index) {
        ArrayList<MapRegion> arrayList = this.toCache;
        synchronized (arrayList) {
            return this.toCache.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToCache(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toCache;
        synchronized (arrayList) {
            this.toCache.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToCache() {
        ArrayList<MapRegion> arrayList = this.toCache;
        synchronized (arrayList) {
            this.toCache.clear();
        }
    }

    public ArrayList<MapRegion> getToSave() {
        return this.toSave;
    }

    public MapRegion getNextToLoadByViewing() {
        return this.nextToLoadByViewing;
    }

    public void setNextToLoadByViewing(MapRegion nextToLoadByViewing) {
        this.nextToLoadByViewing = nextToLoadByViewing;
    }
}

