/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.client.util.ClientUtils;

public class FluidClientUtil {
    public static Map<Fluid, TextureAtlasSprite> stillTextures = Maps.newHashMap();

    public static void drawGuiLiquid(FluidStack fluid, int capacity, int x, int y, int width, int height, ResourceLocation ogTexture) {
        if (fluid != null && fluid.getFluid() != null) {
            int fluidHeight = (int)((float)height * ((float)fluid.amount / (float)capacity));
            FluidClientUtil.drawFluidStack(fluid, x, y + height - fluidHeight, width, fluidHeight);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ogTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void drawFluidStack(FluidStack fluid, int x, int y, int width, int height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite sprite = stillTextures.get(fluid.getFluid());
        if (sprite == null) {
            return;
        }
        int color = fluid.getFluid().getColor();
        float minU = sprite.func_94209_e();
        float maxU = sprite.func_94212_f();
        float minV = sprite.func_94206_g();
        float maxV = sprite.func_94210_h();
        float uDiff = maxU - minU;
        float vDiff = maxV - minV;
        int spriteWidth = sprite.func_94211_a();
        int spriteHeight = sprite.func_94216_b();
        if (spriteWidth <= 0 || spriteHeight <= 0) {
            return;
        }
        int iterationsY = height / spriteHeight;
        float leftOverY = height % spriteHeight;
        float leftOverNormY = leftOverY / (float)spriteHeight;
        int iterationsX = width / spriteWidth;
        float leftOverX = width % spriteWidth;
        float leftOverNormX = leftOverX / (float)spriteWidth;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (int i = 0; i < iterationsY; ++i) {
            for (int j = 0; j < iterationsX; ++j) {
                ClientUtils.drawTexturedColoredRect(x + spriteWidth * j, y + spriteHeight * i, spriteWidth, spriteHeight, minU, minV, maxU, maxV, color);
            }
            if (!(leftOverX > 0.0f)) continue;
            ClientUtils.drawTexturedColoredRect(x + spriteWidth * iterationsX, y + spriteHeight * i, leftOverX, spriteHeight, minU, minV, minU + uDiff * leftOverNormX, maxV, color);
        }
        if (leftOverY > 0.0f) {
            for (int j = 0; j < iterationsX; ++j) {
                ClientUtils.drawTexturedColoredRect(x + spriteWidth * j, y + spriteHeight * iterationsY, spriteWidth, leftOverY, minU, minV, maxU, minV + vDiff * leftOverNormY, color);
            }
            if (leftOverX > 0.0f) {
                ClientUtils.drawTexturedColoredRect(x + spriteWidth * iterationsX, y + spriteHeight * iterationsY, leftOverX, leftOverY, minU, minV, minU + uDiff * leftOverNormX, minV + vDiff * leftOverNormY, color);
            }
        }
    }

    public static void initTextures(TextureMap map) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid.getStill() == null) continue;
            String still = fluid.getStill().toString();
            TextureAtlasSprite sprite = map.getTextureExtry(still) != null ? map.getTextureExtry(still) : map.func_174942_a(fluid.getStill());
            stillTextures.put(fluid, sprite);
        }
    }
}

