/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.biome.BiomeInfo;
import cofh.cofhworld.data.biome.BiomeInfoSet;
import cofh.cofhworld.world.IConfigurableFeatureGenerator;
import cofh.cofhworld.world.distribution.Distribution;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class DistributionSequential
extends Distribution {
    private final IConfigurableFeatureGenerator[] features;

    public DistributionSequential(String name, List<IConfigurableFeatureGenerator> features, boolean regen) {
        super(name, regen);
        this.features = features.toArray(new IConfigurableFeatureGenerator[features.size()]);
    }

    @Override
    public Distribution setBiomeRestriction(IConfigurableFeatureGenerator.GenRestriction restriction) {
        super.setBiomeRestriction(restriction);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.setBiomeRestriction(restriction);
        }
        return this;
    }

    @Override
    public Distribution setDimensionRestriction(IConfigurableFeatureGenerator.GenRestriction restriction) {
        super.setDimensionRestriction(restriction);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.setDimensionRestriction(restriction);
        }
        return this;
    }

    @Override
    public Distribution addBiome(BiomeInfo biome) {
        super.addBiome(biome);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.addBiome(biome);
        }
        return this;
    }

    @Override
    public Distribution addBiomes(BiomeInfoSet biomes) {
        super.addBiomes(biomes);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.addBiomes(biomes);
        }
        return this;
    }

    @Override
    public Distribution setWithVillage(boolean inVillage) {
        super.setWithVillage(inVillage);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.setWithVillage(inVillage);
        }
        return this;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        boolean r = false;
        for (IConfigurableFeatureGenerator feature : this.features) {
            r |= feature.generateFeature(random, blockX, blockZ, world);
        }
        return false;
    }
}

