/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.block.MetalBlock;
import landmaster.plustic.fluids.FluidMolten;
import landmaster.plustic.util.Coord4D;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.block.BlockMolten;

public class Utils {
    private static final Map<String, Material> tinkerMaterials;
    private static final Map<String, ModContainer> tinkerMaterialRegisteredByMod;
    private static final MethodHandle harvestersHandle;

    public static void forceOut(String material) {
        if (tinkerMaterials.remove(material) != null) {
            PlusTiC.log.info(String.format("Forcing out material %s", material));
        }
    }

    public static void forceOutModsMaterial(String material, String ... anyOfTheseModids) {
        Optional.ofNullable(tinkerMaterialRegisteredByMod.get(material)).filter(cont -> ArrayUtils.contains((Object[])anyOfTheseModids, (Object)cont.getModId())).ifPresent(cont -> Utils.forceOut(material));
    }

    public static void displace(String displace) {
        Material displaced = tinkerMaterials.remove(displace);
        if (displaced != null) {
            tinkerMaterials.put(displace, displaced);
        }
    }

    public static boolean matchesOre(ItemStack is, String od) {
        return OreDictionary.doesOreNameExist((String)od) && !is.func_190926_b() && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)is), (int)OreDictionary.getOreID((String)od));
    }

    public static AxisAlignedBB AABBfromVecs(Vec3d v1, Vec3d v2) {
        return new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
    }

    public static RayTraceResult raytraceEntityPlayerLookWithPred(EntityPlayer player, float range, Predicate<? super Entity> pred) {
        Vec3d eye = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70676_i(1.0f);
        return Utils.raytraceEntityWithPred((Entity)player, eye, look, range, true, pred);
    }

    public static RayTraceResult raytraceEntityWithPred(Entity entity, Vec3d start, Vec3d look, double range, boolean ignoreCanBeCollidedWith, Predicate<? super Entity> pred) {
        Vec3d direction = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        Entity pointedEntity = null;
        Vec3d hit = null;
        AxisAlignedBB bb = entity.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72321_a(1.0, 1.0, 1.0);
        List entitiesInArea = entity.func_130014_f_().func_175674_a(entity, bb, Predicates.and(pred, (Predicate)EntitySelectors.field_180132_d));
        double range2 = range;
        for (Entity candidate : entitiesInArea) {
            double dist;
            if (!ignoreCanBeCollidedWith && !candidate.func_70067_L()) continue;
            double colBorder = candidate.func_70111_Y();
            AxisAlignedBB entityBB = candidate.func_174813_aQ().func_72321_a(colBorder, colBorder, colBorder);
            RayTraceResult movingobjectposition = entityBB.func_72327_a(start, direction);
            if (entityBB.func_72318_a(start)) {
                if (!(0.0 < range2) && range2 != 0.0) continue;
                pointedEntity = candidate;
                hit = movingobjectposition == null ? start : movingobjectposition.field_72307_f;
                range2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((dist = start.func_72438_d(movingobjectposition.field_72307_f)) < range2) && range2 != 0.0) continue;
            if (candidate == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (range2 != 0.0) continue;
                pointedEntity = candidate;
                hit = movingobjectposition.field_72307_f;
                continue;
            }
            pointedEntity = candidate;
            hit = movingobjectposition.field_72307_f;
            range2 = dist;
        }
        if (pointedEntity != null && range2 < range) {
            return new RayTraceResult(pointedEntity, hit);
        }
        return null;
    }

    public static void addModifierItem(Modifier modifier, String modid, String name) {
        Utils.addModifierItem(modifier, modid, name, 0);
    }

    public static void addModifierItem(Modifier modifier, String modid, String name, int meta) {
        Utils.addModifierItem(modifier, modid, name, meta, 1, 1);
    }

    public static void addModifierItem(Modifier modifier, String modid, String name, int meta, int needed, int matched) {
        if (modifier == null) {
            return;
        }
        ItemStack is = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)), 1, meta);
        modifier.addItem(is, needed, matched);
    }

    public static FluidMolten fluidMetal(String name, int color) {
        return Utils.registerFluid(new FluidMolten(name, color));
    }

    public static void initFluidMetal(Fluid fluid) {
        Utils.registerMoltenBlock(fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        PlusTiC.proxy.registerFluidModels(fluid);
    }

    public static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName("plustic." + fluid.getName().toLowerCase(Locale.US));
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    public static <T extends Block> T registerBlock(T block, String name) {
        block.func_149663_c("plustic." + name);
        block.setRegistryName("plustic." + name);
        Item ib = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ib);
        return block;
    }

    public static BlockMolten registerMoltenBlock(Fluid fluid) {
        BlockMolten block = new BlockMolten(fluid);
        return Utils.registerBlock(block, "molten_" + fluid.getName());
    }

    public static void setDispItem(Material mat, String modid, String name) {
        if (mat == null) {
            return;
        }
        mat.setRepresentativeItem((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)));
    }

    public static void setDispItem(Material mat, String modid, String name, int meta) {
        if (mat == null) {
            return;
        }
        ItemStack is = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)), 1, meta);
        mat.setRepresentativeItem(is);
    }

    public static void setDispItem(Material mat, String ore) {
        NonNullList ores = OreDictionary.getOres((String)ore);
        if (mat == null || ores.isEmpty()) {
            return;
        }
        mat.setRepresentativeItem((ItemStack)ores.get(0));
    }

    public static int gcd(int a, int b, int ... rest) {
        if (rest.length > 0) {
            int[] rest1 = new int[rest.length - 1];
            System.arraycopy(rest, 1, rest1, 0, rest1.length);
            return Utils.gcd(Utils.gcd(a, b, new int[0]), rest[0], rest1);
        }
        return b == 0 ? a : Utils.gcd(b, a % b, new int[0]);
    }

    public static void teleportPlayerTo(EntityPlayerMP player, Coord4D coord) {
        if (player.field_71093_bK != coord.dimensionId) {
            int id = player.field_71093_bK;
            WorldServer oldWorld = player.func_184102_h().func_71218_a(player.field_71093_bK);
            player.field_71093_bK = coord.dimensionId;
            WorldServer newWorld = player.func_184102_h().func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.func_130014_f_().func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            oldWorld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            if (player.func_70089_S()) {
                newWorld.func_72838_d((Entity)player);
                player.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
                newWorld.func_72866_a((Entity)player, false);
                player.func_70029_a((World)newWorld);
            }
            player.func_184102_h().func_184103_al().func_72375_a(player, oldWorld);
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(newWorld);
            player.func_184102_h().func_184103_al().func_72354_b(player, newWorld);
            player.func_184102_h().func_184103_al().func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, id, coord.dimensionId);
        } else {
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
        }
    }

    public static boolean canTeleportTo(EntityPlayer player, Coord4D dest) {
        if (dest == null) {
            return false;
        }
        for (int i = 1; i <= 2; ++i) {
            if (Optional.ofNullable(dest.add(0, i, 0).blockState()).map(bs -> bs.func_185890_d((IBlockAccess)dest.world(), dest.pos())).orElse(null) == null) continue;
            return false;
        }
        return true;
    }

    public static int extractEnergy(ItemStack is, int amount, boolean simulate) {
        if (is != null) {
            if (is.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return ((IEnergyStorage)is.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(amount, simulate);
            }
            if (Loader.isModLoaded((String)"tesla") && is.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null)) {
                return (int)((ITeslaProducer)is.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null)).takePower((long)amount, simulate);
            }
        }
        return 0;
    }

    public static ItemMatGroup registerMatGroup(String name) {
        ItemMatGroup img = new ItemMatGroup();
        img.nugget = (Item)new Item().func_77655_b(name + "nugget").setRegistryName(name + "nugget");
        img.nugget.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)img.nugget);
        OreDictionary.registerOre((String)("nugget" + StringUtils.capitalize((String)name)), (Item)img.nugget);
        PlusTiC.proxy.registerItemRenderer(img.nugget, 0, name + "nugget");
        img.ingot = (Item)new Item().func_77655_b(name + "ingot").setRegistryName(name + "ingot");
        img.ingot.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)img.ingot);
        OreDictionary.registerOre((String)("ingot" + StringUtils.capitalize((String)name)), (Item)img.ingot);
        PlusTiC.proxy.registerItemRenderer(img.ingot, 0, name + "ingot");
        img.block = new MetalBlock(name + "block");
        img.block.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
        ItemBlock bitem = new ItemBlock(img.block);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)img.block);
        ForgeRegistries.ITEMS.register(bitem.setRegistryName(img.block.getRegistryName()));
        OreDictionary.registerOre((String)("block" + StringUtils.capitalize((String)name)), (Block)img.block);
        PlusTiC.proxy.registerItemRenderer((Item)bitem, 0, name + "block");
        return img;
    }

    public static List<IModifier> getModifiers(ItemStack stack) {
        LinkedList modifiers = Lists.newLinkedList();
        NBTTagList modifiersTagList = TagUtil.getBaseModifiersTagList((ItemStack)stack);
        for (int i = 0; i < modifiersTagList.func_74745_c(); ++i) {
            IModifier modifier = TinkerRegistry.getModifier((String)modifiersTagList.func_150307_f(i));
            if (modifier == null) continue;
            modifiers.add(modifier);
        }
        return modifiers;
    }

    public static ThreadLocal<EntityPlayer> getHarvester() {
        try {
            return harvestersHandle.invokeExact();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        Field temp;
        try {
            temp = TinkerRegistry.class.getDeclaredField("materials");
            temp.setAccessible(true);
            tinkerMaterials = MethodHandles.lookup().unreflectGetter(temp).invokeExact();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            temp = TinkerRegistry.class.getDeclaredField("materialRegisteredByMod");
            temp.setAccessible(true);
            tinkerMaterialRegisteredByMod = MethodHandles.lookup().unreflectGetter(temp).invokeExact();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            Field field = Block.class.getDeclaredField("harvesters");
            field.setAccessible(true);
            harvestersHandle = MethodHandles.lookup().unreflectGetter(field);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class ItemMatGroup {
        public Item nugget;
        public Item ingot;
        public Block block;

        public ItemMatGroup() {
        }

        public ItemMatGroup(Item nugget, Item ingot, Block block) {
            this.nugget = nugget;
            this.ingot = ingot;
            this.block = block;
        }
    }
}

