/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.init;

import appeng.tile.misc.TileCharger;
import appeng.tile.networking.TileController;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.AE2WTLib;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.client.render.BaubleRenderDispatcher;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibItems;
import p455w0rd.ae2wtlib.init.LibNetworking;
import p455w0rd.ae2wtlib.init.LibRecipes;
import p455w0rd.ae2wtlib.integration.PwLib;
import p455w0rd.ae2wtlib.sync.packets.PacketConfigSync;
import p455w0rd.ae2wtlib.sync.packets.PacketSyncInfinityEnergy;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.capabilities.CapabilityChunkLoader;

@Mod.EventBusSubscriber(modid="ae2wtlib")
public class LibEvents {
    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        LibItems.register(event);
    }

    @SubscribeEvent
    public static void onRecipeRegistryReady(RegistryEvent.Register<IRecipe> event) {
        LibRecipes.register(event);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileController && LibConfig.WT_ENABLE_CONTROLLER_CHUNKLOADER) {
            TileController controller = (TileController)event.getObject();
            event.addCapability(new ResourceLocation("ae2wtlib", "chunkloader"), (ICapabilityProvider)new CapabilityChunkLoader.ProviderTE((TileEntity)controller));
        }
        if (WTApi.instance() != null && WTApi.instance().getConfig() != null && WTApi.instance().getConfig().areShadersEnabled() && event.getObject() instanceof TileCharger) {
            TileCharger charger = (TileCharger)event.getObject();
            event.addCapability(new ResourceLocation("ae2wtlib", "pw_light"), PwLib.getChargerProvider(charger));
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.PlaceEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && LibConfig.WT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).attachChunkLoader((Object)AE2WTLib.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && LibConfig.WT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).detachChunkLoader((Object)AE2WTLib.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        Random rand;
        int n;
        ItemStack stack = new ItemStack((Item)LibItems.BOOSTER_CARD);
        EntityItem drop = new EntityItem(event.getEntityLiving().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
        if (event.getEntity() instanceof EntityDragon && LibConfig.WT_BOOSTER_ENABLED && LibConfig.WT_DRAGON_DROPS_BOOSTER) {
            event.getDrops().add(drop);
        }
        if (event.getEntity() instanceof EntityWither && LibConfig.WT_BOOSTER_ENABLED && LibConfig.WT_WITHER_DROPS_BOOSTER && (n = (rand = event.getEntityLiving().func_130014_f_().field_73012_v).nextInt(100)) <= LibConfig.WT_BOOSTER_DROP_CHANCE) {
            event.getDrops().add(drop);
        }
        if (event.getEntity() instanceof EntityEnderman && LibConfig.WT_BOOSTER_ENABLED && LibConfig.WT_ENDERMAN_DROP_BOOSTERS && (n = (rand = event.getEntityLiving().func_130014_f_().field_73012_v).nextInt(100)) <= LibConfig.WT_ENDERMAN_BOOSTER_DROP_CHANCE) {
            event.getDrops().add(drop);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (LibGlobals.Mods.BAUBLES.isLoaded() && !BaubleRenderDispatcher.getRegistry().contains(event.getRenderer())) {
            event.getRenderer().func_177094_a((LayerRenderer)new BaubleRenderDispatcher(event.getRenderer()));
            BaubleRenderDispatcher.getRegistry().add(event.getRenderer());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("ae2wtlib", "gui/booster_slot"));
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            PacketConfigSync p = new PacketConfigSync(LibConfig.WT_MAX_POWER, LibConfig.WT_BOOSTER_ENABLED);
            LibNetworking.instance().sendTo(p, (EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.PlayerTickEvent e) {
        int invSize;
        EntityPlayer player = e.player;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        NonNullList playerInv = player.field_71071_by.field_70462_a;
        Set<Pair<Boolean, Pair<Integer, ItemStack>>> terminals = WTApi.instance().getAllWirelessTerminals(player);
        ItemStack wirelessTerm = ItemStack.field_190927_a;
        boolean isBauble = false;
        int wctSlot = -1;
        for (Pair<Boolean, Pair<Integer, ItemStack>> termPair : terminals) {
            if (!WTApi.instance().shouldConsumeBoosters((ItemStack)((Pair)termPair.getRight()).getRight())) continue;
            wirelessTerm = (ItemStack)((Pair)termPair.getRight()).getRight();
            isBauble = (Boolean)termPair.getLeft();
            wctSlot = (Integer)((Pair)termPair.getRight()).getLeft();
            break;
        }
        if ((invSize = playerInv.size()) <= 0) {
            return;
        }
        if (!LibConfig.USE_OLD_INFINTY_MECHANIC && !wirelessTerm.func_190926_b() && WTApi.instance().shouldConsumeBoosters(wirelessTerm)) {
            for (int currentSlot = 0; currentSlot < invSize; ++currentSlot) {
                ItemStack slotStack = (ItemStack)playerInv.get(currentSlot);
                if (slotStack.func_190926_b() || slotStack.func_77973_b() != LibItems.BOOSTER_CARD) continue;
                playerInv.set(currentSlot, (Object)WTApi.instance().addInfinityBoosters(wirelessTerm, slotStack));
                LibNetworking.instance().sendToDimension(new PacketSyncInfinityEnergy(WTApi.instance().getInfinityEnergy(wirelessTerm), player.func_110124_au(), isBauble, wctSlot), player.func_130014_f_().field_73011_w.getDimension());
            }
        }
    }
}

