/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.util.TransformUtils;
import morph.avaritia.Avaritia;
import morph.avaritia.api.ICosmicRenderItem;
import morph.avaritia.api.registration.IModelRegister;
import morph.avaritia.client.render.item.CosmicItemRender;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.AvaritiaTextures;
import morph.avaritia.init.ModItems;
import morph.avaritia.util.DamageSourceInfinitySword;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSwordInfinity
extends ItemSword
implements ICosmicRenderItem,
IModelRegister {
    private static final Item.ToolMaterial TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"INFINITY_SWORD", (int)32, (int)9999, (float)9999.0f, (float)-3.0f, (int)200);

    public ItemSwordInfinity() {
        super(TOOL_MATERIAL);
        this.func_77655_b("avaritia:infinity_sword");
        this.setRegistryName("infinity_sword");
        this.func_77637_a(Avaritia.tab);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase player) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (victim instanceof EntityPlayer) {
            EntityPlayer pvp = (EntityPlayer)victim;
            if (AvaritiaEventHandler.isInfinite(pvp)) {
                victim.func_70097_a(new DamageSourceInfinitySword((Entity)player).func_76348_h(), 4.0f);
                return true;
            }
            if (pvp.func_184586_b(EnumHand.MAIN_HAND) != null && pvp.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.infinity_sword && pvp.func_184587_cr()) {
                return true;
            }
        }
        victim.field_70718_bc = 60;
        victim.func_110142_aN().func_94547_a((DamageSource)new DamageSourceInfinitySword((Entity)player), victim.func_110143_aJ(), victim.func_110143_aJ());
        victim.func_70606_j(0.0f);
        victim.func_70645_a((DamageSource)new EntityDamageSource("infinity", (Entity)player));
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer victim = (EntityPlayer)entity;
            if (victim.field_71075_bZ.field_75098_d && !victim.field_70128_L && victim.func_110143_aJ() > 0.0f && !AvaritiaEventHandler.isInfinite(victim)) {
                victim.func_110142_aN().func_94547_a((DamageSource)new DamageSourceInfinitySword((Entity)player), victim.func_110143_aJ(), victim.func_110143_aJ());
                victim.func_70606_j(0.0f);
                victim.func_70645_a((DamageSource)new EntityDamageSource("infinity", (Entity)player));
                return true;
            }
        }
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getMaskTexture(ItemStack stack, EntityLivingBase player) {
        return AvaritiaTextures.INFINITY_SWORD_MASK;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaskOpacity(ItemStack stack, EntityLivingBase player) {
        return 1.0f;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation sword = new ModelResourceLocation("avaritia:tools", "type=infinity_sword");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_pickaxe, (ResourceLocation[])new ResourceLocation[]{sword});
        CosmicItemRender wrapped = new CosmicItemRender((IModelState)TransformUtils.DEFAULT_TOOL, modelRegistry -> (IBakedModel)modelRegistry.func_82594_a((Object)sword));
        ModelRegistryHelper.register((ModelResourceLocation)sword, (IBakedModel)wrapped);
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_sword, stack -> sword);
    }
}

