/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity;

import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class EntityChaosChicken
extends EntityEnderChicken {
    public EntityChaosChicken(World worldIn) {
        super(worldIn);
    }

    public EntityChaosChicken(World world, float rotation, float scale, BossInfoServer info) {
        super(world, rotation, scale, info);
    }

    @Override
    public boolean getIsChaos() {
        return true;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundIndex.chaos_hurt;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundIndex.chaos_death_sound;
    }

    @Override
    public float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public void func_70609_aI() {
        this.field_70737_aN = 0;
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                EntityLivingBase target = this.func_70638_az();
                this.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            }
            if (this.deathTicks == 1) {
                this.func_184185_a(SoundIndex.chaos_spinny, 0.3f * this.getScale(), 1.0f);
            }
            if (this.deathTicks == 40) {
                this.func_184185_a(SoundIndex.chaos_death, 0.3f * this.getScale(), 0.9f + this.func_70681_au().nextFloat() * 0.2f);
            }
            if (this.deathTicks >= 40 && this.deathTicks <= 150) {
                this.bossInfo.func_186735_a(((float)this.deathTicks - 40.0f) / 110.0f);
            }
            if (this.deathTicks >= 150 && this.deathTicks < 190) {
                this.bossInfo.func_186758_d(this.deathTicks % 10 >= 4);
            }
            if (this.deathTicks == 190) {
                this.bossInfo.func_186735_a(0.0f);
            }
            if (this.deathTicks >= 190 && this.deathTicks <= 198 && this.func_70681_au().nextFloat() < 0.5f) {
                this.func_184185_a(this.func_70681_au().nextFloat() < 0.5f ? SoundEvents.field_187539_bB : SoundEvents.field_187523_aM, 0.7f * this.getScale(), 0.7f + this.func_70681_au().nextFloat() * 0.6f);
            }
            if (this.deathTicks >= 190 && this.deathTicks <= 200 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int xpAmount = MightyEnderChicken.eventHandlerServer.hasKilled(true) ? 1500 : 30000;
                this.dropExperience(MathHelper.func_76141_d((float)((float)xpAmount * 0.1f)));
            }
            if (this.deathTicks == 200) {
                MightyEnderChicken.eventHandlerServer.setHasKilled(true);
                MightyEnderChicken.eventHandlerServer.chaosChickenMusic.put(new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0), 60);
                this.dropDeathItems(this.deathCause);
            }
        }
        if (this.deathTicks > 190) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.25, this.field_70163_u + (double)(this.field_70131_O * 0.5f) + this.field_70146_Z.nextGaussian() * (double)this.field_70131_O * 0.3, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.25, 0.0, 0.0, 0.0, new int[0]);
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.partHead.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.partHead.field_70130_N * 0.25, this.partHead.field_70163_u + (double)(this.partHead.field_70131_O * 0.5f) + this.field_70146_Z.nextGaussian() * (double)this.partHead.field_70131_O * 0.3, this.partHead.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.partHead.field_70130_N * 0.25, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.deathTicks == 200) {
            this.func_70106_y();
        }
    }

    @Override
    public void dropExperience(int amount) {
        while (amount > 0) {
            int i = EntityXPOrb.func_70527_a((int)amount);
            amount -= i;
            EntityXPOrb orb = new EntityXPOrb(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.1f, this.field_70163_u + (double)(this.getScale() / 2.0f) + this.field_70146_Z.nextGaussian() * (double)0.1f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.1f, i);
            orb.field_70181_x = (double)(this.getScale() * 0.04f) * this.field_70146_Z.nextGaussian();
            orb.field_70159_w = (double)(this.getScale() * 0.04f) * this.field_70146_Z.nextGaussian();
            orb.field_70179_y = (double)(this.getScale() * 0.04f) * this.field_70146_Z.nextGaussian();
            this.field_70170_p.func_72838_d((Entity)orb);
        }
    }
}

