/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.events;

import com.m4thg33k.tombmanygraves.ModConfigs;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.tiles.TileGrave;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderEvents {
    public Minecraft mc = Minecraft.func_71410_x();
    private static final int FORCE = ModConfigs.NAME_FORCE;
    private static final int YIELD = ModConfigs.NAME_YIELD;

    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        TileEntity tile;
        WorldClient world;
        IBlockState state;
        if (!ModConfigs.DISPLAY_GRAVE_NAME) {
            return;
        }
        RayTraceResult trace = event.getTarget();
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && (state = (world = this.mc.field_71441_e).func_180495_p(trace.func_178782_a())).func_177230_c() == ModBlocks.blockGrave && (tile = world.func_175625_s(trace.func_178782_a())) != null && tile instanceof TileGrave) {
            String name = ((TileGrave)tile).getPlayerName();
            boolean giveGraveItemsPriority = ((TileGrave)tile).areGraveItemsForced();
            this.renderPlayerName(trace.func_178782_a(), event.getPartialTicks(), name, giveGraveItemsPriority);
        }
    }

    private void renderPlayerName(BlockPos pos, float partialTicks, String name, boolean giveGravePriority) {
        if (name.length() > 0) {
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.renderPlayerName(name, (EntityPlayer)this.mc.field_71439_g, pos, partialTicks, giveGravePriority);
        }
    }

    private void renderPlayerName(String name, EntityPlayer player, BlockPos pos, float partialTicks, boolean giveGravePriority) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        float angleH = player.field_70759_as;
        float angleV = 0.0f;
        this.renderLabel(name, x - dx, y - dy, z - dz, angleH, angleV, giveGravePriority);
        this.renderLabel(giveGravePriority ? "force" : "yield", x - dx, y - dy - 0.25, z - dz, angleH, angleV, giveGravePriority);
        if (ModConfigs.GRAVE_POS_ENABLED) {
            this.renderLabel(this.posToString(pos), x - dx, y - dy - 0.5, z - dz, angleH, angleV, giveGravePriority);
        }
    }

    private String posToString(BlockPos pos) {
        return "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")";
    }

    protected void renderLabel(String name, double x, double y, double z, float angleH, float angleV, boolean giveGravePriority) {
        FontRenderer fontRenderer = this.mc.field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleH), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleV), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        int strLenHalved = fontRenderer.func_78256_a(name) / 2;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)(-strLenHalved - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(-strLenHalved - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(strLenHalved + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(strLenHalved + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontRenderer.func_78276_b(name, -strLenHalved, 0, giveGravePriority ? FORCE : YIELD);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

