/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.events;

import com.m4thg33k.tombmanygraves.ModConfigs;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.invman.DeathInventoryHandler;
import com.m4thg33k.tombmanygraves.invman.InventoryHolder;
import com.m4thg33k.tombmanygraves.items.ModItems;
import com.m4thg33k.tombmanygraves.tiles.TileGrave;
import com.m4thg33k.tombmanygraves.util.ChatHelper;
import com.m4thg33k.tombmanygraves.util.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommonEvents {
    private HashMap<UUID, InventoryHolder> invs = new HashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.isCanceled() || e.getEntityLiving().func_130014_f_().field_72995_K || !(e.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntityLiving();
        this.invs.put(player.func_110124_au(), null);
        InventoryHolder inventoryHolder = new InventoryHolder();
        inventoryHolder.grabPlayerData(player);
        if (inventoryHolder.isInventoryEmpty()) {
            if (ModConfigs.ENABLE_CHAT_MESSAGE_ON_DEATH) {
                ChatHelper.sayMessage(player, "But there were no valid items for the grave!");
            }
            if (ModConfigs.PRINT_DEATH_LOG) {
                LogHelper.info(player.func_70005_c_() + " died without valid items for a grave.");
            }
            DeathInventoryHandler.clearLatest(player);
        } else {
            this.invs.put(player.func_110124_au(), inventoryHolder);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrop(PlayerDropsEvent e) {
        ItemStack newList;
        if (e.isCanceled()) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        if (ModConfigs.PRINT_DEATH_LOG) {
            this.handleDeathLog(player);
        }
        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            InventoryHolder inventoryHolder = this.invs.get(player.func_110124_au());
            inventoryHolder.ensure(e.getDrops());
            if (!inventoryHolder.isInventoryEmpty()) {
                this.handleGraveLogic(player);
            }
            if (inventoryHolder != null) {
                ArrayList<EntityItem> removals = new ArrayList<EntityItem>();
                List<ItemStack> dropList = inventoryHolder.getAllItems();
                block0: for (EntityItem itm : e.getDrops()) {
                    for (ItemStack is : dropList) {
                        if (!ItemStack.func_77989_b((ItemStack)itm.func_92059_d(), (ItemStack)is)) continue;
                        dropList.remove(is);
                        removals.add(itm);
                        continue block0;
                    }
                }
                for (EntityItem removal : removals) {
                    e.getDrops().remove(removal);
                }
            }
        }
        if ((newList = DeathInventoryHandler.getDeathListFromFile(player.func_70005_c_(), "latest")) != null) {
            InventoryPlayer inv = player.field_71071_by;
            for (int i = 0; i < inv.field_70462_a.size(); ++i) {
                if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
                inv.field_70462_a.set(i, (Object)newList.func_77946_l());
                break;
            }
        }
        for (EntityItem entityItem : e.getDrops()) {
            if (entityItem.func_92059_d().func_77973_b() != Item.func_150898_a((Block)ModBlocks.blockGrave) && entityItem.func_92059_d().func_77973_b() != ModItems.itemDeathList) continue;
            entityItem.func_70106_y();
        }
    }

    private void handleDeathLog(EntityPlayer player) {
        BlockPos pos = player.func_180425_c();
        LogHelper.info(player.func_70005_c_() + " died in dimension " + player.field_71093_bK + " at " + pos.toString() + "." + (ModConfigs.ENABLE_GRAVES ? " Their grave may be near!" : ""));
    }

    private void handleGraveLogic(EntityPlayer player) {
        boolean wroteFile;
        InventoryHolder inventoryHolder;
        if (ModConfigs.ENABLE_CHAT_MESSAGE_ON_DEATH) {
            ChatHelper.sayMessage(player, "Place of death: " + player.func_180425_c().toString());
        }
        if ((inventoryHolder = this.invs.get(player.func_110124_au())) == null) {
            return;
        }
        if (ModConfigs.ENABLE_GRAVES) {
            IBlockState state = ModBlocks.blockGrave.func_176223_P();
            BlockPos posToPlace = new BlockPos(0, -1, 0);
            if (ModConfigs.ASCEND_LIQUID) {
                posToPlace = this.findValidGraveLocation(player.field_70170_p, this.ascendFromFluid(player.field_70170_p, player.func_180425_c()));
            }
            if (posToPlace.func_177956_o() == -1) {
                posToPlace = this.findValidGraveLocation(player.field_70170_p, player.func_180425_c());
            }
            if (posToPlace.func_177956_o() == -1) {
                ChatHelper.sayMessage(player, "A suitable location for the grave wasn't found.");
                inventoryHolder.insertInventory(player);
            } else {
                player.field_70170_p.func_175656_a(posToPlace, state);
                TileEntity tile = player.field_70170_p.func_175625_s(posToPlace);
                if (tile != null && tile instanceof TileGrave) {
                    TileGrave grave = (TileGrave)tile;
                    grave.getPlayerData(player);
                    IBlockState camoBlock = this.getBlockStateBelow(player.field_70170_p, posToPlace);
                    if (camoBlock.func_185904_a() == Material.field_151579_a) {
                        camoBlock = ModBlocks.blockGrave.func_176223_P();
                    } else if (camoBlock.func_185904_a() == Material.field_151577_b) {
                        camoBlock = Blocks.field_150346_d.func_176223_P();
                    }
                    grave.setCamoState(camoBlock);
                    inventoryHolder.setPosition(posToPlace);
                    grave.setSavedInventory(inventoryHolder);
                } else {
                    LogHelper.info("Error! Grave could not be found after placement! " + posToPlace.toString());
                    ChatHelper.sayMessage(player, "ERROR! Grave formed incorrectly! Report to M4thG33k!");
                }
            }
        } else {
            inventoryHolder.insertInventory(player);
        }
        if (ModConfigs.ALLOW_INVENTORY_SAVES && !(wroteFile = DeathInventoryHandler.writeInventoryFile(inventoryHolder))) {
            LogHelper.error("An error occurred when writing the inventory file for " + inventoryHolder.getPlayerName() + ".");
        }
    }

    private BlockPos findValidGraveLocation(World world, BlockPos pos) {
        BlockPos toReturn = new BlockPos(-1, -1, -1);
        BlockPos toCheck = pos.func_177982_a(0, 0, 0);
        if (toCheck.func_177956_o() <= 0) {
            toCheck = toCheck.func_177982_a(0, MathHelper.func_76130_a((int)toCheck.func_177956_o()) + (ModConfigs.START_VOID_SEARCH_AT_ONE ? 1 : ModConfigs.MAX_GRAVE_SEARCH_RADIUS), 0);
        }
        for (int r = 0; r <= ModConfigs.MAX_GRAVE_SEARCH_RADIUS; ++r) {
            toReturn = this.checkLevel(world, toCheck, r, false);
            if (toReturn.func_177956_o() == -1) continue;
            return toReturn;
        }
        return toReturn;
    }

    private BlockPos ascendFromFluid(World world, BlockPos pos) {
        BlockPos toCheck = pos.func_177982_a(0, 0, 0);
        int height = 0;
        while (pos.func_177956_o() + height < world.func_72940_L() - ModConfigs.MAX_GRAVE_SEARCH_RADIUS && !this.isValidLocation(world, toCheck, true)) {
            toCheck = this.checkLevel(world, pos.func_177982_a(0, height, 0), 1, true);
            ++height;
        }
        return toCheck;
    }

    private BlockPos checkLevel(World world, BlockPos pos, int radius, boolean ignoreFluidConfigs) {
        if (radius == 0 && this.isValidLocation(world, pos, ignoreFluidConfigs)) {
            return pos;
        }
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = radius; k >= -radius; --k) {
                    if (MathHelper.func_76130_a((int)i) != radius && MathHelper.func_76130_a((int)j) != radius && MathHelper.func_76130_a((int)k) != radius || !this.isValidLocation(world, pos.func_177982_a(i, j, k), ignoreFluidConfigs)) continue;
                    return pos.func_177982_a(i, j, k);
                }
            }
        }
        return new BlockPos(-1, -1, -1);
    }

    private boolean isValidLocation(World world, BlockPos pos, boolean ignoreFluidConfigs) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72940_L()) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return true;
        }
        Block theBlock = world.func_180495_p(pos).func_177230_c();
        if (ModConfigs.REPLACE_PLANTS && theBlock instanceof IPlantable) {
            return true;
        }
        return !ignoreFluidConfigs && (ModConfigs.REPLACE_STILL_LAVA && theBlock == Blocks.field_150353_l || ModConfigs.REPLACE_FLOWING_LAVA && theBlock == Blocks.field_150356_k || ModConfigs.REPLACE_STILL_WATER && theBlock == Blocks.field_150355_j || ModConfigs.REPLACE_FLOWING_WATER && theBlock == Blocks.field_150358_i);
    }

    private IBlockState getBlockStateBelow(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, -1, 0));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void itemToss(ItemTossEvent event) {
        Item item = event.getEntityItem().func_92059_d().func_77973_b();
        if (item == Item.func_150898_a((Block)ModBlocks.blockGrave) || item == ModItems.itemDeathList) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (ModConfigs.ALLOW_INVENTORY_LISTS && !event.isCanceled() && !event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("keepInventory") && ModConfigs.ALLOW_INVENTORY_SAVES && !event.getEntityLiving().field_70170_p.field_72995_K && event.isWasDeath()) {
            block0: for (int i = 0; i < event.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
                ItemStack item = (ItemStack)event.getOriginal().field_71071_by.field_70462_a.get(i);
                if (item.func_190926_b() || item.func_77973_b() != ModItems.itemDeathList) continue;
                for (int j = 0; j < event.getEntityPlayer().field_71071_by.field_70462_a.size(); ++j) {
                    if (!((ItemStack)event.getEntityPlayer().field_71071_by.field_70462_a.get(j)).func_190926_b()) continue;
                    event.getEntityPlayer().field_71071_by.field_70462_a.set(j, (Object)item.func_77946_l());
                    continue block0;
                }
            }
        }
    }
}

