/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import quaternary.botaniatweaks.modules.botania.block.BlockCompressedTinyPotato;
import vazkii.botania.common.block.decor.BlockTinyPotato;

public class MiscHelpers {
    private static ModContainer botaniaModContainer = null;

    public static ModContainer getBotaniaModContainer() {
        if (botaniaModContainer != null) {
            return botaniaModContainer;
        }
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equals("botania")) continue;
            botaniaModContainer = container;
            break;
        }
        if (botaniaModContainer == null) {
            throw new RuntimeException("Couldn't find Botania's mod container, is it not present? Whats goin on here");
        }
        return botaniaModContainer;
    }

    public static void makeNonFinal(Field f) {
        try {
            Field fModifiers = f.getClass().getDeclaredField("modifiers");
            fModifiers.setAccessible(true);
            fModifiers.set(f, f.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            throw new RuntimeException("java machine broke", e);
        }
    }

    public static ItemStack stackFromState(IBlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        try {
            return block.getPickBlock(state, null, null, null, null);
        }
        catch (Exception exception) {
            Item item = Item.func_150898_a((Block)block);
            if (item == Items.field_190931_a) {
                return ItemStack.field_190927_a;
            }
            return new ItemStack(item, 1, block.func_176201_c(state));
        }
    }

    public static List<ItemStack> getAllSubtypes(Iterable<ItemStack> stacks) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            for (CreativeTabs tab : stack.func_77973_b().getCreativeTabs()) {
                NonNullList subs = NonNullList.func_191196_a();
                try {
                    stack.func_77973_b().func_150895_a(tab, subs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ret.addAll((Collection<ItemStack>)subs);
            }
        }
        return ret;
    }

    public static int getPotatoCompressionLevel(Block b) {
        if (b instanceof BlockCompressedTinyPotato) {
            return ((BlockCompressedTinyPotato)b).compressionLevel;
        }
        if (b instanceof BlockTinyPotato) {
            return 0;
        }
        return -1;
    }

    public static void sendMeOrMySonChat(EntityPlayer p, int clickedCompression, int heldCompression) {
        TextComponentTranslation son = new TextComponentTranslation("botania_tweaks.son." + (heldCompression - clickedCompression), new Object[0]);
        TextComponentTranslation meormy = new TextComponentTranslation("botania_tweaks.donttalktome", new Object[]{son});
        p.func_145747_a((ITextComponent)meormy);
    }
}

