/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import quaternary.botaniatweaks.modules.botania.wsd.ManaStatisticsWsd;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.Botania;

public class BotaniaTweakerHooks {
    public static boolean orechidGog = Botania.gardenOfGlassLoaded;
    private static String lastFlowerName = null;
    private static int oldMana = 0;

    public static int getPassiveDecayTime() {
        return BotaniaConfig.PASSIVE_DECAY_TIMER;
    }

    public static boolean shouldFlowerDecay(String name) {
        return BotaniaConfig.SHOULD_ALSO_BE_PASSIVE_MAP.getOrDefault(name, false);
    }

    public static int getManastormBurstMana() {
        return MathHelper.func_76141_d((float)(120.0f * BotaniaConfig.MANASTORM_SCALE_FACTOR));
    }

    public static int getManastormBurstStartingMana() {
        return MathHelper.func_76141_d((float)(340.0f * BotaniaConfig.MANASTORM_SCALE_FACTOR));
    }

    public static float getManastormBurstLossjpgPerTick() {
        return BotaniaConfig.MANASTORM_SCALE_FACTOR;
    }

    public static int getRosaArcanaXPOrbMana() {
        return (int)(35.0f * BotaniaConfig.ROSA_ARCANA_ORB_MULTIPLIER);
    }

    public static List<EntityTNTPrimed> processTNTList(List<EntityTNTPrimed> inList) {
        Iterator<EntityTNTPrimed> it = inList.iterator();
        while (it.hasNext()) {
            EntityTNTPrimed tnt = it.next();
            if (BotaniaConfig.DENY_DUPLICATED_TNT && tnt.func_184216_O().contains("CheatyDupe")) {
                if (tnt.func_184536_l() == 1) {
                    BotaniaTweakerHooks.doTNTSilliness(tnt);
                }
                it.remove();
                continue;
            }
            if (!BotaniaConfig.FORCE_VANILLA_TNT || tnt.getClass().equals(EntityTNTPrimed.class)) continue;
            it.remove();
        }
        return inList;
    }

    static void doTNTSilliness(EntityTNTPrimed tnt) {
        try {
            NBTTagCompound fireworkNBT = JsonToNBT.func_180713_a((String)"{Fireworks:{Flight:1b,Explosions:[{Type:2b,Trail:1b,Colors:[I;15790320]},{Type:1b,Colors:[I;11743532],Flicker:1b}]}}");
            ItemStack fireworkItem = new ItemStack(Items.field_151152_bP, 1, 0);
            fireworkItem.func_77982_d(fireworkNBT);
            EntityFireworkRocket firework = new EntityFireworkRocket(tnt.field_70170_p, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, fireworkItem);
            firework.field_92055_b = 1;
            tnt.field_70170_p.func_72838_d((Entity)firework);
            List nearbyPlayers = tnt.field_70170_p.field_73010_i.stream().filter(player -> player.func_70068_e((Entity)tnt) < 625.0).collect(Collectors.toList());
            for (EntityPlayer p : nearbyPlayers) {
                TextComponentTranslation flowerName = new TextComponentTranslation("tile.botania:flower.entropinnyum.name", new Object[0]);
                TextComponentTranslation niceTry = new TextComponentTranslation("botania_tweaks.entrodupe.nicetry", new Object[0]);
                TextComponentTranslation chatString = new TextComponentTranslation("chat.type.text", new Object[]{flowerName, niceTry});
                p.func_145747_a((ITextComponent)chatString);
            }
            tnt.func_70106_y();
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
    }

    public static void beginManaStatSection(String flowerName, SubTileGenerating flower, int oldMana_) {
        if (!BotaniaConfig.MANA_GENERATION_STATISTICS || flower.getWorld().field_72995_K) {
            return;
        }
        lastFlowerName = flowerName = BotaniaTweakerHooks.fixThermalilyFlowerName(flowerName, flower);
        oldMana = oldMana_;
    }

    public static void endManaStatSection(String flowerName, SubTileGenerating flower, int newMana) {
        if (!BotaniaConfig.MANA_GENERATION_STATISTICS || flower.getWorld().field_72995_K) {
            return;
        }
        flowerName = BotaniaTweakerHooks.fixThermalilyFlowerName(flowerName, flower);
        int manaDifference = newMana - oldMana;
        if (flower.canGeneratePassively()) {
            manaDifference += flower.getWorld().func_82737_E() % (long)flower.getDelayBetweenPassiveGeneration() == 0L ? flower.getValueForPassiveGeneration() : 0;
        }
        if (manaDifference != 0) {
            ManaStatisticsWsd wsd = ManaStatisticsWsd.get(flower.getWorld());
            wsd.trackMana(flowerName, manaDifference);
        }
        lastFlowerName = null;
        oldMana = 0;
    }

    private static String fixThermalilyFlowerName(String flowerName, SubTileGenerating flower) {
        if (flowerName.equals("hydroangeas")) {
            String className = flower.getClass().getName();
            if (className.endsWith("Thermalily")) {
                return "thermalily";
            }
            return "hydroangeas";
        }
        return flowerName;
    }

    public static int getCreativePoolSize() {
        return BotaniaConfig.CREATIVE_POOL_SIZE;
    }

    public static float getKeyDamage() {
        return 20.0f * BotaniaConfig.KEY_DAMAGE_SCALE;
    }
}

