/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.net.PacketChat;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLeverRemote
extends BaseItem
implements IHasRecipe,
IContent {
    private static final int COOLDOWN = 20;
    private boolean enabled;

    public ItemLeverRemote() {
        this.func_77625_d(1);
    }

    @Override
    public String getContentName() {
        return "password_remote";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("Remote Lever", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        BlockPos pointer = UtilNBT.getItemStackBlockPos(stack);
        if (pointer != null) {
            int dimensionTarget = UtilNBT.getItemStackNBTVal(stack, "LeverDim");
            tooltip.add(TextFormatting.RED + UtilChat.blockPosToString(pointer) + " [" + dimensionTarget + "]");
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLever) {
            UtilNBT.setItemStackBlockPos(stack, pos);
            UtilNBT.setItemStackNBTVal(stack, "LeverDim", playerIn.field_71093_bK);
            if (worldIn.field_72995_K) {
                UtilChat.sendStatusMessage(playerIn, this.func_77658_a() + ".saved");
            }
            UtilSound.playSound(playerIn, SoundEvents.field_187750_dc);
            return EnumActionResult.SUCCESS;
        }
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            playerIn.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean trigger(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        BlockPos blockPos = UtilNBT.getItemStackBlockPos(stack);
        if (blockPos == null) {
            if (world.field_72995_K) {
                UtilChat.sendStatusMessage(player, this.func_77658_a() + ".invalid");
            }
            return false;
        }
        int dimensionTarget = UtilNBT.getItemStackNBTVal(stack, "LeverDim");
        if (dimensionTarget == player.field_71093_bK) {
            IBlockState blockState = world.func_180495_p(blockPos);
            if (blockState == null || blockState.func_177230_c() != Blocks.field_150442_at) {
                if (world.field_72995_K) {
                    UtilChat.sendStatusMessage(player, this.func_77658_a() + ".invalid");
                }
                return false;
            }
            blockState = world.func_180495_p(blockPos);
            boolean hasPowerHere = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
            UtilWorld.toggleLeverPowerState(world, blockPos, blockState);
            UtilChat.sendStatusMessage(player, this.func_77658_a() + ".powered." + hasPowerHere);
            UtilSound.playSound(player, SoundEvents.field_187750_dc);
            UtilEntity.setCooldownItem(player, this, 20);
            return true;
        }
        if (player instanceof EntityPlayerMP && !world.field_72995_K) {
            try {
                EntityPlayerMP mp = (EntityPlayerMP)player;
                WorldServer dw = mp.func_184102_h().func_71218_a(dimensionTarget);
                if (dw == null) {
                    ModCyclic.network.sendTo((IMessage)new PacketChat("dimension.notfound", true), mp);
                    return false;
                }
                if (!dw.func_175697_a(blockPos, 2)) {
                    ModCyclic.network.sendTo((IMessage)new PacketChat("chunk.unloaded", true), mp);
                    return false;
                }
                IBlockState blockState = dw.func_180495_p(blockPos);
                boolean hasPowerHere = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
                UtilWorld.toggleLeverPowerState((World)dw, blockPos, blockState);
                ModCyclic.network.sendTo((IMessage)new PacketChat(this.func_77658_a() + ".powered." + hasPowerHere, true), mp);
                UtilSound.playSound(player, SoundEvents.field_187750_dc);
                UtilEntity.setCooldownItem(player, this, 20);
                return true;
            }
            catch (Throwable e) {
                ModCyclic.logger.error("Dimension find error; safe to ignore", e);
            }
        }
        return false;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " s ", " t ", " l ", Character.valueOf('l'), new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.STONE.func_176624_a()), Character.valueOf('s'), Blocks.field_150430_aB, Character.valueOf('t'), Blocks.field_150442_at);
    }
}

