/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump.item;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cablepump.TileEntityBasePump;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.data.ITileStackWrapper;
import com.lothrazar.cyclicmagic.gui.container.StackWrapper;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityItemPump
extends TileEntityBasePump
implements ITileStackWrapper,
ITickable,
ITileRedstoneToggle {
    private NonNullList<StackWrapper> stacksWrapped = NonNullList.func_191197_a((int)9, (Object)new StackWrapper());
    private static final int SLOT_TRANSFER = 0;
    private int itemTransferCooldown = 0;
    private int filterType = 0;

    public TileEntityItemPump() {
        super(1);
        this.setSlotsForExtract(0);
        this.setSlotsForInsert(0);
        this.speed = 1;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case FILTERTYPE: {
                return this.filterType;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case FILTERTYPE: {
                this.filterType = value % 2;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case SPEED: {
                this.speed = value;
            }
        }
    }

    private boolean isWhitelist() {
        return this.filterType == 1;
    }

    private boolean isStackInvalid(ItemStack stackToTest) {
        List<ItemStack> inventoryContents = this.getFilterNonempty();
        if (OreDictionary.containsMatch((boolean)true, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])inventoryContents.toArray(new ItemStack[0])), (ItemStack[])new ItemStack[]{stackToTest})) {
            return !this.isWhitelist();
        }
        return this.isWhitelist();
    }

    private List<ItemStack> getFilterNonempty() {
        ArrayList<ItemStack> filt = new ArrayList<ItemStack>();
        for (StackWrapper wrap : this.stacksWrapped) {
            if (wrap.isEmpty()) continue;
            filt.add(wrap.getStack().func_77946_l());
        }
        return filt;
    }

    @Override
    public EnumFacing getCurrentFacing() {
        EnumFacing facingTo = super.getCurrentFacing();
        if (facingTo.func_176740_k().func_176720_b()) {
            facingTo = facingTo.func_176734_d();
        }
        return facingTo;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.tryExport();
        this.tryImport();
    }

    public void tryExport() {
        if (this.func_70301_a(0).func_190926_b()) {
            return;
        }
        boolean outputSuccess = false;
        ItemStack stackToExport = this.func_70301_a(0).func_77946_l();
        List<EnumFacing> sidesOut = this.getSidesNotFacing();
        for (EnumFacing facingDir : sidesOut) {
            TileEntityCableBase cable;
            if (!this.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facingDir)) continue;
            EnumFacing themFacingMe = facingDir.func_176734_d();
            BlockPos posTarget = this.field_174879_c.func_177972_a(facingDir);
            TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
            if (tileTarget == null || !tileTarget.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, themFacingMe) || (stackToExport = this.func_70301_a(0).func_77946_l()).func_190926_b()) continue;
            ItemStack leftAfterDeposit = UtilItemStack.tryDepositToHandler(this.field_145850_b, posTarget, themFacingMe, stackToExport);
            if (leftAfterDeposit.func_190926_b() || leftAfterDeposit.func_190916_E() != stackToExport.func_190916_E()) {
                this.func_70299_a(0, leftAfterDeposit);
                outputSuccess = true;
            }
            if (outputSuccess && this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facingDir)) instanceof TileEntityCableBase && (cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facingDir))).isItemPipe()) {
                cable.updateIncomingItemFace(themFacingMe);
            }
            if (!outputSuccess) continue;
            break;
        }
    }

    public void tryImport() {
        if (!this.func_70301_a(0).func_190926_b()) {
            return;
        }
        EnumFacing importFromSide = this.getCurrentFacing();
        BlockPos posTarget = this.field_174879_c.func_177972_a(importFromSide);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return;
        }
        if (tileTarget.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, importFromSide.func_176734_d())) {
            IItemHandler itemHandlerFrom = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, importFromSide.func_176734_d());
            for (int i = 0; i < itemHandlerFrom.getSlots(); ++i) {
                ItemStack pulled;
                ItemStack itemTarget = itemHandlerFrom.getStackInSlot(i);
                if (itemTarget.func_190926_b() || this.isStackInvalid(itemTarget) || (pulled = itemHandlerFrom.extractItem(i, this.speed, false)) == null || pulled.func_190926_b()) continue;
                this.func_70299_a(0, pulled.func_77946_l());
                return;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemTransferCooldown = compound.func_74762_e("itemTransferCooldown");
        this.needsRedstone = compound.func_74762_e("redstone");
        this.filterType = compound.func_74762_e("wbtype");
        this.readStackWrappers(this.stacksWrapped, compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeStackWrappers(this.stacksWrapped, compound);
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("itemTransferCooldown", this.itemTransferCooldown);
        compound.func_74768_a("wbtype", this.filterType);
        return super.func_189515_b(compound);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public StackWrapper getStackWrapper(int i) {
        return (StackWrapper)this.stacksWrapped.get(i);
    }

    @Override
    public void setStackWrapper(int i, StackWrapper stack) {
        this.stacksWrapped.set(i, (Object)stack);
    }

    @Override
    public int getWrapperCount() {
        return this.stacksWrapped.size();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public static enum Fields {
        REDSTONE,
        FILTERTYPE,
        SPEED;

    }
}

