/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump.fluid;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cablepump.TileEntityBasePump;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankBase;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPump
extends TileEntityBasePump
implements ITickable,
ITileRedstoneToggle {
    private int transferRate = 1000;

    public TileEntityFluidPump() {
        super(0);
        this.tank = new FluidTankBase(1000);
    }

    @Override
    public EnumFacing getCurrentFacing() {
        EnumFacing facingTo = super.getCurrentFacing();
        if (facingTo.func_176740_k().func_176720_b()) {
            facingTo = facingTo.func_176734_d();
        }
        return facingTo;
    }

    public void func_73660_a() {
        if (!this.isPowered() && this.onlyRunIfPowered()) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(this.getCurrentFacing());
        UtilFluid.tryFillTankFromPosition(this.field_145850_b, target, this.getCurrentFacing().func_176734_d(), this.tank, this.transferRate);
        if (this.field_145850_b.func_180495_p(target).func_185904_a().func_76224_d()) {
            UtilParticle.spawnParticle(this.field_145850_b, EnumParticleTypes.WATER_BUBBLE, target);
            IFluidHandler handle = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)target, (EnumFacing)EnumFacing.UP);
            FluidStack fs = handle.getTankProperties()[0].getContents();
            if (fs != null && this.tank.canFillFluidType(fs)) {
                this.tank.fill(fs, true);
            }
        }
        List<EnumFacing> sidesOut = this.getSidesNotFacing();
        Collections.shuffle(sidesOut);
        for (EnumFacing exportToSide : sidesOut) {
            this.moveItems(exportToSide);
        }
    }

    private void moveItems(EnumFacing myFacingDir) {
        TileEntityCableBase cable;
        if (!this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, myFacingDir)) {
            return;
        }
        EnumFacing themFacingMe = myFacingDir.func_176734_d();
        boolean outputSuccess = UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c.func_177972_a(myFacingDir), themFacingMe, this.tank, this.transferRate);
        if (outputSuccess && this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(myFacingDir)) instanceof TileEntityCableBase && (cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(myFacingDir))).isFluidPipe()) {
            cable.updateIncomingFluidFace(themFacingMe);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.transferRate = compound.func_74762_e("transferSaved");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("transferSaved", this.transferRate);
        return super.func_189515_b(compound);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                if (value <= 0) break;
                this.transferRate = value;
            }
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE;

    }
}

