/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.RecipeAdapter;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractAltarRecipe {
    private AbstractAltarRecipe specialEffectRecovery = null;
    private int experiencePerCraft = 5;
    private int passiveStarlightRequirement;
    private final TileAltar.AltarLevel neededLevel;
    private final AccessibleRecipe recipe;
    private ItemStack out;
    private int uniqueRecipeId = -1;

    public AbstractAltarRecipe(TileAltar.AltarLevel neededLevel, AccessibleRecipe recipe) {
        this.neededLevel = neededLevel;
        this.recipe = recipe;
        this.out = recipe.func_77571_b();
    }

    public final void updateUniqueId(int id) {
        this.uniqueRecipeId = id;
    }

    public final int getUniqueRecipeId() {
        return this.uniqueRecipeId;
    }

    public final void setSpecialEffectRecovery(AbstractAltarRecipe specialEffectRecovery) {
        this.specialEffectRecovery = specialEffectRecovery;
    }

    @Nullable
    protected ActiveCraftingTask getCurrentTask(TileAltar ta) {
        return ta.getActiveCraftingTask();
    }

    @Nonnull
    public ItemStack getOutputForRender() {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    public AccessibleRecipe getNativeRecipe() {
        return this.recipe;
    }

    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    @Nonnull
    public ItemStack getOutputForMatching() {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        if (!ignoreStarlightRequirement && !this.fulfillesStarlightRequirement(altar)) {
            return false;
        }
        if (this instanceof IGatedRecipe && altar.func_145831_w().field_72995_K && !((IGatedRecipe)((Object)this)).hasProgressionClient()) {
            return false;
        }
        if (this instanceof INighttimeRecipe && !ConstellationSkyHandler.getInstance().isNight(altar.func_145831_w())) {
            return false;
        }
        int slotsContainRecipe = this.getNeededLevel().getAccessibleInventorySize();
        for (int slotId = 0; slotId < invHandler.getSlots(); ++slotId) {
            if (slotId < slotsContainRecipe || invHandler.getStackInSlot(slotId).func_190926_b()) continue;
            return false;
        }
        ItemStack[] altarInv = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            altarInv[i] = invHandler.getStackInSlot(i);
        }
        RecipeAdapter adapter = new RecipeAdapter(altar.getCraftingRecipeWidth(), altar.getCraftingRecipeHeight());
        adapter.fill(altarInv);
        return this.recipe.func_77569_a(adapter, altar.func_145831_w());
    }

    public boolean fulfillesStarlightRequirement(TileAltar altar) {
        return altar.getStarlightStored() >= this.getPassiveStarlightRequired();
    }

    public AbstractAltarRecipe setPassiveStarlightRequirement(int starlightRequirement) {
        this.passiveStarlightRequirement = starlightRequirement;
        return this;
    }

    public int getPassiveStarlightRequired() {
        return this.passiveStarlightRequirement;
    }

    public AbstractAltarRecipe setCraftExperience(int exp) {
        this.experiencePerCraft = exp;
        return this;
    }

    public boolean allowsForChaining() {
        return true;
    }

    public int getCraftExperience() {
        return this.experiencePerCraft;
    }

    public float getCraftExperienceMultiplier() {
        return 1.0f;
    }

    public TileAltar.AltarLevel getNeededLevel() {
        return this.neededLevel;
    }

    public int craftingTickTime() {
        return 100;
    }

    public void handleInputConsumption(TileAltar ta, ActiveCraftingTask craftingTask, ItemStackHandler inventory) {
    }

    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
        return !this.requiresSpecialConsumption(this.recipe.getExpectedStackHandle(slot), ta.getInventoryHandler().getStackInSlot(slot.getSlotID()));
    }

    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        if (!(this instanceof AttunementRecipe)) {
            return true;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        return !this.requiresSpecialConsumption(thisRecipe.getAttItemHandle(slot), ta.getInventoryHandler().getStackInSlot(slot.getSlotId()));
    }

    public boolean mayDecrement(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        if (!(this instanceof ConstellationRecipe)) {
            return true;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        return !this.requiresSpecialConsumption(thisRecipe.getCstItemHandle(slot), ta.getInventoryHandler().getStackInSlot(slot.getSlotId()));
    }

    public boolean mayDecrement(TileAltar ta, TraitRecipe.TraitRecipeSlot slot) {
        if (!(this instanceof TraitRecipe)) {
            return true;
        }
        TraitRecipe thisRecipe = (TraitRecipe)this;
        return !this.requiresSpecialConsumption(thisRecipe.getInnerTraitItemHandle(slot), ta.getInventoryHandler().getStackInSlot(slot.getSlotId()));
    }

    protected boolean requiresSpecialConsumption(ItemHandle handle, ItemStack stack) {
        return handle != null && !stack.func_190926_b() && (!ForgeHooks.getContainerItem((ItemStack)stack).func_190926_b() || handle.handleType == ItemHandle.Type.FLUID && FluidUtil.getFluidContained((ItemStack)stack) != null);
    }

    public void handleItemConsumption(TileAltar ta, ShapedRecipeSlot slot) {
        ItemHandle handle = this.recipe.getExpectedStackHandle(slot);
        if (handle == null) {
            return;
        }
        this.consumeAndSetResult((IItemHandlerModifiable)ta.getInventoryHandler(), slot.getSlotID(), handle);
    }

    public void handleItemConsumption(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        if (!(this instanceof AttunementRecipe)) {
            return;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        ItemHandle handle = thisRecipe.getAttItemHandle(slot);
        if (handle == null) {
            return;
        }
        this.consumeAndSetResult((IItemHandlerModifiable)ta.getInventoryHandler(), slot.getSlotId(), handle);
    }

    public void handleItemConsumption(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        if (!(this instanceof ConstellationRecipe)) {
            return;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        ItemHandle handle = thisRecipe.getCstItemHandle(slot);
        if (handle == null) {
            return;
        }
        this.consumeAndSetResult((IItemHandlerModifiable)ta.getInventoryHandler(), slot.getSlotId(), handle);
    }

    public void handleItemConsumption(TileAltar ta, TraitRecipe.TraitRecipeSlot slot) {
        if (!(this instanceof TraitRecipe)) {
            return;
        }
        TraitRecipe thisRecipe = (TraitRecipe)this;
        ItemHandle handle = thisRecipe.getInnerTraitItemHandle(slot);
        if (handle == null) {
            return;
        }
        this.consumeAndSetResult((IItemHandlerModifiable)ta.getInventoryHandler(), slot.getSlotId(), handle);
    }

    protected void consumeAndSetResult(IItemHandlerModifiable inv, int slot, ItemHandle handle) {
        ItemStack stack = inv.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (fs != null && handle.handleType == ItemHandle.Type.FLUID) {
                FluidActionResult fas = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true);
                if (fas.isSuccess()) {
                    inv.setStackInSlot(slot, fas.getResult());
                }
            } else {
                inv.setStackInSlot(slot, ForgeHooks.getContainerItem((ItemStack)stack));
            }
        }
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, Item out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, Block out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, ItemStack out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    public void applyOutputModificationsServer(TileAltar ta, Random rand) {
    }

    public void onCraftServerFinish(TileAltar altar, Random rand) {
    }

    public void onCraftServerTick(TileAltar altar, ActiveCraftingTask.CraftingState state, int tick, int totalCraftingTime, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        if (this.specialEffectRecovery != null) {
            try {
                this.specialEffectRecovery.onCraftClientTick(altar, state, tick, rand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftTESRRender(TileAltar te, double x, double y, double z, float partialTicks) {
        if (this.specialEffectRecovery != null) {
            try {
                this.specialEffectRecovery.onCraftTESRRender(te, x, y, z, partialTicks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

