/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.items.sigils;

import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.teamdman.animus.common.util.AnimusUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemSigilStorm
extends ItemSigilBase
implements IVariantProvider {
    public static final String EFFECT_RANGE = "effect";
    protected final Map<String, AreaDescriptor> modableRangeMap = new HashMap<String, AreaDescriptor>();

    public ItemSigilStorm() {
        super("storm", 500);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Random rand = new Random();
        BlockPos pos = null;
        RayTraceResult result = AnimusUtil.raytraceFromEntity(world, (Entity)player, true, 64.0);
        if (result != null) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                pos = result.func_178782_a();
            }
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                pos = result.field_72308_g.func_180425_c();
            }
            if (pos == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), false));
            IBlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150358_i || world.field_72995_K)) {
                EntityItem fish = new EntityItem(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - rand.nextInt(2)), (double)pos.func_177952_p(), new ItemStack(Items.field_151115_aP, 1 + rand.nextInt(2)));
                fish.func_70016_h(rand.nextDouble() * 0.25, -0.25, rand.nextDouble() * 0.25);
                fish.func_184224_h(true);
                world.func_72838_d((Entity)fish);
            }
            if (world.func_72896_J()) {
                this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-1, -1, -1), 4));
                AreaDescriptor damageRange = this.getBlockRange(EFFECT_RANGE);
                AxisAlignedBB range = damageRange.getAABB(pos);
                List list = world.func_72872_a(EntityLivingBase.class, range);
                DamageSource storm = new DamageSource("animus.storm").func_76348_h().func_151518_m();
                for (EntityLivingBase livingEntity : list) {
                    if (livingEntity == player) continue;
                    int damage = Math.max(6, rand.nextInt(15));
                    livingEntity.func_70097_a(storm, (float)damage);
                }
            }
            NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.storm", new Object[0]), this.getLpUsed()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void addBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.put(range, defaultRange);
    }

    public AreaDescriptor getBlockRange(String range) {
        if (this.modableRangeMap.containsKey(range)) {
            return this.modableRangeMap.get(range);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextHelper.localize((String)"tooltip.animus.sigil.storm.flavour", (Object[])new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }
}

