/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.common.collect.Lists;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.render.EmojiFontRenderer;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="emojiful", name="Emojiful", version="1.0.3", clientSideOnly=true)
public class Emojiful {
    public static final String MODID = "emojiful";
    public static final String VERSION = "1.0.3";
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final Map<String, List<Emoji>> EMOJI_MAP = new HashMap<String, List<Emoji>>();
    public static final List<Emoji> EMOJI_LIST = new ArrayList<Emoji>();
    boolean error = false;

    public static void main(String[] s) throws YamlException {
        YamlReader reader = new YamlReader(new StringReader(Emojiful.readStringFromURL("https://raw.githubusercontent.com/HrznStudio/Emojiful/master/Categories.yml")));
        ArrayList categories = (ArrayList)reader.read();
        for (String category : categories) {
            List<Emoji> emojis = Emojiful.readCategory(category);
            EMOJI_LIST.addAll(emojis);
            EMOJI_MAP.put(category, emojis);
        }
    }

    public static List<Emoji> readCategory(String cat) throws YamlException {
        YamlReader categoryReader = new YamlReader(new StringReader(Emojiful.readStringFromURL("https://raw.githubusercontent.com/HrznStudio/Emojiful/master/" + cat)));
        return Lists.newArrayList((Object[])categoryReader.read(Emoji[].class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStringFromURL(String requestURL) {
        try (Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        try {
            YamlReader reader = new YamlReader(new StringReader(Emojiful.readStringFromURL("https://raw.githubusercontent.com/HrznStudio/Emojiful/master/Categories.yml")));
            ArrayList categories = (ArrayList)reader.read();
            for (String category : categories) {
                List<Emoji> emojis = Emojiful.readCategory(category);
                EMOJI_LIST.addAll(emojis);
                EMOJI_MAP.put(category, emojis);
            }
        }
        catch (YamlException e) {
            this.error = true;
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        if (!this.error) {
            Emojiful.MC.field_71466_p = new EmojiFontRenderer(MC);
        }
    }
}

