/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.baselegacy.AbstractPowerConsumerBlock;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.forge.item.PoweredBlockItem;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.spawner.DummyRecipe;
import crazypants.enderio.base.recipe.spawner.EntityDataRegistry;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machines.machine.spawner.GuiPoweredSpawner;
import crazypants.enderio.machines.machine.spawner.PoweredSpawnerSpecialRenderer;
import crazypants.enderio.machines.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPoweredSpawner
extends AbstractPoweredTaskBlock<TilePoweredSpawner>
implements IAdvancedTooltipProvider,
IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IHaveTESR {
    @Nonnull
    public static final String KEY_SPAWNED_BY_POWERED_SPAWNER = "spawnedByPoweredSpawner";
    private Field fieldpersistenceRequired;

    public static BlockPoweredSpawner create(@Nonnull IModObject modObject) {
        MachineRecipeRegistry.instance.registerRecipe(MachineObject.block_powered_spawner.getUnlocalisedName(), (IMachineRecipe)new DummyRecipe());
        BlockPoweredSpawner res = new BlockPoweredSpawner(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockPoweredSpawner(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID, BlockFaceShape.SOLID, BlockFaceShape.UNDEFINED, BlockFaceShape.SOLID));
        try {
            this.fieldpersistenceRequired = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"field_82179_bU", "persistenceRequired"});
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"BlockPoweredSpawner: Could not find field: persistenceRequired"});
        }
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (Prep.isInvalid((ItemStack)evt.getLeft()) || evt.getLeft().func_190916_E() != 1 || evt.getLeft().func_77973_b() != MachineObject.block_powered_spawner.getItem()) {
            return;
        }
        if (Prep.isInvalid((ItemStack)evt.getRight()) || evt.getRight().func_190916_E() != 1 || evt.getRight().func_77973_b() != ModObject.itemBrokenSpawner.getItem()) {
            return;
        }
        CapturedMob spawnerType = CapturedMob.create((ItemStack)evt.getRight());
        if (spawnerType == null || BlockPoweredSpawner.isBlackListed(spawnerType.getEntityName())) {
            return;
        }
        evt.setCost(((Integer)SpawnerConfig.powerSpawnerAddSpawnerCost.get()).intValue());
        evt.setOutput(evt.getLeft().func_77946_l());
        evt.getOutput().func_77982_d(spawnerType.toNbt(evt.getOutput().func_77978_p()));
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent livingUpdate) {
        EntityLivingBase ent = livingUpdate.getEntityLiving();
        if (!ent.getEntityData().func_74764_b(KEY_SPAWNED_BY_POWERED_SPAWNER)) {
            return;
        }
        if (this.fieldpersistenceRequired == null) {
            ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            return;
        }
        long spawnTime = ent.getEntityData().func_74763_f(KEY_SPAWNED_BY_POWERED_SPAWNER);
        long livedFor = livingUpdate.getEntity().field_70170_p.func_82737_E() - spawnTime;
        if (livedFor > (long)((Integer)SpawnerConfig.poweredSpawnerDespawnTimeSeconds.get() * 20)) {
            try {
                this.fieldpersistenceRequired.setBoolean(livingUpdate.getEntityLiving(), false);
                ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
            catch (Exception e) {
                Log.warn((Object[])new Object[]{"BlockPoweredSpawner.onLivingUpdate: Error occured allowing entity to despawn: " + e});
                ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
        }
    }

    public static boolean isBlackListed(@Nonnull ResourceLocation entityId) {
        return EntityDataRegistry.getInstance().isBlackListedForSpawning(entityId);
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TilePoweredSpawner te) {
        return new ContainerPoweredSpawner(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TilePoweredSpawner te) {
        return new GuiPoweredSpawner(player.field_71071_by, te);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        CapturedMob mob = CapturedMob.create((ItemStack)itemstack);
        if (mob != null) {
            list.add(mob.getDisplayName());
            list.add(Lang.TOOLTIP_SPAWNER_COST.get(new Object[]{LangPower.FLOAT_NF.format(EntityDataRegistry.getInstance().getCostMultiplierFor(mob.getEntityName()))}));
        } else {
            list.add(Lang.SPAWNER_EMPTY.get());
        }
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        if (CapturedMob.containsSoul((ItemStack)itemstack)) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.block_powered_spawner");
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.block_powered_spawner.empty");
        }
    }

    @Nullable
    public PoweredBlockItem createBlockItem(@Nonnull IModObject modObject) {
        return (PoweredBlockItem)modObject.apply((Item)new PoweredBlockItem((AbstractPowerConsumerBlock)this){

            @Nonnull
            public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
                ItemStack itemstack = player.func_184586_b(hand);
                if (CapturedMob.containsSoul((ItemStack)itemstack)) {
                    return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                }
                player.func_146105_b((ITextComponent)Lang.STATUS_SPAWNER_UNBOUND.toChatServer(), true);
                return EnumActionResult.FAIL;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, final @Nonnull NonNullList<ItemStack> list) {
        super.func_149666_a(tab, list);
        if (((Boolean)SpawnerConfig.poweredSpawnerAddAllMobsCreative.get()).booleanValue()) {
            CapturedMob.getAllSouls().apply((NNList.Callback)new NNList.Callback<CapturedMob>(){

                public void apply(@Nonnull CapturedMob mob) {
                    if (!EntityDataRegistry.getInstance().isBlackListedForSpawning(mob.getEntityName())) {
                        list.add((Object)mob.toStack((Block)BlockPoweredSpawner.this, 0, 1));
                    }
                }
            });
        } else {
            list.add((Object)CapturedMob.create((ResourceLocation)new ResourceLocation("enderman")).toStack((Block)this, 0, 1));
            list.add((Object)CapturedMob.create((ResourceLocation)new ResourceLocation("chicken")).toStack((Block)this, 0, 1));
            list.add((Object)CapturedMob.create((ResourceLocation)new ResourceLocation("skeleton")).toStack((Block)this, 0, 1));
            list.add((Object)CapturedMob.create((ResourceLocation)new ResourceLocation("wither_skeleton")).toStack((Block)this, 0, 1));
            list.add((Object)CapturedMob.create((ResourceLocation)new ResourceLocation("stray")).toStack((Block)this, 0, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.SOUL_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.SOUL_MAPPER;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TilePoweredSpawner tileEntity) {
        blockStateWrapper.addCacheKey((Object)tileEntity.getFacing()).addCacheKey((Object)tileEntity.isActive());
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TilePoweredSpawner.class, (TileEntitySpecialRenderer)new PoweredSpawnerSpecialRenderer());
    }
}

