/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.render.util.HalfBakedQuad;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class ObeliskBakery {
    private static final float WIDE_PINCH = 0.9f;
    private static final float WIDTH = 0.50624996f;
    private static final float HEIGHT = 0.475f;
    @Nonnull
    private static final BoundingBox bb1 = BoundingBox.UNIT_CUBE.scale(0.50624996f, 0.475f, 1.0f).translate(0.0f, -0.2625f, 0.0f);
    @Nonnull
    private static final BoundingBox bb2 = BoundingBox.UNIT_CUBE.scale(1.0f, 0.475f, 0.50624996f).translate(0.0f, -0.2625f, 0.0f);
    @Nonnull
    private static final VertXForm2x xform2x = new VertXForm2x();
    @Nonnull
    private static final VertXForm2z xform2z = new VertXForm2z();
    @Nonnull
    private static final VertXForm3 xform3 = new VertXForm3();

    private ObeliskBakery() {
    }

    public static List<BakedQuad> bake(TextureRegistry.TextureSupplier[] texs) {
        TextureAtlasSprite[] icons = new TextureAtlasSprite[6];
        for (int i = 0; i < icons.length; ++i) {
            icons[i] = (TextureAtlasSprite)texs[i].get(TextureAtlasSprite.class);
        }
        HalfBakedQuad.HalfBakedList buffer1 = new HalfBakedQuad.HalfBakedList();
        HalfBakedQuad.HalfBakedList buffer2 = new HalfBakedQuad.HalfBakedList();
        HalfBakedQuad.HalfBakedList buffer3 = new HalfBakedQuad.HalfBakedList();
        buffer1.add(bb1, EnumFacing.UP, 0.0f, 1.0f, 0.0f, 1.0f, icons[EnumFacing.UP.ordinal()], null);
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
            buffer1.add(bb1, face, 0.0f, 1.0f, 0.0f, 1.0f, icons[face.ordinal()], null);
            buffer2.add(bb2, face, 0.0f, 1.0f, 0.0f, 1.0f, icons[face.ordinal()], null);
        }
        buffer3.add(BoundingBox.UNIT_CUBE, EnumFacing.DOWN, 0.0f, 1.0f, 0.0f, 1.0f, icons[EnumFacing.DOWN.ordinal()], null);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        buffer1.bake(quads, new VertexTransform[]{xform2z});
        buffer2.bake(quads, new VertexTransform[]{xform2x});
        buffer3.bake(quads, new VertexTransform[]{xform3});
        return quads;
    }

    private static class VertXForm3
    implements VertexTransform {
        private VertXForm3() {
        }

        public void apply(@Nonnull Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(@Nonnull Vector3d vec) {
            vec.x -= 0.5;
            vec.x *= (double)0.9f;
            vec.x += 0.5;
            vec.z -= 0.5;
            vec.z *= (double)0.9f;
            vec.z += 0.5;
        }

        public void applyToNormal(@Nonnull Vector3f vec) {
        }
    }

    private static class VertXForm2z
    implements VertexTransform {
        private VertXForm2z() {
        }

        public void apply(@Nonnull Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(@Nonnull Vector3d vec) {
            double pinch = 0.9f;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            vec.z -= 0.5;
            vec.z *= pinch;
            vec.z += 0.5;
        }

        public void applyToNormal(@Nonnull Vector3f vec) {
        }
    }

    private static class VertXForm2x
    implements VertexTransform {
        private VertXForm2x() {
        }

        public void apply(@Nonnull Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(@Nonnull Vector3d vec) {
            double pinch = 0.9f;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            vec.x -= 0.5;
            vec.x *= pinch;
            vec.x += 0.5;
        }

        public void applyToNormal(@Nonnull Vector3f vec) {
        }
    }
}

