/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.ScreenChatOptions;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.input.Keyboard;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class MinecraftPatch
extends Patch {
    public static final int KEY_UNUSED = 84;

    @Override
    public boolean apply(ClassNode node) {
        if (!RandomPatches.ITLT_INSTALLED && !RandomPatches.DEFAULT_WINDOW_TITLE.equals(RPConfig.Window.title)) {
            MinecraftPatch.patchCreateDisplay(MinecraftPatch.findMethod(node, "createDisplay", "func_175609_am"));
        }
        if (RPConfig.Client.isNarratorKeybindEnabled()) {
            MinecraftPatch.patchDispatchKeypresses(MinecraftPatch.findMethod(node, "dispatchKeypresses", "func_152348_aa"));
        }
        return true;
    }

    public static void handleKeypress() {
        int key;
        if (ToggleNarratorKeybind.keybind == null) {
            return;
        }
        int eventKey = Keyboard.getEventKey();
        int n = key = eventKey == 0 ? Keyboard.getEventCharacter() + 256 : eventKey;
        if (!ToggleNarratorKeybind.keybind.isActiveAndMatches(key)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.func_74306_a(GameSettings.Options.NARRATOR, 1);
        if (mc.field_71462_r instanceof ScreenChatOptions) {
            ((ScreenChatOptions)mc.field_71462_r).func_193024_a();
        }
    }

    private static void patchCreateDisplay(MethodNode method) {
        LdcInsnNode ldc = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode setTitle = (MethodInsnNode)instruction;
            if (!"setTitle".equals(setTitle.name)) continue;
            ldc = (LdcInsnNode)setTitle.getPrevious();
        }
        ldc.cst = RPConfig.Window.title;
    }

    private static void patchDispatchKeypresses(MethodNode method) {
        IntInsnNode isB = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction.getOpcode() != 16) continue;
            isB = (IntInsnNode)instruction;
            if (isB.operand == 48) break;
            isB = null;
        }
        MethodInsnNode callHandleKeypress = new MethodInsnNode(184, MinecraftPatch.getName(MinecraftPatch.class), "handleKeypress", "()V", false);
        method.instructions.insertBefore(isB.getPrevious(), (AbstractInsnNode)callHandleKeypress);
        isB.operand = 84;
    }

    public static final class ToggleNarratorKeybind {
        public static KeyBinding keybind;

        public static void register() {
            keybind = new KeyBinding("key.narrator", new IKeyConflictContext(){

                public boolean isActive() {
                    return !(Minecraft.func_71410_x().field_71462_r instanceof GuiControls);
                }

                public boolean conflicts(IKeyConflictContext other) {
                    return true;
                }
            }, KeyModifier.CONTROL, 48, "key.categories.misc");
            ClientRegistry.registerKeyBinding((KeyBinding)keybind);
        }
    }
}

